/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.util.ByteProcessor;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class ByteProcessorTest {
    @Test
    public void testForward() {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"abc\r\n\ndef\r\rghi\n\njkl\u0000\u0000mno  \t\tx", (Charset)CharsetUtil.ISO_8859_1);
        int length = buf.readableBytes();
        Assertions.assertEquals((int)3, (int)buf.forEachByte(0, length, ByteProcessor.FIND_CRLF));
        Assertions.assertEquals((int)6, (int)buf.forEachByte(3, length - 3, ByteProcessor.FIND_NON_CRLF));
        Assertions.assertEquals((int)9, (int)buf.forEachByte(6, length - 6, ByteProcessor.FIND_CR));
        Assertions.assertEquals((int)11, (int)buf.forEachByte(9, length - 9, ByteProcessor.FIND_NON_CR));
        Assertions.assertEquals((int)14, (int)buf.forEachByte(11, length - 11, ByteProcessor.FIND_LF));
        Assertions.assertEquals((int)16, (int)buf.forEachByte(14, length - 14, ByteProcessor.FIND_NON_LF));
        Assertions.assertEquals((int)19, (int)buf.forEachByte(16, length - 16, ByteProcessor.FIND_NUL));
        Assertions.assertEquals((int)21, (int)buf.forEachByte(19, length - 19, ByteProcessor.FIND_NON_NUL));
        Assertions.assertEquals((int)24, (int)buf.forEachByte(19, length - 19, ByteProcessor.FIND_ASCII_SPACE));
        Assertions.assertEquals((int)24, (int)buf.forEachByte(21, length - 21, ByteProcessor.FIND_LINEAR_WHITESPACE));
        Assertions.assertEquals((int)28, (int)buf.forEachByte(24, length - 24, ByteProcessor.FIND_NON_LINEAR_WHITESPACE));
        Assertions.assertEquals((int)-1, (int)buf.forEachByte(28, length - 28, ByteProcessor.FIND_LINEAR_WHITESPACE));
        buf.release();
    }

    @Test
    public void testBackward() {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"abc\r\n\ndef\r\rghi\n\njkl\u0000\u0000mno  \t\tx", (Charset)CharsetUtil.ISO_8859_1);
        int length = buf.readableBytes();
        Assertions.assertEquals((int)27, (int)buf.forEachByteDesc(0, length, ByteProcessor.FIND_LINEAR_WHITESPACE));
        Assertions.assertEquals((int)25, (int)buf.forEachByteDesc(0, length, ByteProcessor.FIND_ASCII_SPACE));
        Assertions.assertEquals((int)23, (int)buf.forEachByteDesc(0, 28, ByteProcessor.FIND_NON_LINEAR_WHITESPACE));
        Assertions.assertEquals((int)20, (int)buf.forEachByteDesc(0, 24, ByteProcessor.FIND_NUL));
        Assertions.assertEquals((int)18, (int)buf.forEachByteDesc(0, 21, ByteProcessor.FIND_NON_NUL));
        Assertions.assertEquals((int)15, (int)buf.forEachByteDesc(0, 19, ByteProcessor.FIND_LF));
        Assertions.assertEquals((int)13, (int)buf.forEachByteDesc(0, 16, ByteProcessor.FIND_NON_LF));
        Assertions.assertEquals((int)10, (int)buf.forEachByteDesc(0, 14, ByteProcessor.FIND_CR));
        Assertions.assertEquals((int)8, (int)buf.forEachByteDesc(0, 11, ByteProcessor.FIND_NON_CR));
        Assertions.assertEquals((int)5, (int)buf.forEachByteDesc(0, 9, ByteProcessor.FIND_CRLF));
        Assertions.assertEquals((int)2, (int)buf.forEachByteDesc(0, 6, ByteProcessor.FIND_NON_CRLF));
        Assertions.assertEquals((int)-1, (int)buf.forEachByteDesc(0, 3, ByteProcessor.FIND_CRLF));
        buf.release();
    }
}

