/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.EmptyByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledHeapByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class EmptyByteBufTest {
    @Test
    public void testIsContiguous() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertTrue((boolean)empty.isContiguous());
    }

    @Test
    public void testIsWritable() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)empty.isWritable());
        Assertions.assertFalse((boolean)empty.isWritable(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEmptyByteBuf() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        empty.writeBytes(Unpooled.EMPTY_BUFFER);
        ByteBuf nonEmpty = UnpooledByteBufAllocator.DEFAULT.buffer().writeBoolean(false);
        try {
            empty.writeBytes(nonEmpty);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            nonEmpty.release();
        }
    }

    @Test
    public void testIsReadable() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)empty.isReadable());
        Assertions.assertFalse((boolean)empty.isReadable(1));
    }

    @Test
    public void testArray() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        MatcherAssert.assertThat((Object)empty.hasArray(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)empty.array().length, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)empty.arrayOffset(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testNioBuffer() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        MatcherAssert.assertThat((Object)empty.nioBufferCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)empty.nioBuffer().position(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)empty.nioBuffer().limit(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)empty.nioBuffer(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)empty.nioBuffer())));
        MatcherAssert.assertThat((Object)empty.nioBuffer(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)empty.internalNioBuffer(empty.readerIndex(), 0))));
    }

    @Test
    public void testMemoryAddress() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        if (empty.hasMemoryAddress()) {
            MatcherAssert.assertThat((Object)empty.memoryAddress(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        } else {
            try {
                empty.memoryAddress();
                Assertions.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void consistentEqualsAndHashCodeWithAbstractBytebuf() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        UnpooledHeapByteBuf emptyAbstract = new UnpooledHeapByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 0, 0);
        Assertions.assertEquals((Object)emptyAbstract, (Object)empty);
        Assertions.assertEquals((int)emptyAbstract.hashCode(), (int)empty.hashCode());
        Assertions.assertEquals((int)1, (int)empty.hashCode());
        Assertions.assertTrue((boolean)emptyAbstract.release());
        Assertions.assertFalse((boolean)empty.release());
    }

    @Test
    public void testGetCharSequence() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertEquals((Object)"", (Object)empty.readCharSequence(0, CharsetUtil.US_ASCII));
    }
}

