/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PoolArena;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PoolArenaMetric;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PooledByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PooledByteBufAllocator;

public class PoolArenaTest {
    private static final int PAGE_SIZE = 8192;
    private static final int PAGE_SHIFTS = 11;
    private static final int CHUNK_SIZE = 0x1000000;

    @Test
    public void testNormalizeCapacity() {
        PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 8192, 11, 0x1000000, 0);
        int[] reqCapacities = new int[]{0, 15, 510, 1024, 1023, 1025};
        int[] expectedResult = new int[]{16, 16, 512, 1024, 1024, 1280};
        for (int i = 0; i < reqCapacities.length; ++i) {
            Assertions.assertEquals((int)expectedResult[i], (int)arena.sizeIdx2size(arena.size2SizeIdx(reqCapacities[i])));
        }
    }

    @Test
    public void testNormalizeAlignedCapacity() {
        PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 8192, 11, 0x1000000, 64);
        int[] reqCapacities = new int[]{0, 15, 510, 1024, 1023, 1025};
        int[] expectedResult = new int[]{64, 64, 512, 1024, 1024, 1280};
        for (int i = 0; i < reqCapacities.length; ++i) {
            Assertions.assertEquals((int)expectedResult[i], (int)arena.sizeIdx2size(arena.size2SizeIdx(reqCapacities[i])));
        }
    }

    @Test
    public void testSize2SizeIdx() {
        PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 8192, 11, 0x1000000, 0);
        for (int sz = 0; sz <= 0x1000000; ++sz) {
            int sizeIdx = arena.size2SizeIdx(sz);
            Assertions.assertTrue((sz <= arena.sizeIdx2size(sizeIdx) ? 1 : 0) != 0);
            if (sizeIdx <= 0) continue;
            Assertions.assertTrue((sz > arena.sizeIdx2size(sizeIdx - 1) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPages2PageIdx() {
        int pageShifts = 11;
        PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 8192, 11, 0x1000000, 0);
        int maxPages = 0x1000000 >> pageShifts;
        for (int pages = 1; pages <= maxPages; ++pages) {
            int pageIdxCeiling;
            int pageIdxFloor = arena.pages2pageIdxFloor(pages);
            Assertions.assertTrue(((long)(pages << pageShifts) >= arena.pageIdx2size(pageIdxFloor) ? 1 : 0) != 0);
            if (pageIdxFloor > 0 && pages < maxPages) {
                Assertions.assertTrue(((long)(pages << pageShifts) < arena.pageIdx2size(pageIdxFloor + 1) ? 1 : 0) != 0);
            }
            Assertions.assertTrue(((long)(pages << pageShifts) <= arena.pageIdx2size(pageIdxCeiling = arena.pages2pageIdx(pages)) ? 1 : 0) != 0);
            if (pageIdxCeiling <= 0) continue;
            Assertions.assertTrue(((long)(pages << pageShifts) > arena.pageIdx2size(pageIdxCeiling - 1) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSizeIdx2size() {
        PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 8192, 11, 0x1000000, 0);
        for (int i = 0; i < arena.nSizes; ++i) {
            Assertions.assertEquals((int)arena.sizeIdx2sizeCompute(i), (int)arena.sizeIdx2size(i));
        }
    }

    @Test
    public void testPageIdx2size() {
        PoolArena.DirectArena arena = new PoolArena.DirectArena(null, 8192, 11, 0x1000000, 0);
        for (int i = 0; i < arena.nPSizes; ++i) {
            Assertions.assertEquals((long)arena.pageIdx2sizeCompute(i), (long)arena.pageIdx2size(i));
        }
    }

    @Test
    public void testAllocationCounter() {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 0, 1, 8192, 11, 0, 0, 0, true);
        ByteBuf b1 = allocator.directBuffer(800);
        ByteBuf b2 = allocator.directBuffer(40960);
        Assertions.assertNotNull((Object)b1);
        Assertions.assertNotNull((Object)b2);
        Assertions.assertTrue((boolean)b1.release());
        Assertions.assertTrue((boolean)b2.release());
        Assertions.assertTrue((allocator.directArenas().size() >= 1 ? 1 : 0) != 0);
        PoolArenaMetric metric = (PoolArenaMetric)allocator.directArenas().get(0);
        Assertions.assertEquals((long)2L, (long)metric.numDeallocations());
        Assertions.assertEquals((long)2L, (long)metric.numAllocations());
        Assertions.assertEquals((long)1L, (long)metric.numSmallDeallocations());
        Assertions.assertEquals((long)1L, (long)metric.numSmallAllocations());
        Assertions.assertEquals((long)1L, (long)metric.numNormalDeallocations());
        Assertions.assertEquals((long)1L, (long)metric.numNormalAllocations());
    }

    @Test
    public void testDirectArenaMemoryCopy() {
        ByteBuf src = PooledByteBufAllocator.DEFAULT.directBuffer(512);
        ByteBuf dst = PooledByteBufAllocator.DEFAULT.directBuffer(512);
        PooledByteBuf<ByteBuffer> pooledSrc = this.unwrapIfNeeded(src);
        PooledByteBuf<ByteBuffer> pooledDst = this.unwrapIfNeeded(dst);
        pooledDst.writeBytes(ByteBuffer.allocate(128));
        pooledDst.chunk.arena.memoryCopy(pooledSrc.memory, 0, pooledDst, 512);
        src.release();
        dst.release();
    }

    private PooledByteBuf<ByteBuffer> unwrapIfNeeded(ByteBuf buf) {
        return (PooledByteBuf)(buf instanceof PooledByteBuf ? buf : buf.unwrap());
    }
}

