/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer.search;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import org.neo4j.driver.internal.shaded.io.netty.buffer.search.AbstractSearchProcessorFactory;
import org.neo4j.driver.internal.shaded.io.netty.buffer.search.SearchProcessor;
import org.neo4j.driver.internal.shaded.io.netty.buffer.search.SearchProcessorFactory;
import org.neo4j.driver.internal.shaded.io.netty.util.ByteProcessor;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class SearchProcessorTest {
    @ParameterizedTest
    @EnumSource(value=Algorithm.class)
    public void testSearch(Algorithm algorithm) {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"abc\u263a", (Charset)CharsetUtil.UTF_8);
        Assertions.assertEquals((int)0, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "a").newSearchProcessor()));
        Assertions.assertEquals((int)1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "ab").newSearchProcessor()));
        Assertions.assertEquals((int)2, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "abc").newSearchProcessor()));
        Assertions.assertEquals((int)5, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "abc\u263a").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "abc\u263a\u263a").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "abc\u263ax").newSearchProcessor()));
        Assertions.assertEquals((int)1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "b").newSearchProcessor()));
        Assertions.assertEquals((int)2, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "bc").newSearchProcessor()));
        Assertions.assertEquals((int)5, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "bc\u263a").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "bc\u263a\u263a").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "bc\u263ax").newSearchProcessor()));
        Assertions.assertEquals((int)2, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "c").newSearchProcessor()));
        Assertions.assertEquals((int)5, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "c\u263a").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "c\u263a\u263a").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "c\u263ax").newSearchProcessor()));
        Assertions.assertEquals((int)5, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "\u263a").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "\u263a\u263a").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "\u263ax").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "z").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "aa").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "ba").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "abcd").newSearchProcessor()));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, "abcde").newSearchProcessor()));
        haystack.release();
    }

    @ParameterizedTest
    @EnumSource(value=Algorithm.class)
    public void testRepeating(Algorithm algorithm) {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"abcababc", (Charset)CharsetUtil.UTF_8);
        int length = haystack.readableBytes();
        SearchProcessor processor = this.factory(algorithm, "ab").newSearchProcessor();
        Assertions.assertEquals((int)1, (int)haystack.forEachByte((ByteProcessor)processor));
        Assertions.assertEquals((int)4, (int)haystack.forEachByte(2, length - 2, (ByteProcessor)processor));
        Assertions.assertEquals((int)6, (int)haystack.forEachByte(5, length - 5, (ByteProcessor)processor));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte(7, length - 7, (ByteProcessor)processor));
        haystack.release();
    }

    @ParameterizedTest
    @EnumSource(value=Algorithm.class)
    public void testOverlapping(Algorithm algorithm) {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"ababab", (Charset)CharsetUtil.UTF_8);
        int length = haystack.readableBytes();
        SearchProcessor processor = this.factory(algorithm, "bab").newSearchProcessor();
        Assertions.assertEquals((int)3, (int)haystack.forEachByte((ByteProcessor)processor));
        Assertions.assertEquals((int)5, (int)haystack.forEachByte(4, length - 4, (ByteProcessor)processor));
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte(6, length - 6, (ByteProcessor)processor));
        haystack.release();
    }

    @ParameterizedTest
    @EnumSource(value=Algorithm.class)
    public void testLongInputs(Algorithm algorithm) {
        int haystackLen = 1024;
        int needleLen = 64;
        byte[] haystackBytes = new byte[1024];
        haystackBytes[1023] = 1;
        ByteBuf haystack = Unpooled.copiedBuffer((byte[])haystackBytes);
        byte[] needleBytes = new byte[64];
        Assertions.assertEquals((int)63, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, needleBytes).newSearchProcessor()));
        needleBytes[63] = 1;
        Assertions.assertEquals((int)1023, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, needleBytes).newSearchProcessor()));
        needleBytes[63] = 2;
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, needleBytes).newSearchProcessor()));
        needleBytes[63] = 0;
        needleBytes[0] = 1;
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, needleBytes).newSearchProcessor()));
    }

    @ParameterizedTest
    @EnumSource(value=Algorithm.class)
    public void testUniqueLen64Substrings(Algorithm algorithm) {
        byte[] haystackBytes = new byte[2080];
        int pos = 0;
        for (int i = 1; i <= 64; ++i) {
            for (int j = 0; j < i; ++j) {
                haystackBytes[pos++] = (byte)i;
            }
        }
        ByteBuf haystack = Unpooled.copiedBuffer((byte[])haystackBytes);
        for (int start = 0; start < haystackBytes.length - 64; ++start) {
            byte[] needle = Arrays.copyOfRange(haystackBytes, start, start + 64);
            Assertions.assertEquals((int)(start + 63), (int)haystack.forEachByte((ByteProcessor)this.factory(algorithm, needle).newSearchProcessor()));
        }
    }

    private SearchProcessorFactory factory(Algorithm algorithm, byte[] needle) {
        return algorithm.newFactory(needle);
    }

    private SearchProcessorFactory factory(Algorithm algorithm, String needle) {
        return this.factory(algorithm, needle.getBytes(CharsetUtil.UTF_8));
    }

    private static enum Algorithm {
        KNUTH_MORRIS_PRATT{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractSearchProcessorFactory.newKmpSearchProcessorFactory((byte[])needle);
            }
        }
        ,
        BITAP{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractSearchProcessorFactory.newBitapSearchProcessorFactory((byte[])needle);
            }
        }
        ,
        AHO_CORASIC{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{needle});
            }
        };


        abstract SearchProcessorFactory newFactory(byte[] var1);
    }
}

