/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.nio.channels.ClosedChannelException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.AbstractCoalescingBufferQueue;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundInvoker;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;

public class AbstractCoalescingBufferQueueTest {
    @Test
    public void testDecrementAllWhenWriteAndRemoveAll() {
        AbstractCoalescingBufferQueueTest.testDecrementAll(true);
    }

    @Test
    public void testDecrementAllWhenReleaseAndFailAll() {
        AbstractCoalescingBufferQueueTest.testDecrementAll(false);
    }

    private static void testDecrementAll(boolean write) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ReferenceCountUtil.release((Object)msg);
                promise.setSuccess();
            }
        }, new ChannelHandlerAdapter(){}});
        final AbstractCoalescingBufferQueue queue = new AbstractCoalescingBufferQueue((Channel)channel, 128){

            protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
                return this.composeIntoComposite(alloc, cumulation, next);
            }

            protected ByteBuf removeEmptyValue() {
                return Unpooled.EMPTY_BUFFER;
            }
        };
        final byte[] bytes = new byte[128];
        queue.add(Unpooled.wrappedBuffer((byte[])bytes), new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                queue.add(Unpooled.wrappedBuffer((byte[])bytes));
                Assertions.assertEquals((int)bytes.length, (int)queue.readableBytes());
            }
        });
        Assertions.assertEquals((int)bytes.length, (int)queue.readableBytes());
        ChannelHandlerContext ctx = channel.pipeline().lastContext();
        if (write) {
            queue.writeAndRemoveAll(ctx);
        } else {
            queue.releaseAndFailAll((ChannelOutboundInvoker)ctx, (Throwable)new ClosedChannelException());
        }
        ByteBuf buffer = queue.remove(channel.alloc(), 128, channel.newPromise());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertEquals((int)0, (int)queue.readableBytes());
        Assertions.assertFalse((boolean)channel.finish());
    }
}

