/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufInputStream;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufOutputStream;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelId;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultChannelId;

public class DefaultChannelIdTest {
    @Test
    public void testShortText() {
        String text = DefaultChannelId.newInstance().asShortText();
        Assertions.assertTrue((boolean)text.matches("^[0-9a-f]{8}$"));
    }

    @Test
    public void testLongText() {
        String text = DefaultChannelId.newInstance().asLongText();
        Assertions.assertTrue((boolean)text.matches("^[0-9a-f]{16}-[0-9a-f]{8}-[0-9a-f]{8}-[0-9a-f]{16}-[0-9a-f]{8}$"));
    }

    @Test
    public void testIdempotentMachineId() {
        String a = DefaultChannelId.newInstance().asLongText().substring(0, 16);
        String b = DefaultChannelId.newInstance().asLongText().substring(0, 16);
        MatcherAssert.assertThat((Object)a, (Matcher)CoreMatchers.is((Object)b));
    }

    @Test
    public void testIdempotentProcessId() {
        String a = DefaultChannelId.newInstance().asLongText().substring(17, 21);
        String b = DefaultChannelId.newInstance().asLongText().substring(17, 21);
        MatcherAssert.assertThat((Object)a, (Matcher)CoreMatchers.is((Object)b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerialization() throws Exception {
        ChannelId b;
        DefaultChannelId a = DefaultChannelId.newInstance();
        ByteBuf buf = Unpooled.buffer();
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));
        try {
            out.writeObject(a);
            out.flush();
        }
        finally {
            out.close();
        }
        ObjectInputStream in = new ObjectInputStream((InputStream)new ByteBufInputStream(buf, true));
        try {
            b = (ChannelId)in.readObject();
        }
        finally {
            in.close();
        }
        MatcherAssert.assertThat((Object)a, (Matcher)CoreMatchers.is((Object)b));
        MatcherAssert.assertThat((Object)a, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)b))));
        MatcherAssert.assertThat((Object)a.asLongText(), (Matcher)CoreMatchers.is((Object)b.asLongText()));
    }
}

