/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultFileRegion;
import org.neo4j.driver.internal.shaded.io.netty.channel.FileRegion;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class DefaultFileRegionTest {
    private static final byte[] data = new byte[0xA00000];

    private static File newFile() throws IOException {
        File file = PlatformDependent.createTempFile((String)"netty-", (String)".tmp", null);
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        out.write(data);
        out.close();
        return file;
    }

    @Test
    public void testCreateFromFile() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        try {
            DefaultFileRegionTest.testFileRegion((FileRegion)new DefaultFileRegion(file, 0L, (long)data.length));
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void testCreateFromFileChannel() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            DefaultFileRegionTest.testFileRegion((FileRegion)new DefaultFileRegion(randomAccessFile.getChannel(), 0L, (long)data.length));
        }
        finally {
            randomAccessFile.close();
            file.delete();
        }
    }

    private static void testFileRegion(FileRegion region) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(outputStream);
        try {
            Assertions.assertEquals((long)data.length, (long)region.count());
            Assertions.assertEquals((long)0L, (long)region.transferred());
            Assertions.assertEquals((long)data.length, (long)region.transferTo(channel, 0L));
            Assertions.assertEquals((long)data.length, (long)region.count());
            Assertions.assertEquals((long)data.length, (long)region.transferred());
            Assertions.assertArrayEquals((byte[])data, (byte[])outputStream.toByteArray());
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncated() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(outputStream);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            DefaultFileRegion region = new DefaultFileRegion(randomAccessFile.getChannel(), 0L, (long)data.length);
            randomAccessFile.getChannel().truncate(data.length - 1024);
            Assertions.assertEquals((long)data.length, (long)region.count());
            Assertions.assertEquals((long)0L, (long)region.transferred());
            Assertions.assertEquals((long)(data.length - 1024), (long)region.transferTo(channel, 0L));
            Assertions.assertEquals((long)data.length, (long)region.count());
            Assertions.assertEquals((long)(data.length - 1024), (long)region.transferred());
            try {
                region.transferTo(channel, (long)(data.length - 1024));
                Assertions.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            channel.close();
            randomAccessFile.close();
            file.delete();
        }
    }

    static {
        PlatformDependent.threadLocalRandom().nextBytes(data);
    }
}

