/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;

final class LoggingHandler
implements ChannelInboundHandler,
ChannelOutboundHandler {
    private StringBuilder log = new StringBuilder();
    private final EnumSet<Event> interest = EnumSet.allOf(Event.class);

    LoggingHandler() {
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.log(Event.WRITE);
        ctx.write(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.FLUSH);
        ctx.flush();
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.log(Event.BIND, "localAddress=" + localAddress);
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.log(Event.CONNECT, "remoteAddress=" + remoteAddress + " localAddress=" + localAddress);
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.log(Event.DISCONNECT);
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.log(Event.CLOSE);
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.log(Event.DEREGISTER);
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.READ);
        ctx.read();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.WRITABILITY, "writable=" + ctx.channel().isWritable());
        ctx.fireChannelWritabilityChanged();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.HANDLER_ADDED);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.HANDLER_REMOVED);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.log(Event.EXCEPTION, cause.toString());
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.REGISTERED);
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.UNREGISTERED);
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.ACTIVE);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.INACTIVE);
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.log(Event.READ);
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.log(Event.READ_COMPLETE);
        ctx.fireChannelReadComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.log(Event.USER, evt.toString());
        ctx.fireUserEventTriggered(evt);
    }

    String getLog() {
        return this.log.toString();
    }

    void clear() {
        this.log = new StringBuilder();
    }

    void setInterest(Event ... events) {
        this.interest.clear();
        Collections.addAll(this.interest, events);
    }

    private void log(Event e) {
        this.log(e, null);
    }

    private void log(Event e, String msg) {
        if (this.interest.contains((Object)e)) {
            this.log.append((Object)e);
            if (msg != null) {
                this.log.append(": ").append(msg);
            }
            this.log.append('\n');
        }
    }

    static enum Event {
        WRITE,
        FLUSH,
        BIND,
        CONNECT,
        DISCONNECT,
        CLOSE,
        DEREGISTER,
        READ,
        WRITABILITY,
        HANDLER_ADDED,
        HANDLER_REMOVED,
        EXCEPTION,
        READ_COMPLETE,
        REGISTERED,
        UNREGISTERED,
        ACTIVE,
        INACTIVE,
        USER;

    }
}

