/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.BaseChannelTest;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.LoggingHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class ReentrantChannelTest
extends BaseChannelTest {
    @Test
    public void testWritabilityChanged() throws Exception {
        LocalAddress addr = new LocalAddress("testWritabilityChanged");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync().channel();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.WRITABILITY);
        Channel clientChannel = cb.connect((SocketAddress)addr).sync().channel();
        clientChannel.config().setWriteBufferLowWaterMark(512);
        clientChannel.config().setWriteBufferHighWaterMark(1024);
        ChannelFuture future = clientChannel.write((Object)ReentrantChannelTest.createTestBuf(2000));
        clientChannel.flush();
        future.sync();
        clientChannel.close().sync();
        this.assertLog("WRITABILITY: writable=false\nWRITE\nWRITABILITY: writable=false\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\n", "WRITABILITY: writable=false\nWRITE\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\nWRITABILITY: writable=true\n");
    }

    @Test
    public void testFlushInWritabilityChanged() throws Exception {
        LocalAddress addr = new LocalAddress("testFlushInWritabilityChanged");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync().channel();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.WRITABILITY);
        Channel clientChannel = cb.connect((SocketAddress)addr).sync().channel();
        clientChannel.config().setWriteBufferLowWaterMark(512);
        clientChannel.config().setWriteBufferHighWaterMark(1024);
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
                if (!ctx.channel().isWritable()) {
                    ctx.channel().flush();
                }
                ctx.fireChannelWritabilityChanged();
            }
        }});
        Assertions.assertTrue((boolean)clientChannel.isWritable());
        clientChannel.write((Object)ReentrantChannelTest.createTestBuf(2000)).sync();
        clientChannel.close().sync();
        this.assertLog("WRITABILITY: writable=false\nFLUSH\nWRITE\nWRITABILITY: writable=false\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\n", "WRITABILITY: writable=false\nFLUSH\nWRITE\nWRITABILITY: writable=false\nFLUSH\nWRITABILITY: writable=true\nWRITABILITY: writable=true\n");
    }

    @Test
    public void testWriteFlushPingPong() throws Exception {
        LocalAddress addr = new LocalAddress("testWriteFlushPingPong");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync().channel();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = cb.connect((SocketAddress)addr).sync().channel();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){
            int writeCount;
            int flushCount;

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (this.writeCount < 5) {
                    ++this.writeCount;
                    ctx.channel().flush();
                }
                super.write(ctx, msg, promise);
            }

            public void flush(ChannelHandlerContext ctx) throws Exception {
                if (this.flushCount < 5) {
                    ++this.flushCount;
                    ctx.channel().write((Object)BaseChannelTest.createTestBuf(2000));
                }
                super.flush(ctx);
            }
        }});
        clientChannel.writeAndFlush((Object)ReentrantChannelTest.createTestBuf(2000));
        clientChannel.close().sync();
        this.assertLog("WRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nWRITE\nFLUSH\nCLOSE\n", new String[0]);
    }

    @Test
    public void testCloseInFlush() throws Exception {
        LocalAddress addr = new LocalAddress("testCloseInFlush");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync().channel();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = cb.connect((SocketAddress)addr).sync().channel();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(final ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                promise.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                    public void operationComplete(Future<? super Void> future) throws Exception {
                        ctx.channel().close();
                    }
                });
                super.write(ctx, msg, promise);
                ctx.channel().flush();
            }
        }});
        clientChannel.write((Object)ReentrantChannelTest.createTestBuf(2000)).sync();
        clientChannel.closeFuture().sync();
        this.assertLog("WRITE\nFLUSH\nCLOSE\n", new String[0]);
    }

    @Test
    public void testFlushFailure() throws Exception {
        LocalAddress addr = new LocalAddress("testFlushFailure");
        ServerBootstrap sb = this.getLocalServerBootstrap();
        sb.bind((SocketAddress)addr).sync().channel();
        Bootstrap cb = this.getLocalClientBootstrap();
        this.setInterest(LoggingHandler.Event.WRITE, LoggingHandler.Event.FLUSH, LoggingHandler.Event.CLOSE, LoggingHandler.Event.EXCEPTION);
        Channel clientChannel = cb.connect((SocketAddress)addr).sync().channel();
        clientChannel.pipeline().addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                throw new Exception("intentional failure");
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
            }
        }});
        try {
            clientChannel.writeAndFlush((Object)ReentrantChannelTest.createTestBuf(2000)).sync();
            Assertions.fail();
        }
        catch (Throwable cce) {
            MatcherAssert.assertThat((Object)cce, (Matcher)Matchers.instanceOf(ClosedChannelException.class));
        }
        clientChannel.closeFuture().sync();
        this.assertLog("WRITE\nCLOSE\n", new String[0]);
    }
}

