/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.local;

import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;

public class LocalTransportThreadModelTest2 {
    private static final String LOCAL_CHANNEL = LocalTransportThreadModelTest2.class.getName();
    static final int messageCountPerRun = 4;

    @Test
    @Timeout(value=15000L, unit=TimeUnit.MILLISECONDS)
    public void testSocketReuse() throws InterruptedException {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        LocalHandler serverHandler = new LocalHandler("SERVER");
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)new DefaultEventLoopGroup(), (EventLoopGroup)new DefaultEventLoopGroup()).channel(LocalServerChannel.class)).childHandler((ChannelHandler)serverHandler);
        Bootstrap clientBootstrap = new Bootstrap();
        LocalHandler clientHandler = new LocalHandler("CLIENT");
        ((Bootstrap)((Bootstrap)clientBootstrap.group((EventLoopGroup)new DefaultEventLoopGroup())).channel(LocalChannel.class)).remoteAddress((SocketAddress)new LocalAddress(LOCAL_CHANNEL)).handler((ChannelHandler)clientHandler);
        serverBootstrap.bind((SocketAddress)new LocalAddress(LOCAL_CHANNEL)).sync();
        int count = 100;
        for (int i = 1; i < count + 1; ++i) {
            Channel ch = clientBootstrap.connect().sync().channel();
            int target = i * 4;
            while (serverHandler.count.get() != target || clientHandler.count.get() != target) {
                Thread.sleep(50L);
            }
            this.close(ch, clientHandler);
        }
        Assertions.assertEquals((int)(count * 2 * 4), (int)(serverHandler.count.get() + clientHandler.count.get()));
    }

    public void close(final Channel localChannel, final LocalHandler localRegistrationHandler) {
        if (localChannel.eventLoop().inEventLoop()) {
            if (localRegistrationHandler.lastWriteFuture != null) {
                localRegistrationHandler.lastWriteFuture.awaitUninterruptibly();
            }
            localChannel.close();
            return;
        }
        localChannel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                LocalTransportThreadModelTest2.this.close(localChannel, localRegistrationHandler);
            }
        });
        localChannel.closeFuture().awaitUninterruptibly();
    }

    @ChannelHandler.Sharable
    static class LocalHandler
    extends ChannelInboundHandlerAdapter {
        private final String name;
        public volatile ChannelFuture lastWriteFuture;
        public final AtomicInteger count = new AtomicInteger(0);

        LocalHandler(String name) {
            this.name = name;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            for (int i = 0; i < 4; ++i) {
                this.lastWriteFuture = ctx.channel().write((Object)(this.name + ' ' + i));
            }
            ctx.channel().flush();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.count.incrementAndGet();
            ReferenceCountUtil.release((Object)msg);
        }
    }
}

