/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.oio;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelException;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.oio.OioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.oio.OioServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.oio.OioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.NetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class OioEventLoopTest {
    @Test
    public void testTooManyServerChannels() throws Exception {
        OioEventLoopGroup g = new OioEventLoopGroup(1);
        ServerBootstrap b = new ServerBootstrap();
        b.channel(OioServerSocketChannel.class);
        b.group((EventLoopGroup)g);
        b.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture f1 = b.bind(0);
        f1.sync();
        ChannelFuture f2 = b.bind(0);
        f2.await();
        MatcherAssert.assertThat((Object)f2.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ChannelException.class)));
        MatcherAssert.assertThat((Object)f2.cause().getMessage().toLowerCase(), (Matcher)CoreMatchers.containsString((String)"too many channels"));
        final CountDownLatch notified = new CountDownLatch(1);
        f2.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                notified.countDown();
            }
        });
        notified.await();
        g.shutdownGracefully();
    }

    @Test
    public void testTooManyClientChannels() throws Exception {
        OioEventLoopGroup g = new OioEventLoopGroup(1);
        ServerBootstrap sb = new ServerBootstrap();
        sb.channel(OioServerSocketChannel.class);
        sb.group((EventLoopGroup)g);
        sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture f1 = sb.bind(0);
        f1.sync();
        Bootstrap cb = new Bootstrap();
        cb.channel(OioSocketChannel.class);
        cb.group((EventLoopGroup)g);
        cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture f2 = cb.connect(NetUtil.LOCALHOST, ((InetSocketAddress)f1.channel().localAddress()).getPort());
        f2.await();
        MatcherAssert.assertThat((Object)f2.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ChannelException.class)));
        MatcherAssert.assertThat((Object)f2.cause().getMessage().toLowerCase(), (Matcher)CoreMatchers.containsString((String)"too many channels"));
        final CountDownLatch notified = new CountDownLatch(1);
        f2.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                notified.countDown();
            }
        });
        notified.await();
        g.shutdownGracefully();
    }

    @Test
    public void testTooManyAcceptedChannels() throws Exception {
        OioEventLoopGroup g = new OioEventLoopGroup(1);
        ServerBootstrap sb = new ServerBootstrap();
        sb.channel(OioServerSocketChannel.class);
        sb.group((EventLoopGroup)g);
        sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture f1 = sb.bind(0);
        f1.sync();
        Socket s = new Socket(NetUtil.LOCALHOST, ((InetSocketAddress)f1.channel().localAddress()).getPort());
        MatcherAssert.assertThat((Object)s.getInputStream().read(), (Matcher)CoreMatchers.is((Object)-1));
        s.close();
        g.shutdownGracefully();
    }
}

