/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.pool;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPoolHandler;

final class CountingChannelPoolHandler
implements ChannelPoolHandler {
    private final AtomicInteger channelCount = new AtomicInteger(0);
    private final AtomicInteger acquiredCount = new AtomicInteger(0);
    private final AtomicInteger releasedCount = new AtomicInteger(0);

    CountingChannelPoolHandler() {
    }

    public void channelCreated(Channel ch) {
        this.channelCount.incrementAndGet();
    }

    public void channelReleased(Channel ch) {
        this.releasedCount.incrementAndGet();
    }

    public void channelAcquired(Channel ch) {
        this.acquiredCount.incrementAndGet();
    }

    public int channelCount() {
        return this.channelCount.get();
    }

    public int acquiredCount() {
        return this.acquiredCount.get();
    }

    public int releasedCount() {
        return this.releasedCount.get();
    }
}

