/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.AbstractNioChannelTest;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;

public class NioServerSocketChannelTest
extends AbstractNioChannelTest<NioServerSocketChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseOnError() throws Exception {
        ServerSocketChannel jdkChannel = ServerSocketChannel.open();
        NioServerSocketChannel serverSocketChannel = new NioServerSocketChannel(jdkChannel);
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            group.register((Channel)serverSocketChannel).syncUninterruptibly();
            serverSocketChannel.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly();
            Assertions.assertFalse((boolean)serverSocketChannel.closeOnReadError((Throwable)new IOException()));
            Assertions.assertTrue((boolean)serverSocketChannel.closeOnReadError((Throwable)new IllegalArgumentException()));
            serverSocketChannel.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsActiveFalseAfterClose() {
        NioServerSocketChannel serverSocketChannel = new NioServerSocketChannel();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            group.register((Channel)serverSocketChannel).syncUninterruptibly();
            Channel channel = serverSocketChannel.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            Assertions.assertTrue((boolean)channel.isActive());
            Assertions.assertTrue((boolean)channel.isOpen());
            channel.close().syncUninterruptibly();
            Assertions.assertFalse((boolean)channel.isOpen());
            Assertions.assertFalse((boolean)channel.isActive());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Override
    protected NioServerSocketChannel newNioChannel() {
        return new NioServerSocketChannel();
    }

    @Override
    protected NetworkChannel jdkChannel(NioServerSocketChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.IP_MULTICAST_IF;
    }
}

