/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.CharSequenceValueConverter;
import org.neo4j.driver.internal.shaded.io.netty.util.AsciiString;

public class CharSequenceValueConverterTest {
    private final CharSequenceValueConverter converter = CharSequenceValueConverter.INSTANCE;

    @Test
    public void testBoolean() {
        Assertions.assertTrue((boolean)this.converter.convertToBoolean(this.converter.convertBoolean(true)));
        Assertions.assertFalse((boolean)this.converter.convertToBoolean(this.converter.convertBoolean(false)));
    }

    @Test
    public void testByteFromAsciiString() {
        Assertions.assertEquals((int)127, (int)this.converter.convertToByte((CharSequence)AsciiString.of((CharSequence)"127")));
    }

    @Test
    public void testByteFromEmptyAsciiString() {
        Assertions.assertThrows(NumberFormatException.class, (Executable)new Executable(){

            public void execute() {
                CharSequenceValueConverterTest.this.converter.convertToByte((CharSequence)AsciiString.EMPTY_STRING);
            }
        });
    }

    @Test
    public void testByte() {
        Assertions.assertEquals((byte)127, (byte)this.converter.convertToByte(this.converter.convertByte((byte)127)));
    }

    @Test
    public void testChar() {
        Assertions.assertEquals((char)'\uffff', (char)this.converter.convertToChar(this.converter.convertChar('\uffff')));
    }

    @Test
    public void testDouble() {
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)this.converter.convertToDouble(this.converter.convertDouble(Double.MAX_VALUE)), (double)0.0);
    }

    @Test
    public void testFloat() {
        Assertions.assertEquals((float)Float.MAX_VALUE, (float)this.converter.convertToFloat(this.converter.convertFloat(Float.MAX_VALUE)), (float)0.0f);
    }

    @Test
    public void testInt() {
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)this.converter.convertToInt(this.converter.convertInt(Integer.MAX_VALUE)));
    }

    @Test
    public void testShort() {
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)this.converter.convertToShort(this.converter.convertShort((short)Short.MAX_VALUE)));
    }

    @Test
    public void testLong() {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.converter.convertToLong(this.converter.convertLong(Long.MAX_VALUE)));
    }

    @Test
    public void testTimeMillis() {
        long millis = System.currentTimeMillis() / 1000L * 1000L;
        Assertions.assertEquals((long)millis, (long)this.converter.convertToTimeMillis(this.converter.convertTimeMillis(millis)));
    }
}

