/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.TooLongFrameException;

public class LengthFieldBasedFrameDecoderTest {
    @Test
    public void testDiscardTooLongFrame1() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(32);
        for (int i = 0; i < 32; ++i) {
            buf.writeByte(i);
        }
        buf.writeInt(1);
        buf.writeByte(97);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(16, 0, 4)});
        try {
            channel.writeInbound(new Object[]{buf});
            Assertions.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)channel.finish());
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((int)5, (int)b.readableBytes());
        Assertions.assertEquals((int)1, (int)b.readInt());
        Assertions.assertEquals((int)97, (int)b.readByte());
        b.release();
        Assertions.assertNull((Object)channel.readInbound());
        channel.finish();
    }

    @Test
    public void testDiscardTooLongFrame2() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(32);
        for (int i = 0; i < 32; ++i) {
            buf.writeByte(i);
        }
        buf.writeInt(1);
        buf.writeByte(97);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(16, 0, 4)});
        try {
            channel.writeInbound(new Object[]{buf.readRetainedSlice(14)});
            Assertions.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{buf.readRetainedSlice(buf.readableBytes())}));
        Assertions.assertTrue((boolean)channel.finish());
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((int)5, (int)b.readableBytes());
        Assertions.assertEquals((int)1, (int)b.readInt());
        Assertions.assertEquals((int)97, (int)b.readByte());
        b.release();
        Assertions.assertNull((Object)channel.readInbound());
        channel.finish();
        buf.release();
    }
}

