/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec;

import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufHolder;
import org.neo4j.driver.internal.shaded.io.netty.buffer.DefaultByteBufHolder;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DecoderResult;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DecoderResultProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.MessageAggregator;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.PrematureChannelClosureException;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class MessageAggregatorTest {
    private static ByteBufHolder message(String string) {
        return new DefaultByteBufHolder(Unpooled.copiedBuffer((CharSequence)string, (Charset)CharsetUtil.US_ASCII));
    }

    @Test
    public void testReadFlowManagement() throws Exception {
        ReadCounter counter = new ReadCounter();
        ByteBufHolder first = MessageAggregatorTest.message("first");
        ByteBufHolder chunk = MessageAggregatorTest.message("chunk");
        ByteBufHolder last = MessageAggregatorTest.message("last");
        MockMessageAggregator agg = (MockMessageAggregator)((Object)Mockito.spy(MockMessageAggregator.class));
        Mockito.when((Object)agg.isStartMessage(first)).thenReturn((Object)true);
        Mockito.when((Object)agg.isContentMessage(chunk)).thenReturn((Object)true);
        Mockito.when((Object)agg.isContentMessage(last)).thenReturn((Object)true);
        Mockito.when((Object)agg.isLastContentMessage(last)).thenReturn((Object)true);
        EmbeddedChannel embedded = new EmbeddedChannel(new ChannelHandler[]{counter, agg});
        embedded.config().setAutoRead(false);
        Assertions.assertFalse((boolean)embedded.writeInbound(new Object[]{first}));
        Assertions.assertFalse((boolean)embedded.writeInbound(new Object[]{chunk}));
        Assertions.assertTrue((boolean)embedded.writeInbound(new Object[]{last}));
        Assertions.assertEquals((int)3, (int)counter.value);
        DefaultByteBufHolder all = new DefaultByteBufHolder(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{first.content().retain(), chunk.content().retain(), last.content().retain()}));
        ByteBufHolder out = (ByteBufHolder)embedded.readInbound();
        Assertions.assertEquals((Object)all, (Object)out);
        Assertions.assertTrue((all.release() && out.release() ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)embedded.finish());
    }

    @Test
    public void testCloseWhileAggregating() throws Exception {
        ReadCounter counter = new ReadCounter();
        TestMessage first = new TestMessage(Unpooled.copiedBuffer((CharSequence)"first", (Charset)CharsetUtil.US_ASCII));
        MockMessageAggregator agg = (MockMessageAggregator)((Object)Mockito.spy(MockMessageAggregator.class));
        Mockito.when((Object)agg.isStartMessage((Object)first)).thenReturn((Object)true);
        Mockito.when((Object)agg.isLastContentMessage((ByteBufHolder)first)).thenReturn((Object)false);
        final EmbeddedChannel embedded = new EmbeddedChannel(new ChannelHandler[]{counter, agg});
        embedded.config().setAutoRead(false);
        Assertions.assertFalse((boolean)embedded.writeInbound(new Object[]{first}));
        Assertions.assertEquals((int)2, (int)counter.value);
        Assertions.assertThrows(PrematureChannelClosureException.class, (Executable)new Executable(){

            public void execute() {
                embedded.finish();
            }
        });
        Assertions.assertEquals((int)0, (int)first.refCnt());
    }

    private static final class TestMessage
    extends DefaultByteBufHolder
    implements DecoderResultProvider {
        TestMessage(ByteBuf data) {
            super(data);
        }

        public DecoderResult decoderResult() {
            return DecoderResult.SUCCESS;
        }

        public void setDecoderResult(DecoderResult result) {
        }
    }

    static abstract class MockMessageAggregator
    extends MessageAggregator<ByteBufHolder, ByteBufHolder, ByteBufHolder, ByteBufHolder> {
        protected MockMessageAggregator() {
            super(1024);
        }

        protected ByteBufHolder beginAggregation(ByteBufHolder start, ByteBuf content) throws Exception {
            return start.replace(content);
        }
    }

    private static final class ReadCounter
    extends ChannelOutboundHandlerAdapter {
        int value;

        private ReadCounter() {
        }

        public void read(ChannelHandlerContext ctx) throws Exception {
            ++this.value;
            ctx.read();
        }
    }
}

