/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec;

import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.ChannelInputShutdownEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.ReplayingDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.ReplayingDecoderByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class ReplayingDecoderTest {
    @Test
    public void testLineProtocol() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineDecoder()});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{65})});
        Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{66})});
        Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{67})});
        Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{10})});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{65, 66, 67});
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{65})});
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testReplacement() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new BloatedLineDecoder()});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{65, 66})});
        Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{67, 10})});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{65, 66, 67});
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
        ch.finish();
        Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testSingleDecode() throws Exception {
        LineDecoder decoder = new LineDecoder();
        decoder.setSingleDecode(true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{decoder});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{67, 10, 66, 10})});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{67});
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
        Assertions.assertNull((Object)ch.readInbound(), (String)"Must be null as it must only decode one frame");
        ch.read();
        ch.finish();
        buf = Unpooled.wrappedBuffer((byte[])new byte[]{66});
        buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
        Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testRemoveItself() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder(){
            private boolean removed;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assertions.assertFalse((boolean)this.removed);
                in.readByte();
                ctx.pipeline().remove((ChannelHandler)this);
                this.removed = true;
            }
        }});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{97, 98, 99});
        channel.writeInbound(new Object[]{buf.copy()});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((Object)b, (Object)buf.skipBytes(1));
        b.release();
        buf.release();
    }

    @Test
    public void testRemoveItselfWithReplayError() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder(){
            private boolean removed;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assertions.assertFalse((boolean)this.removed);
                ctx.pipeline().remove((ChannelHandler)this);
                in.readBytes(1000);
                this.removed = true;
            }
        }});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{97, 98, 99});
        channel.writeInbound(new Object[]{buf.copy()});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((Object)b, (Object)buf, (String)"Expect to have still all bytes in the buffer");
        b.release();
        buf.release();
    }

    @Test
    public void testRemoveItselfWriteBuffer() {
        final ByteBuf buf = Unpooled.buffer().writeBytes(new byte[]{97, 98, 99});
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder(){
            private boolean removed;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assertions.assertFalse((boolean)this.removed);
                in.readByte();
                ctx.pipeline().remove((ChannelHandler)this);
                buf.writeByte(100);
                this.removed = true;
            }
        }});
        channel.writeInbound(new Object[]{buf.copy()});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((Object)b, (Object)Unpooled.wrappedBuffer((byte[])new byte[]{98, 99}));
        b.release();
        buf.release();
    }

    @Test
    public void testFireChannelReadCompleteOnInactive() throws InterruptedException {
        final LinkedBlockingDeque queue = new LinkedBlockingDeque();
        ByteBuf buf = Unpooled.buffer().writeBytes(new byte[]{97, 98});
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder<Integer>(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                int readable = in.readableBytes();
                Assertions.assertTrue((readable > 0 ? 1 : 0) != 0);
                in.skipBytes(readable);
                out.add("data");
            }

            protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assertions.assertFalse((boolean)in.isReadable());
                out.add("data");
            }
        }, new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                queue.add(3);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                queue.add(1);
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                if (!ctx.channel().isActive()) {
                    queue.add(2);
                }
            }
        }});
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{buf}));
        channel.finish();
        Assertions.assertEquals((int)1, (int)((Integer)queue.take()));
        Assertions.assertEquals((int)1, (int)((Integer)queue.take()));
        Assertions.assertEquals((int)2, (int)((Integer)queue.take()));
        Assertions.assertEquals((int)3, (int)((Integer)queue.take()));
        Assertions.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void testChannelInputShutdownEvent() {
        final AtomicReference error = new AtomicReference();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder<Integer>(Integer.valueOf(0)){
            private boolean decoded;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                if (!(in instanceof ReplayingDecoderByteBuf)) {
                    error.set(new AssertionError((Object)("in must be of type " + ReplayingDecoderByteBuf.class + " but was " + in.getClass())));
                    return;
                }
                if (!this.decoded) {
                    this.decoded = true;
                    in.readByte();
                    this.state(1);
                } else {
                    in.skipBytes(Integer.MAX_VALUE);
                }
            }
        }});
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1})}));
        channel.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
        Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
        Error err = (Error)error.get();
        if (err != null) {
            throw err;
        }
    }

    @Test
    public void handlerRemovedWillNotReleaseBufferIfDecodeInProgress() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder<Integer>(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                ctx.pipeline().remove((ChannelHandler)this);
                Assertions.assertTrue((in.refCnt() != 0 ? 1 : 0) != 0);
            }

            protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
                ReplayingDecoderTest.assertCumulationReleased(this.internalBuffer());
            }
        }});
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])bytes)}));
        Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    private static void assertCumulationReleased(ByteBuf byteBuf) {
        Assertions.assertTrue((byteBuf == null || byteBuf == Unpooled.EMPTY_BUFFER || byteBuf.refCnt() == 0 ? 1 : 0) != 0, (String)("unexpected value: " + byteBuf));
    }

    private static final class BloatedLineDecoder
    extends ChannelInboundHandlerAdapter {
        private BloatedLineDecoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.pipeline().replace((ChannelHandler)this, "less-bloated", (ChannelHandler)new LineDecoder());
            ctx.pipeline().fireChannelRead(msg);
        }
    }

    private static final class LineDecoder
    extends ReplayingDecoder<Void> {
        LineDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            ByteBuf msg = in.readBytes(in.bytesBefore((byte)10));
            out.add(msg);
            in.skipBytes(1);
        }
    }
}

