/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.AbstractCompressionTest;

public abstract class AbstractEncoderTest
extends AbstractCompressionTest {
    protected EmbeddedChannel channel;

    protected abstract ByteBuf decompress(ByteBuf var1, int var2) throws Exception;

    @BeforeEach
    public final void initChannel() {
        this.channel = this.createChannel();
    }

    protected abstract EmbeddedChannel createChannel();

    @AfterEach
    public void destroyChannel() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
            this.channel = null;
        }
    }

    public static ByteBuf[] smallData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])BYTES_SMALL);
        ByteBuf direct = Unpooled.directBuffer((int)BYTES_SMALL.length);
        direct.writeBytes(BYTES_SMALL);
        return new ByteBuf[]{heap, direct};
    }

    public static ByteBuf[] largeData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])BYTES_LARGE);
        ByteBuf direct = Unpooled.directBuffer((int)BYTES_LARGE.length);
        direct.writeBytes(BYTES_LARGE);
        return new ByteBuf[]{heap, direct};
    }

    @ParameterizedTest
    @MethodSource(value={"smallData"})
    public void testCompressionOfSmallChunkOfData(ByteBuf data) throws Exception {
        this.testCompression(data);
    }

    @ParameterizedTest
    @MethodSource(value={"largeData"})
    public void testCompressionOfLargeChunkOfData(ByteBuf data) throws Exception {
        this.testCompression(data);
    }

    @ParameterizedTest
    @MethodSource(value={"largeData"})
    public void testCompressionOfBatchedFlowOfData(ByteBuf data) throws Exception {
        this.testCompressionOfBatchedFlow(data);
    }

    protected void testCompression(ByteBuf data) throws Exception {
        int dataLength = data.readableBytes();
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{data.retain()}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)0, (int)data.readableBytes());
        ByteBuf decompressed = this.readDecompressed(dataLength);
        Assertions.assertEquals((Object)data.resetReaderIndex(), (Object)decompressed);
        decompressed.release();
        data.release();
    }

    protected void testCompressionOfBatchedFlow(ByteBuf data) throws Exception {
        ByteBuf in;
        int dataLength = data.readableBytes();
        int written = 0;
        int length = rand.nextInt(100);
        while (written + length < dataLength) {
            in = data.retainedSlice(written, length);
            Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
            Assertions.assertEquals((int)0, (int)in.readableBytes());
            written += length;
            length = rand.nextInt(100);
        }
        in = data.retainedSlice(written, dataLength - written);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)0, (int)in.readableBytes());
        ByteBuf decompressed = this.readDecompressed(dataLength);
        Assertions.assertEquals((Object)data, (Object)decompressed);
        decompressed.release();
        data.release();
    }

    protected ByteBuf readDecompressed(int dataLength) throws Exception {
        ByteBuf msg;
        CompositeByteBuf compressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)this.channel.readOutbound()) != null) {
            compressed.addComponent(true, msg);
        }
        return this.decompress((ByteBuf)compressed, dataLength);
    }
}

