/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import org.junit.jupiter.api.BeforeAll;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.AbstractEncoderTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.Brotli;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.BrotliDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.BrotliEncoder;

public class BrotliEncoderTest
extends AbstractEncoderTest {
    private EmbeddedChannel ENCODER_CHANNEL;
    private EmbeddedChannel DECODER_CHANNEL;

    @BeforeAll
    static void setUp() {
        try {
            Brotli.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }

    @Override
    public EmbeddedChannel createChannel() {
        this.ENCODER_CHANNEL = new EmbeddedChannel(new ChannelHandler[]{new BrotliEncoder()});
        this.DECODER_CHANNEL = new EmbeddedChannel(new ChannelHandler[]{new BrotliDecoder()});
        return this.ENCODER_CHANNEL;
    }

    @Override
    public void destroyChannel() {
        this.ENCODER_CHANNEL.finishAndReleaseAll();
        this.DECODER_CHANNEL.finishAndReleaseAll();
    }

    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) {
        this.DECODER_CHANNEL.writeInbound(new Object[]{compressed});
        ByteBuf aggregatedBuffer = Unpooled.buffer();
        ByteBuf decompressed = (ByteBuf)this.DECODER_CHANNEL.readInbound();
        while (decompressed != null) {
            aggregatedBuffer.writeBytes(decompressed);
            decompressed.release();
            decompressed = (ByteBuf)this.DECODER_CHANNEL.readInbound();
        }
        return aggregatedBuffer;
    }

    @Override
    protected ByteBuf readDecompressed(int dataLength) throws Exception {
        ByteBuf msg;
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)this.channel.readOutbound()) != null) {
            if (msg.isReadable()) {
                decompressed.addComponent(true, this.decompress(msg, -1));
                continue;
            }
            msg.release();
        }
        return decompressed;
    }
}

