/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHashFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufInputStream;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.EncoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.AbstractEncoderTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.Lz4FrameEncoder;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class Lz4FrameEncoderTest
extends AbstractEncoderTest {
    private static final int NONALLOCATABLE_SIZE = 1;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private ByteBuf buffer;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)ByteBufAllocator.DEFAULT);
    }

    @Override
    protected EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new Lz4FrameEncoder()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) throws Exception {
        ByteBufInputStream is = new ByteBufInputStream(compressed, true);
        LZ4BlockInputStream lz4Is = null;
        byte[] decompressed = new byte[originalLength];
        try {
            int read;
            lz4Is = new LZ4BlockInputStream((InputStream)is);
            for (int remaining = originalLength; remaining > 0 && (read = lz4Is.read(decompressed, originalLength - remaining, remaining)) > 0; remaining -= read) {
            }
            Assertions.assertEquals((int)-1, (int)lz4Is.read());
        }
        finally {
            if (lz4Is != null) {
                lz4Is.close();
            } else {
                is.close();
            }
        }
        return Unpooled.wrappedBuffer((byte[])decompressed);
    }

    @Test
    public void testAllocateDirectBuffer() {
        int blockSize = 100;
        this.testAllocateBuffer(100, 87, true);
        this.testAllocateBuffer(100, 500, true);
        this.testAllocateBuffer(100, 1, true);
    }

    @Test
    public void testAllocateHeapBuffer() {
        int blockSize = 100;
        this.testAllocateBuffer(100, 87, false);
        this.testAllocateBuffer(100, 500, false);
        this.testAllocateBuffer(100, 1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAllocateBuffer(int blockSize, int bufSize, boolean preferDirect) {
        ByteBuf in = ByteBufAllocator.DEFAULT.buffer(bufSize, bufSize);
        in.writerIndex(in.capacity());
        ByteBuf out = null;
        try {
            Lz4FrameEncoder encoder = this.newEncoder(blockSize, Integer.MAX_VALUE);
            out = encoder.allocateBuffer(this.ctx, in, preferDirect);
            Assertions.assertNotNull((Object)out);
            if (1 == bufSize) {
                Assertions.assertFalse((boolean)out.isWritable());
            } else {
                Assertions.assertTrue((out.writableBytes() > 0 ? 1 : 0) != 0);
                if (!preferDirect) {
                    Assertions.assertFalse((boolean)out.isDirect());
                }
            }
        }
        finally {
            in.release();
            if (out != null) {
                out.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocateDirectBufferExceedMaxEncodeSize() {
        int maxEncodeSize = 1024;
        final Lz4FrameEncoder encoder = this.newEncoder(65536, 1024);
        int inputBufferSize = 10240;
        final ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(inputBufferSize, inputBufferSize);
        try {
            buf.writerIndex(inputBufferSize);
            Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

                public void execute() {
                    encoder.allocateBuffer(Lz4FrameEncoderTest.this.ctx, buf, false);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    private Lz4FrameEncoder newEncoder(int blockSize, int maxEncodeSize) {
        Checksum checksum = XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum();
        Lz4FrameEncoder encoder = new Lz4FrameEncoder(LZ4Factory.fastestInstance(), true, blockSize, checksum, maxEncodeSize);
        encoder.handlerAdded(this.ctx);
        return encoder;
    }

    @Test
    public void testAllocateOnHeapBufferOverflowsOutputSize() {
        int maxEncodeSize = Integer.MAX_VALUE;
        final Lz4FrameEncoder encoder = this.newEncoder(65536, Integer.MAX_VALUE);
        Mockito.when((Object)this.buffer.readableBytes()).thenReturn((Object)Integer.MAX_VALUE);
        this.buffer.writerIndex(Integer.MAX_VALUE);
        Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

            public void execute() {
                encoder.allocateBuffer(Lz4FrameEncoderTest.this.ctx, Lz4FrameEncoderTest.this.buffer, false);
            }
        });
    }

    @Test
    public void testFlush() {
        Lz4FrameEncoder encoder = new Lz4FrameEncoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        int size = 27;
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(size, size);
        buf.writerIndex(size);
        Assertions.assertEquals((int)0, (int)encoder.getBackingBuffer().readableBytes());
        channel.write((Object)buf);
        Assertions.assertTrue((boolean)channel.outboundMessages().isEmpty());
        Assertions.assertEquals((int)size, (int)encoder.getBackingBuffer().readableBytes());
        channel.flush();
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertTrue((boolean)channel.releaseOutbound());
        Assertions.assertFalse((boolean)channel.releaseInbound());
    }

    @Test
    public void testAllocatingAroundBlockSize() {
        int blockSize = 100;
        Lz4FrameEncoder encoder = this.newEncoder(blockSize, Integer.MAX_VALUE);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        int size = blockSize - 1;
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(size, size);
        buf.writerIndex(size);
        Assertions.assertEquals((int)0, (int)encoder.getBackingBuffer().readableBytes());
        channel.write((Object)buf);
        Assertions.assertEquals((int)size, (int)encoder.getBackingBuffer().readableBytes());
        int nextSize = size - 1;
        buf = ByteBufAllocator.DEFAULT.buffer(nextSize, nextSize);
        buf.writerIndex(nextSize);
        channel.write((Object)buf);
        Assertions.assertEquals((int)(size + nextSize - blockSize), (int)encoder.getBackingBuffer().readableBytes());
        channel.flush();
        Assertions.assertEquals((int)0, (int)encoder.getBackingBuffer().readableBytes());
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertTrue((boolean)channel.releaseOutbound());
        Assertions.assertFalse((boolean)channel.releaseInbound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void writingAfterClosedChannelDoesNotNPE() throws InterruptedException {
        NioEventLoopGroup group = new NioEventLoopGroup(2);
        Channel serverChannel = null;
        Channel clientChannel = null;
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference writeFailCauseRef = new AtomicReference();
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)group);
            sb.channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                }
            });
            Bootstrap bs = new Bootstrap();
            bs.group((EventLoopGroup)group);
            bs.channel(NioSocketChannel.class);
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new Lz4FrameEncoder()});
                }
            });
            serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            final Channel finalClientChannel = clientChannel = bs.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            clientChannel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    finalClientChannel.close();
                    int size = 27;
                    ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(27, 27);
                    finalClientChannel.writeAndFlush((Object)buf.writerIndex(buf.writerIndex() + 27)).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            try {
                                writeFailCauseRef.set(future.cause());
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
            });
            latch.await();
            Throwable writeFailCause = (Throwable)writeFailCauseRef.get();
            Assertions.assertNotNull((Object)writeFailCause);
            Throwable writeFailCauseCause = writeFailCause.getCause();
            if (writeFailCauseCause != null) {
                MatcherAssert.assertThat((Object)writeFailCauseCause, (Matcher)Is.is((Matcher)Matchers.not((Matcher)Matchers.instanceOf(NullPointerException.class))));
            }
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close();
            }
            if (clientChannel != null) {
                clientChannel.close();
            }
            group.shutdownGracefully();
        }
    }
}

