/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import com.ning.compress.lzf.LZFEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.AbstractDecoderTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.DecompressionException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.LzfDecoder;

public class LzfDecoderTest
extends AbstractDecoderTest {
    @Override
    protected EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new LzfDecoder()});
    }

    @Test
    public void testUnexpectedBlockIdentifier() {
        final ByteBuf in = Unpooled.buffer();
        in.writeShort(4660);
        in.writeByte(0);
        in.writeShort(0);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                LzfDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"unexpected block identifier");
    }

    @Test
    public void testUnknownTypeOfChunk() {
        final ByteBuf in = Unpooled.buffer();
        in.writeByte(90);
        in.writeByte(86);
        in.writeByte(255);
        in.writeInt(0);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                LzfDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"unknown type of chunk");
    }

    @Override
    protected byte[] compress(byte[] data) throws Exception {
        return LZFEncoder.encode((byte[])data);
    }
}

