/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.DecompressionException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.SnappyFrameDecoder;

public class SnappyFrameDecoderTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void initChannel() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameDecoder()});
    }

    @AfterEach
    public void tearDown() {
        Assertions.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test
    public void testReservedUnskippableChunkTypeCausesError() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{3, 1, 0, 0, 0});
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                SnappyFrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        });
    }

    @Test
    public void testInvalidStreamIdentifierLength() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-128, 5, 0, 0, 110, 101, 116, 116, 121});
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                SnappyFrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        });
    }

    @Test
    public void testInvalidStreamIdentifierValue() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 110, 101, 116, 116, 121});
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                SnappyFrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        });
    }

    @Test
    public void testReservedSkippableBeforeStreamIdentifier() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-127, 6, 0, 0, 115, 110, 101, 116, 116, 121});
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                SnappyFrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        });
    }

    @Test
    public void testUncompressedDataBeforeStreamIdentifier() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{1, 5, 0, 0, 110, 101, 116, 116, 121});
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SnappyFrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        });
    }

    @Test
    public void testCompressedDataBeforeStreamIdentifier() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{0, 5, 0, 0, 110, 101, 116, 116, 121});
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                SnappyFrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        });
    }

    @Test
    public void testReservedSkippableSkipsInput() {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, -127, 5, 0, 0, 110, 101, 116, 116, 121});
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{in}));
        Assertions.assertNull((Object)this.channel.readInbound());
        Assertions.assertFalse((boolean)in.isReadable());
    }

    @Test
    public void testUncompressedDataAppendsToOut() {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 1, 9, 0, 0, 0, 0, 0, 0, 110, 101, 116, 116, 121});
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{in}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        ByteBuf actual = (ByteBuf)this.channel.readInbound();
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    @Test
    public void testCompressedDataDecodesAndAppendsToOut() {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 0, 11, 0, 0, 0, 0, 0, 0, 5, 16, 110, 101, 116, 116, 121});
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{in}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        ByteBuf actual = (ByteBuf)this.channel.readInbound();
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    @Test
    public void testInvalidChecksumThrowsException() {
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameDecoder(true)});
        try {
            final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 1, 9, 0, 0, 0, 0, 0, 0, 110, 101, 116, 116, 121});
            Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

                public void execute() {
                    channel.writeInbound(new Object[]{in});
                }
            });
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidChecksumDoesNotThrowException() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameDecoder(true)});
        try {
            ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 1, 9, 0, 0, 111, -104, 46, -71, 110, 101, 116, 116, 121});
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
            ByteBuf actual = (ByteBuf)channel.readInbound();
            Assertions.assertEquals((Object)expected, (Object)actual);
            expected.release();
            actual.release();
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }
}

