/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import java.util.Random;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.AbstractIntegrationTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.SnappyFrameDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.SnappyFrameEncoder;

public class SnappyIntegrationTest
extends AbstractIntegrationTest {
    private static final int RANDOM_RUNS = 1;

    @Override
    protected EmbeddedChannel createEncoder() {
        return new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameEncoder()});
    }

    @Override
    protected EmbeddedChannel createDecoder() {
        return new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameDecoder()});
    }

    @Test
    public void test1002() throws Throwable {
        byte[] data = new byte[]{11, 0, 0, 0, 0, 0, 16, 65, 96, 119, -22, 79, -43, 76, -75, -93, 11, 104, 96, -99, 126, -98, 27, -36, 40, 117, -65, -3, -57, -83, -58, 7, 114, -14, 68, -122, 124, 88, 118, 54, 45, -26, 117, 13, -45, -9, 60, -73, -53, -44, 53, 68, -77, -71, 109, 43, -38, 59, 100, -12, -87, 44, -106, 123, -107, 38, 13, -117, -23, -49, 29, 21, 26, 66, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66, 0, -104, -49, 16, -120, 22, 8, -52, -54, -102, -52, -119, -124, -92, -71, 101, -120, -52, -48, 45, -26, -24, 26, 41, -13, 36, 64, -47, 15, -124, -7, -16, 91, 96, 0, -93, -42, 101, 20, -74, 39, -124, 35, 43, -49, -21, -92, -20, -41, 79, 41, 110, -105, 42, -96, 90, -9, -100, -22, -62, 91, 2, 35, 113, 117, -71, 66, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.testIdentity(data, true);
    }

    @Test
    public void test5323211032315942961() {
        this.testWithSeed(5323211032315942961L);
    }

    @Test
    public void test7088170877360183401() {
        this.testWithSeed(7088170877360183401L);
    }

    @Test
    public void testRandom() throws Throwable {
        for (int i = 0; i < 1; ++i) {
            long seed = rand.nextLong();
            if (seed < 0L) continue;
            try {
                this.testWithSeed(seed);
                continue;
            }
            catch (Throwable t) {
                System.out.println("Failed with random seed " + seed + ". Here is a test for it:\n");
                SnappyIntegrationTest.printSeedAsTest(seed);
                throw t;
            }
        }
    }

    private void testWithSeed(long seed) {
        byte[] data = new byte[0x1000000];
        new Random(seed).nextBytes(data);
        this.testIdentity(data, true);
    }

    private static void printSeedAsTest(long l) {
        System.out.println("@Test");
        System.out.println("@Ignore");
        System.out.println("public void test" + l + "(){");
        System.out.println("    testWithSeed(" + l + "L);");
        System.out.println("}");
    }
}

