/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import com.github.luben.zstd.ZstdInputStream;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufInputStream;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.AbstractEncoderTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.ZstdEncoder;

public class ZstdEncoderTest
extends AbstractEncoderTest {
    @Mock
    private ChannelHandlerContext ctx;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)ByteBufAllocator.DEFAULT);
    }

    @Override
    public EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new ZstdEncoder()});
    }

    @ParameterizedTest
    @MethodSource(value={"largeData"})
    public void testCompressionOfLargeBatchedFlow(ByteBuf data) throws Exception {
        int dataLength = data.readableBytes();
        int written = 0;
        ByteBuf in = data.retainedSlice(written, 65535);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
        ByteBuf in2 = data.retainedSlice(65535, dataLength - 65535);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in2}));
        Assertions.assertTrue((boolean)this.channel.finish());
        ByteBuf decompressed = this.readDecompressed(dataLength);
        Assertions.assertEquals((Object)data, (Object)decompressed);
        decompressed.release();
        data.release();
    }

    @ParameterizedTest
    @MethodSource(value={"smallData"})
    public void testCompressionOfSmallBatchedFlow(ByteBuf data) throws Exception {
        this.testCompressionOfBatchedFlow(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) throws Exception {
        ByteBufInputStream is = new ByteBufInputStream(compressed, true);
        ZstdInputStream zstdIs = null;
        byte[] decompressed = new byte[originalLength];
        try {
            int read;
            zstdIs = new ZstdInputStream((InputStream)is);
            for (int remaining = originalLength; remaining > 0 && (read = zstdIs.read(decompressed, originalLength - remaining, remaining)) > 0; remaining -= read) {
            }
            Assertions.assertEquals((int)-1, (int)zstdIs.read());
        }
        finally {
            if (zstdIs != null) {
                zstdIs.close();
            } else {
                is.close();
            }
        }
        return Unpooled.wrappedBuffer((byte[])decompressed);
    }
}

