/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.frame;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DecoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.TooLongFrameException;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class LengthFieldBasedFrameDecoderTest {
    @Test
    public void testFailSlowTooLongFrameRecovery() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(5, 0, 4, 0, 4, false)});
        for (int i = 0; i < 2; ++i) {
            Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 2})}));
            try {
                Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0})}));
                Assertions.fail((String)(DecoderException.class.getSimpleName() + " must be raised."));
            }
            catch (TooLongFrameException tooLongFrameException) {
                // empty catch block
            }
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 1, 65})});
            ByteBuf buf = (ByteBuf)ch.readInbound();
            Assertions.assertEquals((Object)"A", (Object)buf.toString(CharsetUtil.ISO_8859_1));
            buf.release();
        }
    }

    @Test
    public void testFailFastTooLongFrameRecovery() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(5, 0, 4, 0, 4)});
        for (int i = 0; i < 2; ++i) {
            try {
                Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 2})}));
                Assertions.fail((String)(DecoderException.class.getSimpleName() + " must be raised."));
            }
            catch (TooLongFrameException tooLongFrameException) {
                // empty catch block
            }
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 0, 0, 1, 65})});
            ByteBuf buf = (ByteBuf)ch.readInbound();
            Assertions.assertEquals((Object)"A", (Object)buf.toString(CharsetUtil.ISO_8859_1));
            buf.release();
        }
    }
}

