/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.flush;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.flush.FlushConsolidationHandler;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class FlushConsolidationHandlerTest {
    private static final int EXPLICIT_FLUSH_AFTER_FLUSHES = 3;

    @Test
    public void testFlushViaScheduledTask() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, true);
        channel.flush();
        Assertions.assertEquals((int)0, (int)flushCount.get());
        channel.flush();
        Assertions.assertEquals((int)0, (int)flushCount.get());
        channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)flushCount.get());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaThresholdOutsideOfReadLoop() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, true);
        for (int i = 0; i < 3; ++i) {
            channel.flush();
        }
        Assertions.assertEquals((int)1, (int)flushCount.get());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testImmediateFlushOutsideOfReadLoop() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.flush();
        Assertions.assertEquals((int)1, (int)flushCount.get());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaReadComplete() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.flush();
        channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)flushCount.get());
        channel.pipeline().fireChannelRead((Object)1L);
        Assertions.assertEquals((int)1, (int)flushCount.get());
        channel.pipeline().fireChannelRead((Object)2L);
        Assertions.assertEquals((int)1, (int)flushCount.get());
        Assertions.assertNull((Object)channel.readOutbound());
        channel.pipeline().fireChannelReadComplete();
        Assertions.assertEquals((int)2, (int)flushCount.get());
        channel.flush();
        channel.runPendingTasks();
        Assertions.assertEquals((int)3, (int)flushCount.get());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)2L, (Long)((Long)channel.readOutbound()));
        Assertions.assertNull((Object)channel.readOutbound());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaClose() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.pipeline().fireChannelRead((Object)1L);
        Assertions.assertEquals((int)0, (int)flushCount.get());
        Assertions.assertNull((Object)channel.readOutbound());
        channel.close();
        Assertions.assertEquals((int)1, (int)flushCount.get());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertNull((Object)channel.readOutbound());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaDisconnect() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.pipeline().fireChannelRead((Object)1L);
        Assertions.assertEquals((int)0, (int)flushCount.get());
        Assertions.assertNull((Object)channel.readOutbound());
        channel.disconnect();
        Assertions.assertEquals((int)1, (int)flushCount.get());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertNull((Object)channel.readOutbound());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaException() {
        AtomicInteger flushCount = new AtomicInteger();
        final EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.pipeline().fireChannelRead((Object)1L);
        Assertions.assertEquals((int)0, (int)flushCount.get());
        Assertions.assertNull((Object)channel.readOutbound());
        channel.pipeline().fireExceptionCaught((Throwable)new IllegalStateException());
        Assertions.assertEquals((int)1, (int)flushCount.get());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertNull((Object)channel.readOutbound());
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                channel.finish();
            }
        });
    }

    @Test
    public void testFlushViaRemoval() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.pipeline().fireChannelRead((Object)1L);
        Assertions.assertEquals((int)0, (int)flushCount.get());
        Assertions.assertNull((Object)channel.readOutbound());
        channel.pipeline().remove(FlushConsolidationHandler.class);
        Assertions.assertEquals((int)1, (int)flushCount.get());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertNull((Object)channel.readOutbound());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testResend() throws Exception {
        AtomicInteger flushCount = new AtomicInteger();
        final EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, true);
        channel.writeAndFlush((Object)1L).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                channel.writeAndFlush((Object)1L);
            }
        });
        channel.flushOutbound();
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertNull((Object)channel.readOutbound());
        Assertions.assertFalse((boolean)channel.finish());
    }

    private static EmbeddedChannel newChannel(final AtomicInteger flushCount, boolean consolidateWhenNoReadInProgress) {
        return new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                flushCount.incrementAndGet();
                ctx.flush();
            }
        }, new FlushConsolidationHandler(3, consolidateWhenNoReadInProgress), new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.writeAndFlush(msg);
            }
        }});
    }
}

