/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.ChannelInputShutdownEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DecoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.CloseNotifyTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;

public class ApplicationProtocolNegotiationHandlerTest {
    @Test
    public void testRemoveItselfIfNoSslHandlerPresent() throws NoSuchAlgorithmException {
        ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                Assertions.fail();
            }
        };
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{alpnHandler});
        String msg = "msg";
        String msg2 = "msg2";
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{msg}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{msg2}));
        Assertions.assertNull((Object)channel.pipeline().context((ChannelHandler)alpnHandler));
        Assertions.assertEquals((Object)msg, (Object)channel.readInbound());
        Assertions.assertEquals((Object)msg2, (Object)channel.readInbound());
        Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void testHandshakeFailure() {
        ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                Assertions.fail();
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{alpnHandler});
        SSLHandshakeException exception = new SSLHandshakeException("error");
        SslHandshakeCompletionEvent completionEvent = new SslHandshakeCompletionEvent((Throwable)exception);
        channel.pipeline().fireUserEventTriggered((Object)completionEvent);
        channel.pipeline().fireExceptionCaught((Throwable)new DecoderException((Throwable)exception));
        Assertions.assertNull((Object)channel.pipeline().context((ChannelHandler)alpnHandler));
        Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void testHandshakeSuccess() throws NoSuchAlgorithmException {
        ApplicationProtocolNegotiationHandlerTest.testHandshakeSuccess0(false);
    }

    @Test
    public void testHandshakeSuccessWithSslHandlerAddedLater() throws NoSuchAlgorithmException {
        ApplicationProtocolNegotiationHandlerTest.testHandshakeSuccess0(true);
    }

    private static void testHandshakeSuccess0(boolean addLater) throws NoSuchAlgorithmException {
        final AtomicBoolean configureCalled = new AtomicBoolean(false);
        ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                configureCalled.set(true);
                Assertions.assertEquals((Object)"http/1.1", (Object)protocol);
            }
        };
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        EmbeddedChannel channel = new EmbeddedChannel();
        if (addLater) {
            channel.pipeline().addLast(new ChannelHandler[]{alpnHandler});
            channel.pipeline().addFirst(new ChannelHandler[]{new SslHandler(engine)});
        } else {
            channel.pipeline().addLast(new ChannelHandler[]{new SslHandler(engine)});
            channel.pipeline().addLast(new ChannelHandler[]{alpnHandler});
        }
        channel.pipeline().fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
        Assertions.assertNull((Object)channel.pipeline().context((ChannelHandler)alpnHandler));
        channel.releaseOutbound();
        channel.close();
        CloseNotifyTest.assertCloseNotify((ByteBuf)channel.readOutbound());
        channel.finishAndReleaseAll();
        Assertions.assertTrue((boolean)configureCalled.get());
    }

    @Test
    public void testHandshakeSuccessButNoSslHandler() {
        ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                Assertions.fail();
            }
        };
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{alpnHandler});
        channel.pipeline().fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
        Assertions.assertNull((Object)channel.pipeline().context((ChannelHandler)alpnHandler));
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                channel.finishAndReleaseAll();
            }
        });
    }

    @Test
    public void testBufferMessagesUntilHandshakeComplete() throws Exception {
        this.testBufferMessagesUntilHandshakeComplete(null);
    }

    @Test
    public void testBufferMessagesUntilHandshakeCompleteWithClose() throws Exception {
        this.testBufferMessagesUntilHandshakeComplete(new Consumer<ChannelHandlerContext>(){

            @Override
            public void consume(ChannelHandlerContext ctx) {
                ctx.channel().close();
            }
        });
    }

    @Test
    public void testBufferMessagesUntilHandshakeCompleteWithInputShutdown() throws Exception {
        this.testBufferMessagesUntilHandshakeComplete(new Consumer<ChannelHandlerContext>(){

            @Override
            public void consume(ChannelHandlerContext ctx) {
                ctx.fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
            }
        });
    }

    private void testBufferMessagesUntilHandshakeComplete(final Consumer<ChannelHandlerContext> pipelineConfigurator) throws Exception {
        final AtomicReference channelReadData = new AtomicReference();
        final AtomicBoolean channelReadCompleteCalled = new AtomicBoolean(false);
        ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                Assertions.assertEquals((Object)"http/1.1", (Object)protocol);
                ctx.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        channelReadData.set((byte[])msg);
                    }

                    public void channelReadComplete(ChannelHandlerContext ctx) {
                        channelReadCompleteCalled.set(true);
                    }
                }});
                if (pipelineConfigurator != null) {
                    pipelineConfigurator.consume(ctx);
                }
            }
        };
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        final byte[] someBytes = new byte[1024];
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine), new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                    ctx.fireChannelRead((Object)someBytes);
                }
                ctx.fireUserEventTriggered(evt);
            }
        }, alpnHandler});
        channel.pipeline().fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
        Assertions.assertNull((Object)channel.pipeline().context((ChannelHandler)alpnHandler));
        Assertions.assertArrayEquals((byte[])someBytes, (byte[])((byte[])channelReadData.get()));
        Assertions.assertTrue((boolean)channelReadCompleteCalled.get());
        Assertions.assertNull((Object)channel.readInbound());
        Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    private static interface Consumer<T> {
        public void consume(T var1);
    }
}

