/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.security.Provider;
import javax.net.ssl.SSLSessionContext;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.Conscrypt;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.Java8SslTestUtils;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SSLEngineTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;

@DisabledIf(value="checkConscryptDisabled")
public class ConscryptJdkSslEngineInteropTest
extends SSLEngineTest {
    public ConscryptJdkSslEngineInteropTest() {
        super(false);
    }

    static boolean checkConscryptDisabled() {
        return !Conscrypt.isAvailable();
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected Provider clientSslContextProvider() {
        return Java8SslTestUtils.conscryptProvider();
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    protected boolean mySetupMutualAuthServerIsValidServerException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidServerException(cause) || ConscryptJdkSslEngineInteropTest.causedBySSLException(cause);
    }

    @Override
    protected void invalidateSessionsAndAssert(SSLSessionContext context) {
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disabled due a conscrypt bug")
    public void testInvalidSNIIsIgnoredAndNotThrow(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        super.testInvalidSNIIsIgnoredAndNotThrow(param);
    }
}

