/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ClientAuth;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.Java8SslTestUtils;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.JdkSslEngine;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslContextOption;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslEngineTestParam;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslSessionContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslTestUtils;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.PseudoRandomFunction;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SSLEngineTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextOption;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslUtils;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.internal.tcnative.SSL;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;
import org.opentest4j.TestAbortedException;

public class OpenSslEngineTest
extends SSLEngineTest {
    private static final String PREFERRED_APPLICATION_LEVEL_PROTOCOL = "my-protocol-http2";
    private static final String FALLBACK_APPLICATION_LEVEL_PROTOCOL = "my-protocol-http1_1";

    public OpenSslEngineTest() {
        super(SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL));
    }

    @Override
    protected List<SSLEngineTest.SSLEngineTestParam> newTestParams() {
        List<SSLEngineTest.SSLEngineTestParam> params = super.newTestParams();
        ArrayList<SSLEngineTest.SSLEngineTestParam> testParams = new ArrayList<SSLEngineTest.SSLEngineTestParam>();
        for (SSLEngineTest.SSLEngineTestParam param : params) {
            testParams.add(new OpenSslEngineTestParam(true, param));
            testParams.add(new OpenSslEngineTestParam(false, param));
        }
        return testParams;
    }

    @BeforeAll
    public static void checkOpenSsl() {
        OpenSsl.ensureAvailability();
    }

    @Override
    @AfterEach
    public void tearDown() throws InterruptedException {
        super.tearDown();
        Assertions.assertEquals((int)0, (int)SSL.getLastErrorNumber(), (String)"SSL error stack not correctly consumed");
    }

    @Override
    public void testSessionAfterHandshakeKeyManagerFactory(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactory(param);
    }

    @Override
    public void testSessionAfterHandshakeKeyManagerFactoryMutualAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactoryMutualAuth(param);
    }

    @Override
    public void testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth(param);
    }

    @Override
    public void testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth(param);
    }

    @Override
    public void testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth(param);
    }

    @Override
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(param);
    }

    @Override
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(param);
    }

    @Override
    public void testHandshakeSession(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testHandshakeSession(param);
    }

    @Override
    public void testSupportedSignatureAlgorithms(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSupportedSignatureAlgorithms(param);
    }

    private static boolean isNpnSupported(String versionString) {
        String[] versionParts;
        String[] versionStringParts = versionString.split(" ", -1);
        if (versionStringParts.length == 2 && "LibreSSL".equals(versionStringParts[0]) && (versionParts = versionStringParts[1].split("\\.", -1)).length == 3) {
            int major = Integer.parseInt(versionParts[0]);
            if (major < 2) {
                return true;
            }
            if (major > 2) {
                return false;
            }
            int minor = Integer.parseInt(versionParts[1]);
            if (minor < 6) {
                return true;
            }
            if (minor > 6) {
                return false;
            }
            int bugfix = Integer.parseInt(versionParts[2]);
            if (bugfix > 0) {
                return false;
            }
        }
        return true;
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testNpn(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        String versionString = OpenSsl.versionString();
        Assumptions.assumeTrue((boolean)OpenSslEngineTest.isNpnSupported(versionString), (String)("LibreSSL 2.6.1 removed NPN support, detected " + versionString));
        ApplicationProtocolConfig apn = OpenSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.NPN, PREFERRED_APPLICATION_LEVEL_PROTOCOL);
        this.setupHandlers(param, apn);
        this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testAlpn(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isAlpnSupported());
        ApplicationProtocolConfig apn = OpenSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, PREFERRED_APPLICATION_LEVEL_PROTOCOL);
        this.setupHandlers(param, apn);
        this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testAlpnCompatibleProtocolsDifferentClientOrder(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isAlpnSupported());
        ApplicationProtocolConfig clientApn = OpenSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, FALLBACK_APPLICATION_LEVEL_PROTOCOL, PREFERRED_APPLICATION_LEVEL_PROTOCOL);
        ApplicationProtocolConfig serverApn = OpenSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, PREFERRED_APPLICATION_LEVEL_PROTOCOL, FALLBACK_APPLICATION_LEVEL_PROTOCOL);
        this.setupHandlers(param, serverApn, clientApn);
        Assertions.assertNull((Object)this.serverException);
        this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testEnablingAnAlreadyDisabledSslProtocol(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.testEnablingAnAlreadyDisabledSslProtocol(param, new String[]{"SSLv2Hello"}, new String[]{"SSLv2Hello", "TLSv1.2"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testWrapBuffersNoWritePendingError(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            ByteBuffer src = this.allocateBuffer(param.type(), 10240);
            byte[] data = new byte[src.capacity()];
            PlatformDependent.threadLocalRandom().nextBytes(data);
            src.put(data).flip();
            ByteBuffer dst = this.allocateBuffer(param.type(), 1);
            for (int i = 0; i < 100; ++i) {
                src.position(0);
                dst.position(0);
                Assertions.assertSame((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)clientEngine.wrap(src, dst).getStatus()));
            }
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testOnlySmallBufferNeededForWrap(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            int srcLen = 1024;
            ByteBuffer src = this.allocateBuffer(param.type(), srcLen);
            ByteBuffer dstTooSmall = this.allocateBuffer(param.type(), src.capacity() + this.unwrapEngine(clientEngine).maxWrapOverhead() - 1);
            ByteBuffer dst = this.allocateBuffer(param.type(), src.capacity() + this.unwrapEngine(clientEngine).maxWrapOverhead());
            SSLEngineResult result = clientEngine.wrap(src, dstTooSmall);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)0, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
            Assertions.assertEquals((int)src.remaining(), (int)src.capacity());
            Assertions.assertEquals((int)dst.remaining(), (int)dst.capacity());
            result = clientEngine.wrap(src, dst);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)srcLen, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)src.remaining());
            Assertions.assertTrue((result.bytesProduced() > srcLen ? 1 : 0) != 0);
            Assertions.assertEquals((int)(src.capacity() - result.bytesConsumed()), (int)src.remaining());
            Assertions.assertEquals((int)(dst.capacity() - result.bytesProduced()), (int)dst.remaining());
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testNeededDstCapacityIsCorrectlyCalculated(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            ByteBuffer src = this.allocateBuffer(param.type(), 1024);
            ByteBuffer src2 = src.duplicate();
            ByteBuffer dst = this.allocateBuffer(param.type(), src.capacity() + this.unwrapEngine(clientEngine).maxWrapOverhead());
            SSLEngineResult result = clientEngine.wrap(new ByteBuffer[]{src, src2}, dst);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)0, (int)src.position());
            Assertions.assertEquals((int)0, (int)src2.position());
            Assertions.assertEquals((int)0, (int)dst.position());
            Assertions.assertEquals((int)0, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSrcsLenOverFlowCorrectlyHandled(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            ByteBuffer dup;
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            ByteBuffer src = this.allocateBuffer(param.type(), 1024);
            ArrayList<ByteBuffer> srcList = new ArrayList<ByteBuffer>();
            long maxLen = 0xFFFFFFFEL;
            for (long srcsLen = 0L; srcsLen < maxLen; srcsLen += (long)dup.capacity()) {
                dup = src.duplicate();
                srcList.add(dup);
            }
            ByteBuffer[] srcs = srcList.toArray(new ByteBuffer[0]);
            ByteBuffer dst = this.allocateBuffer(param.type(), this.unwrapEngine(clientEngine).maxEncryptedPacketLength() - 1);
            SSLEngineResult result = clientEngine.wrap(srcs, dst);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            for (ByteBuffer buffer : srcs) {
                Assertions.assertEquals((int)0, (int)buffer.position());
            }
            Assertions.assertEquals((int)0, (int)dst.position());
            Assertions.assertEquals((int)0, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testCalculateOutNetBufSizeOverflow(SSLEngineTest.SSLEngineTestParam param) throws SSLException {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        try {
            clientEngine = this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            int value = ((ReferenceCountedOpenSslEngine)clientEngine).calculateOutNetBufSize(Integer.MAX_VALUE, 1);
            Assertions.assertTrue((value > 0 ? 1 : 0) != 0);
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testCalculateOutNetBufSize0(SSLEngineTest.SSLEngineTestParam param) throws SSLException {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        try {
            clientEngine = this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            Assertions.assertTrue((((ReferenceCountedOpenSslEngine)clientEngine).calculateOutNetBufSize(0, 1) > 0 ? 1 : 0) != 0);
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testCorrectlyCalculateSpaceForAlert(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.testCorrectlyCalculateSpaceForAlert(param, true);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testCorrectlyCalculateSpaceForAlertJDKCompatabilityModeOff(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.testCorrectlyCalculateSpaceForAlert(param, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCorrectlyCalculateSpaceForAlert(SSLEngineTest.SSLEngineTestParam param, boolean jdkCompatabilityMode) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            if (jdkCompatabilityMode) {
                clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
                serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            } else {
                clientEngine = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
                serverEngine = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
            }
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            clientEngine.closeOutbound();
            ByteBuffer empty = this.allocateBuffer(param.type(), 0);
            ByteBuffer dst = this.allocateBuffer(param.type(), clientEngine.getSession().getPacketBufferSize());
            dst.limit(1);
            SSLEngineResult result = clientEngine.wrap(empty, dst);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            dst.limit(dst.capacity());
            result = clientEngine.wrap(empty, dst);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            dst.flip();
            int length = SslUtils.getEncryptedPacketLength((ByteBuffer[])new ByteBuffer[]{dst}, (int)0);
            Assertions.assertEquals((int)length, (int)dst.remaining());
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
        ssc.delete();
    }

    @Override
    protected void mySetupMutualAuthServerInitSslHandler(SslHandler handler) {
        ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)handler.engine();
        engine.setVerify(-1, 1);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testWrapWithDifferentSizesTLSv1(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).build());
        this.testWrapWithDifferentSizes(param, "TLSv1", "AES128-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "ECDHE-RSA-AES128-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "AECDH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "SEED-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "RC4-MD5");
        this.testWrapWithDifferentSizes(param, "TLSv1", "AES256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "ADH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "EDH-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "ADH-RC4-MD5");
        this.testWrapWithDifferentSizes(param, "TLSv1", "IDEA-CBC-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "RC4-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "AECDH-RC4-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "ECDHE-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "ECDHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1", "ECDHE-RSA-RC4-SHA");
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testWrapWithDifferentSizesTLSv1_1(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).build());
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "ECDHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "AES256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "ECDHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "SEED-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "IDEA-CBC-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "AECDH-RC4-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "ADH-RC4-MD5");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "RC4-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "ECDHE-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "EDH-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "AECDH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "ADH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.1", "DES-CBC3-SHA");
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testWrapWithDifferentSizesTLSv1_2(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).build());
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "AES128-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ECDHE-RSA-AES128-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "AES128-GCM-SHA256");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ECDHE-RSA-AES256-SHA384");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "AECDH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "AES256-GCM-SHA384");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "AES256-SHA256");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ECDHE-RSA-AES128-GCM-SHA256");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ECDHE-RSA-AES128-SHA256");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "SEED-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "RC4-MD5");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "AES256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ADH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "EDH-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ADH-RC4-MD5");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "RC4-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "AES128-SHA256");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "AECDH-RC4-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ECDHE-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ECDHE-RSA-AES256-GCM-SHA384");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ECDHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes(param, "TLSv1.2", "ECDHE-RSA-RC4-SHA");
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testWrapWithDifferentSizesSSLv3(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).build());
        this.testWrapWithDifferentSizes(param, "SSLv3", "ADH-AES128-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "ADH-CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "AECDH-AES128-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "AECDH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "DHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "SEED-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "RC4-MD5");
        this.testWrapWithDifferentSizes(param, "SSLv3", "ADH-AES256-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "ADH-SEED-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "ADH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "EDH-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "ADH-RC4-MD5");
        this.testWrapWithDifferentSizes(param, "SSLv3", "IDEA-CBC-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "DHE-RSA-AES128-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "RC4-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "AECDH-RC4-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "DHE-RSA-SEED-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "AECDH-AES256-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "ECDHE-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "ADH-CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "DHE-RSA-CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "DHE-RSA-CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes(param, "SSLv3", "ECDHE-RSA-RC4-SHA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMultipleRecordsInOneBufferWithNonZeroPositionJDKCompatabilityModeOff(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        try {
            int plainClientOutLen = 1024;
            ByteBuffer plainClientOut = this.allocateBuffer(param.type(), 1024);
            ByteBuffer plainServerOut = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize());
            ByteBuffer encClientToServer = this.allocateBuffer(param.type(), client.getSession().getPacketBufferSize());
            int positionOffset = 1;
            ByteBuffer combinedEncClientToServer = this.allocateBuffer(param.type(), encClientToServer.capacity() * 2 + positionOffset);
            combinedEncClientToServer.position(positionOffset);
            this.handshake(param.type(), param.delegate(), client, server);
            plainClientOut.limit(plainClientOut.capacity());
            SSLEngineResult result = client.wrap(plainClientOut, encClientToServer);
            Assertions.assertEquals((int)plainClientOut.capacity(), (int)result.bytesConsumed());
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encClientToServer.flip();
            combinedEncClientToServer.put(encClientToServer);
            plainClientOut.clear();
            encClientToServer.clear();
            result = client.wrap(plainClientOut, encClientToServer);
            Assertions.assertEquals((int)plainClientOut.capacity(), (int)result.bytesConsumed());
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encClientToServer.flip();
            combinedEncClientToServer.put(encClientToServer);
            encClientToServer.clear();
            combinedEncClientToServer.flip();
            combinedEncClientToServer.position(positionOffset);
            combinedEncClientToServer.limit(combinedEncClientToServer.limit() - positionOffset);
            int combinedEncClientToServerLen = combinedEncClientToServer.remaining();
            result = server.unwrap(combinedEncClientToServer, plainServerOut);
            Assertions.assertEquals((int)0, (int)combinedEncClientToServer.remaining());
            Assertions.assertEquals((int)combinedEncClientToServerLen, (int)result.bytesConsumed());
            Assertions.assertEquals((int)1024, (int)result.bytesProduced());
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testInputTooBigAndFillsUpBuffersJDKCompatabilityModeOff(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        try {
            ByteBuffer plainClient = this.allocateBuffer(param.type(), ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH + 100);
            ByteBuffer plainClient2 = this.allocateBuffer(param.type(), 512);
            ByteBuffer plainClientTotal = this.allocateBuffer(param.type(), plainClient.capacity() + plainClient2.capacity());
            plainClientTotal.put(plainClient);
            plainClientTotal.put(plainClient2);
            plainClient.clear();
            plainClient2.clear();
            plainClientTotal.flip();
            ByteBuffer encClientToServerTooSmall = this.allocateBuffer(param.type(), ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH + 28);
            ByteBuffer encClientToServer = this.allocateBuffer(param.type(), client.getSession().getApplicationBufferSize());
            ByteBuffer encClientToServerTotal = this.allocateBuffer(param.type(), client.getSession().getApplicationBufferSize() << 1);
            ByteBuffer plainServer = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize() << 1);
            this.handshake(param.type(), param.delegate(), client, server);
            int plainClientRemaining = plainClient.remaining();
            int encClientToServerTooSmallRemaining = encClientToServerTooSmall.remaining();
            SSLEngineResult result = client.wrap(plainClient, encClientToServerTooSmall);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)(plainClientRemaining - plainClient.remaining()), (int)result.bytesConsumed());
            Assertions.assertEquals((int)(encClientToServerTooSmallRemaining - encClientToServerTooSmall.remaining()), (int)result.bytesProduced());
            result = client.wrap(plainClient, encClientToServerTooSmall);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)0, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
            plainClientRemaining = plainClient.remaining();
            int encClientToServerRemaining = encClientToServer.remaining();
            result = client.wrap(plainClient, encClientToServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)plainClientRemaining, (int)result.bytesConsumed());
            Assertions.assertEquals((int)(encClientToServerRemaining - encClientToServer.remaining()), (int)result.bytesProduced());
            Assertions.assertEquals((int)0, (int)plainClient.remaining());
            int plainClient2Remaining = plainClient2.remaining();
            encClientToServerRemaining = encClientToServer.remaining();
            result = client.wrap(plainClient2, encClientToServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)plainClient2Remaining, (int)result.bytesConsumed());
            Assertions.assertEquals((int)(encClientToServerRemaining - encClientToServer.remaining()), (int)result.bytesProduced());
            encClientToServerTooSmall.flip();
            encClientToServer.flip();
            encClientToServerTotal.put(encClientToServerTooSmall);
            encClientToServerTotal.put(encClientToServer);
            encClientToServerTotal.flip();
            int encClientToServerTotalRemaining = encClientToServerTotal.remaining();
            result = server.unwrap(encClientToServerTotal, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)encClientToServerTotalRemaining, (int)result.bytesConsumed());
            plainServer.flip();
            Assertions.assertEquals((Object)plainClientTotal, (Object)plainServer);
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testPartialPacketUnwrapJDKCompatabilityModeOff(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        try {
            ByteBuffer plainClient = this.allocateBuffer(param.type(), 1024);
            ByteBuffer plainClient2 = this.allocateBuffer(param.type(), 512);
            ByteBuffer plainClientTotal = this.allocateBuffer(param.type(), plainClient.capacity() + plainClient2.capacity());
            plainClientTotal.put(plainClient);
            plainClientTotal.put(plainClient2);
            plainClient.clear();
            plainClient2.clear();
            plainClientTotal.flip();
            ByteBuffer encClientToServer = this.allocateBuffer(param.type(), client.getSession().getPacketBufferSize());
            ByteBuffer plainServer = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize());
            this.handshake(param.type(), param.delegate(), client, server);
            SSLEngineResult result = client.wrap(plainClient, encClientToServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)result.bytesConsumed(), (int)plainClient.capacity());
            int encClientLen = result.bytesProduced();
            result = client.wrap(plainClient2, encClientToServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)result.bytesConsumed(), (int)plainClient2.capacity());
            int encClientLen2 = result.bytesProduced();
            encClientToServer.flip();
            ByteBuffer encClientFirstHalf = encClientToServer.duplicate();
            encClientFirstHalf.limit(encClientLen / 2);
            result = server.unwrap(encClientFirstHalf, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)result.bytesConsumed(), (int)(encClientLen / 2));
            encClientToServer.position(result.bytesConsumed());
            ByteBuffer encClientAllButLastByte = encClientToServer.duplicate();
            int encClientAllButLastByteLen = encClientAllButLastByte.remaining() - 1;
            encClientAllButLastByte.limit(encClientAllButLastByte.limit() - 1);
            result = server.unwrap(encClientAllButLastByte, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)result.bytesConsumed(), (int)encClientAllButLastByteLen);
            encClientToServer.position(encClientToServer.position() + result.bytesConsumed());
            result = server.unwrap(encClientToServer, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)result.bytesConsumed(), (int)1);
            plainServer.flip();
            Assertions.assertEquals((Object)plainClientTotal, (Object)plainServer);
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testBufferUnderFlowAvoidedIfJDKCompatabilityModeOff(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        try {
            ByteBuffer plainClient = this.allocateBuffer(param.type(), 1024);
            plainClient.limit(plainClient.capacity());
            ByteBuffer encClientToServer = this.allocateBuffer(param.type(), client.getSession().getPacketBufferSize());
            ByteBuffer plainServer = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize());
            this.handshake(param.type(), param.delegate(), client, server);
            SSLEngineResult result = client.wrap(plainClient, encClientToServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)result.bytesConsumed(), (int)plainClient.capacity());
            encClientToServer.flip();
            int remaining = encClientToServer.remaining();
            encClientToServer.limit(4);
            result = server.unwrap(encClientToServer, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)4, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
            remaining -= result.bytesConsumed();
            encClientToServer.limit(5);
            result = server.unwrap(encClientToServer, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)1, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
            encClientToServer.limit(5 + (remaining -= result.bytesConsumed()) - 1 - 5);
            result = server.unwrap(encClientToServer, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)(encClientToServer.limit() - 5), (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
            encClientToServer.limit(remaining -= result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)encClientToServer.remaining());
            result = server.unwrap(encClientToServer, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)0, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
            encClientToServer.position(0);
            result = server.unwrap(encClientToServer, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)remaining, (int)result.bytesConsumed());
            Assertions.assertEquals((int)0, (int)result.bytesProduced());
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWrapWithDifferentSizes(SSLEngineTest.SSLEngineTestParam param, String protocol, String cipher) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(protocol));
        if (!OpenSsl.isCipherSuiteAvailable((String)cipher)) {
            return;
        }
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            clientEngine.setEnabledCipherSuites(new String[]{cipher});
            clientEngine.setEnabledProtocols(new String[]{protocol});
            serverEngine.setEnabledCipherSuites(new String[]{cipher});
            serverEngine.setEnabledProtocols(new String[]{protocol});
            try {
                this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            }
            catch (SSLException e) {
                if (e.getMessage().contains("unsupported protocol") || e.getMessage().contains("no protocols available")) {
                    throw new TestAbortedException(protocol + " not supported with cipher " + cipher, (Throwable)e);
                }
                throw e;
            }
            int srcLen = 64;
            do {
                this.testWrapDstBigEnough(param.type(), clientEngine, srcLen);
            } while ((srcLen += 64) < ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH);
            this.testWrapDstBigEnough(param.type(), clientEngine, ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    private void testWrapDstBigEnough(SSLEngineTest.BufferType type, SSLEngine engine, int srcLen) throws SSLException {
        ByteBuffer src = this.allocateBuffer(type, srcLen);
        ByteBuffer dst = this.allocateBuffer(type, srcLen + this.unwrapEngine(engine).maxWrapOverhead());
        SSLEngineResult result = engine.wrap(src, dst);
        Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
        int consumed = result.bytesConsumed();
        int produced = result.bytesProduced();
        Assertions.assertEquals((int)srcLen, (int)consumed);
        Assertions.assertTrue((produced > consumed ? 1 : 0) != 0);
        dst.flip();
        Assertions.assertEquals((int)produced, (int)dst.remaining());
        Assertions.assertFalse((boolean)src.hasRemaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSNIMatchersDoesNotThrow(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((PlatformDependent.javaVersion() >= 8 ? 1 : 0) != 0);
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine engine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLParameters parameters = new SSLParameters();
            Java8SslTestUtils.setSNIMatcher(parameters, EmptyArrays.EMPTY_BYTES);
            engine.setSSLParameters(parameters);
        }
        finally {
            this.cleanupServerSslEngine(engine);
            ssc.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSNIMatchersWithSNINameWithUnderscore(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((PlatformDependent.javaVersion() >= 8 ? 1 : 0) != 0);
        byte[] name = "rb8hx3pww30y3tvw0mwy.v1_1".getBytes(CharsetUtil.UTF_8);
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine engine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLParameters parameters = new SSLParameters();
            Java8SslTestUtils.setSNIMatcher(parameters, name);
            engine.setSSLParameters(parameters);
            Assertions.assertFalse((boolean)this.unwrapEngine(engine).checkSniHostnameMatch("other".getBytes(CharsetUtil.UTF_8)));
        }
        finally {
            this.cleanupServerSslEngine(engine);
            ssc.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testAlgorithmConstraintsThrows(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        final SSLEngine engine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        final SSLParameters parameters = new SSLParameters();
        parameters.setAlgorithmConstraints(new AlgorithmConstraints(){

            @Override
            public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
                return false;
            }

            @Override
            public boolean permits(Set<CryptoPrimitive> primitives, Key key) {
                return false;
            }

            @Override
            public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
                return false;
            }
        });
        try {
            Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    engine.setSSLParameters(parameters);
                }
            });
        }
        finally {
            this.cleanupServerSslEngine(engine);
            ssc.delete();
        }
    }

    private static void runTasksIfNeeded(SSLEngine engine) {
        if (engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            while (true) {
                Runnable task;
                if ((task = engine.getDelegatedTask()) == null) {
                    Assertions.assertNotEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_TASK), (Object)((Object)engine.getHandshakeStatus()));
                    break;
                }
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testExtractMasterkeyWorksCorrectly(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        if (param.combo() != SSLEngineTest.ProtocolCipherCombo.tlsv12()) {
            return;
        }
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).protocols(param.protocols()).ciphers(param.ciphers()).sslProvider(SslProvider.OPENSSL).build());
        SSLEngine serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(cert.certificate()).protocols(param.protocols()).ciphers(param.ciphers()).sslProvider(SslProvider.OPENSSL).build());
        SSLEngine clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        String enabledCipher = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";
        try {
            Assumptions.assumeTrue((boolean)Arrays.asList(clientEngine.getSupportedCipherSuites()).contains("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"), (String)"The diffie hellman cipher is not supported on your runtime.");
            clientEngine.setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"});
            serverEngine.setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"});
            int appBufferMax = clientEngine.getSession().getApplicationBufferSize();
            int netBufferMax = clientEngine.getSession().getPacketBufferSize();
            ByteBuffer clientIn = ByteBuffer.allocate(appBufferMax + 50);
            ByteBuffer serverIn = ByteBuffer.allocate(appBufferMax + 50);
            ByteBuffer cTOs = ByteBuffer.allocate(netBufferMax);
            ByteBuffer sTOc = ByteBuffer.allocate(netBufferMax);
            ByteBuffer clientOut = ByteBuffer.wrap("Hi Server, I'm Client".getBytes(CharsetUtil.US_ASCII));
            ByteBuffer serverOut = ByteBuffer.wrap("Hello Client, I'm Server".getBytes(CharsetUtil.US_ASCII));
            boolean asserted = false;
            for (int i = 0; i < 1000; ++i) {
                clientEngine.wrap(clientOut, cTOs);
                serverEngine.wrap(serverOut, sTOc);
                cTOs.flip();
                sTOc.flip();
                OpenSslEngineTest.runTasksIfNeeded(clientEngine);
                OpenSslEngineTest.runTasksIfNeeded(serverEngine);
                clientEngine.unwrap(sTOc, clientIn);
                serverEngine.unwrap(cTOs, serverIn);
                OpenSslEngineTest.runTasksIfNeeded(clientEngine);
                OpenSslEngineTest.runTasksIfNeeded(serverEngine);
                if (clientOut.limit() == serverIn.position() && serverOut.limit() == clientIn.position()) {
                    byte[] serverRandom = SSL.getServerRandom((long)this.unwrapEngine(serverEngine).sslPointer());
                    byte[] clientRandom = SSL.getClientRandom((long)this.unwrapEngine(clientEngine).sslPointer());
                    byte[] serverMasterKey = SSL.getMasterKey((long)this.unwrapEngine(serverEngine).sslPointer());
                    byte[] clientMasterKey = SSL.getMasterKey((long)this.unwrapEngine(clientEngine).sslPointer());
                    asserted = true;
                    Assertions.assertArrayEquals((byte[])serverMasterKey, (byte[])clientMasterKey);
                    cTOs.flip();
                    sTOc.flip();
                    int keySize = 16;
                    int macSize = 32;
                    int keyBlockSize = 2 * keySize + 2 * macSize;
                    byte[] seed = new byte[serverRandom.length + clientRandom.length];
                    System.arraycopy(serverRandom, 0, seed, 0, serverRandom.length);
                    System.arraycopy(clientRandom, 0, seed, serverRandom.length, clientRandom.length);
                    byte[] keyBlock = PseudoRandomFunction.hash((byte[])serverMasterKey, (byte[])"key expansion".getBytes(CharsetUtil.US_ASCII), (byte[])seed, (int)keyBlockSize, (String)"HmacSha256");
                    int offset = 0;
                    byte[] clientWriteMac = Arrays.copyOfRange(keyBlock, offset, offset + macSize);
                    byte[] serverWriteMac = Arrays.copyOfRange(keyBlock, offset += macSize, offset + macSize);
                    byte[] clientWriteKey = Arrays.copyOfRange(keyBlock, offset += macSize, offset + keySize);
                    byte[] serverWriteKey = Arrays.copyOfRange(keyBlock, offset += keySize, offset + keySize);
                    offset += keySize;
                    cTOs.position(cTOs.position() + 5);
                    byte[] ciphertext = new byte[cTOs.remaining()];
                    cTOs.get(ciphertext);
                    byte[] clientWriteIV = Arrays.copyOfRange(ciphertext, 0, 16);
                    ciphertext = Arrays.copyOfRange(ciphertext, 16, ciphertext.length);
                    SecretKeySpec secretKey = new SecretKeySpec(clientWriteKey, "AES");
                    IvParameterSpec ivForCBC = new IvParameterSpec(clientWriteIV);
                    Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    cipher.init(2, (Key)secretKey, ivForCBC);
                    byte[] plaintext = cipher.doFinal(ciphertext);
                    Assertions.assertTrue((boolean)new String(plaintext).startsWith("Hi Server, I'm Client"));
                    break;
                }
                cTOs.compact();
                sTOc.compact();
            }
            Assertions.assertTrue((boolean)asserted, (String)"The assertions were never executed.");
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            cert.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testNoKeyFound(final SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        final SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((KeyManager)new X509ExtendedKeyManager(){

            @Override
            public String[] getClientAliases(String keyType, Principal[] issuers) {
                return new String[0];
            }

            @Override
            public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
                return null;
            }

            @Override
            public String[] getServerAliases(String keyType, Principal[] issuers) {
                return new String[0];
            }

            @Override
            public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String alias) {
                return new X509Certificate[0];
            }

            @Override
            public PrivateKey getPrivateKey(String alias) {
                return null;
            }
        }).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        final SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            Assertions.assertThrows(SSLException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    OpenSslEngineTest.this.handshake(param.type(), param.delegate(), client, server);
                }
            });
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionLocalWhenNonMutualWithKeyManager(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionLocalWhenNonMutualWithKeyManager(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionLocalWhenNonMutualWithoutKeyManager(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.supportsKeyManagerFactory());
        super.testSessionLocalWhenNonMutualWithoutKeyManager(param);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testDefaultTLS1NotAcceptedByDefaultServer(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.testDefaultTLS1NotAcceptedByDefault(param, null, "TLSv1");
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testDefaultTLS11NotAcceptedByDefaultServer(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.testDefaultTLS1NotAcceptedByDefault(param, null, "TLSv1.1");
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testDefaultTLS1NotAcceptedByDefaultClient(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.testDefaultTLS1NotAcceptedByDefault(param, "TLSv1", null);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testDefaultTLS11NotAcceptedByDefaultClient(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.testDefaultTLS1NotAcceptedByDefault(param, "TLSv1.1", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDefaultTLS1NotAcceptedByDefault(final SSLEngineTest.SSLEngineTestParam param, String clientProtocol, String serverProtocol) throws Exception {
        SslContextBuilder clientCtxBuilder = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider());
        if (clientProtocol != null) {
            clientCtxBuilder.protocols(new String[]{clientProtocol});
        }
        this.clientSslCtx = this.wrapContext(param, clientCtxBuilder.build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        SslContextBuilder serverCtxBuilder = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider());
        if (serverProtocol != null) {
            serverCtxBuilder.protocols(new String[]{serverProtocol});
        }
        this.serverSslCtx = this.wrapContext(param, serverCtxBuilder.build());
        final SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        final SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            Assertions.assertThrows(SSLHandshakeException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    OpenSslEngineTest.this.handshake(param.type(), param.delegate(), client, server);
                }
            });
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            ssc.delete();
        }
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.OPENSSL;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.OPENSSL;
    }

    private static ApplicationProtocolConfig acceptingNegotiator(ApplicationProtocolConfig.Protocol protocol, String ... supportedProtocols) {
        return new ApplicationProtocolConfig(protocol, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocols);
    }

    @Override
    protected SSLEngine wrapEngine(SSLEngine engine) {
        if (PlatformDependent.javaVersion() >= 8) {
            return Java8SslTestUtils.wrapSSLEngineForTesting(engine);
        }
        return engine;
    }

    ReferenceCountedOpenSslEngine unwrapEngine(SSLEngine engine) {
        if (engine instanceof JdkSslEngine) {
            return (ReferenceCountedOpenSslEngine)((JdkSslEngine)engine).getWrappedEngine();
        }
        return (ReferenceCountedOpenSslEngine)engine;
    }

    @Override
    protected SslContext wrapContext(SSLEngineTest.SSLEngineTestParam param, SslContext context) {
        if (context instanceof OpenSslContext) {
            if (param instanceof OpenSslEngineTestParam) {
                ((OpenSslContext)context).setUseTasks(((OpenSslEngineTestParam)param).useTasks);
            }
            ((OpenSslContext)context).sessionContext().setSessionCacheEnabled(true);
        }
        return context;
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCache(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCache(param);
        OpenSslEngineTest.assertSessionContext(this.clientSslCtx);
        OpenSslEngineTest.assertSessionContext(this.serverSslCtx);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCacheTimeout(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCacheTimeout(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCacheSize(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCacheSize(param);
    }

    private static void assertSessionContext(SslContext context) {
        if (context == null) {
            return;
        }
        OpenSslSessionContext serverSessionCtx = (OpenSslSessionContext)context.sessionContext();
        Assertions.assertTrue((boolean)serverSessionCtx.isSessionCacheEnabled());
        if (serverSessionCtx.getIds().hasMoreElements()) {
            serverSessionCtx.setSessionCacheEnabled(false);
            Assertions.assertFalse((boolean)serverSessionCtx.getIds().hasMoreElements());
            Assertions.assertFalse((boolean)serverSessionCtx.isSessionCacheEnabled());
        }
    }

    @Override
    protected void assertSessionReusedForEngine(SSLEngine clientEngine, SSLEngine serverEngine, boolean reuse) {
        Assertions.assertEquals((Object)reuse, (Object)this.unwrapEngine(clientEngine).isSessionReused());
        Assertions.assertEquals((Object)reuse, (Object)this.unwrapEngine(serverEngine).isSessionReused());
    }

    @Override
    protected boolean isSessionMaybeReused(SSLEngine engine) {
        return this.unwrapEngine(engine).isSessionReused();
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testRSASSAPSS(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testRSASSAPSS(param);
    }

    @Test
    public void testExtraDataInLastSrcBufferForClientUnwrapNonjdkCompatabilityMode() throws Exception {
        SSLEngineTest.SSLEngineTestParam param = new SSLEngineTest.SSLEngineTestParam(SSLEngineTest.BufferType.Direct, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false);
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).clientAuth(ClientAuth.NONE).build());
        this.testExtraDataInLastSrcBufferForClientUnwrap(param, this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine()), this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMaxCertificateList(final SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)SslProvider.isOptionSupported((SslProvider)this.sslClientProvider(), (SslContextOption)OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES));
        Assumptions.assumeTrue((boolean)SslProvider.isOptionSupported((SslProvider)this.sslServerProvider(), (SslContextOption)OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES));
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager(ssc.certificate(), ssc.privateKey()).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).option((SslContextOption)OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES, (Object)10).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).option((SslContextOption)OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES, (Object)10).clientAuth(ClientAuth.REQUIRE).build());
        final SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        final SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            Assertions.assertThrows(SSLHandshakeException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    OpenSslEngineTest.this.handshake(param.type(), param.delegate(), client, server);
                }
            });
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            ssc.delete();
        }
    }
}

