/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedKeyManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslEngine;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslKeyMaterial;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;

public class OpenSslKeyMaterialManagerTest {
    @Test
    public void testChooseClientAliasReturnsNull() throws SSLException {
        OpenSsl.ensureAvailability();
        X509ExtendedKeyManager keyManager = new X509ExtendedKeyManager(){

            @Override
            public String[] getClientAliases(String s, Principal[] principals) {
                return EmptyArrays.EMPTY_STRINGS;
            }

            @Override
            public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                return null;
            }

            @Override
            public String[] getServerAliases(String s, Principal[] principals) {
                return EmptyArrays.EMPTY_STRINGS;
            }

            @Override
            public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String s) {
                return EmptyArrays.EMPTY_X509_CERTIFICATES;
            }

            @Override
            public PrivateKey getPrivateKey(String s) {
                return null;
            }
        };
        OpenSslKeyMaterialManager manager = new OpenSslKeyMaterialManager(new OpenSslKeyMaterialProvider(keyManager, null){

            OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias) throws Exception {
                Assertions.fail((String)"Should not be called when alias is null");
                return null;
            }
        });
        SslContext context = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).build();
        OpenSslEngine engine = (OpenSslEngine)context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        manager.setKeyMaterialClientSide((ReferenceCountedOpenSslEngine)engine, EmptyArrays.EMPTY_STRINGS, null);
    }
}

