/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufUtil;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.ServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ClientAuth;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.FutureListener;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.PromiseNotifier;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ResourcesUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ThreadLocalRandom;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLogger;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class ParameterizedSslHandlerTest {
    private static final String PARAMETERIZED_NAME = "{index}: clientProvider={0}, {index}: serverProvider={1}";

    static Collection<Object[]> data() {
        ArrayList<SslProvider> providers = new ArrayList<SslProvider>(3);
        if (OpenSsl.isAvailable()) {
            providers.add(SslProvider.OPENSSL);
            providers.add(SslProvider.OPENSSL_REFCNT);
        }
        providers.add(SslProvider.JDK);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslProvider cp : providers) {
            for (SslProvider sp : providers) {
                params.add(new Object[]{cp, sp});
            }
        }
        return params;
    }

    @ParameterizedTest(name="{index}: clientProvider={0}, {index}: serverProvider={1}")
    @MethodSource(value={"data"})
    @Timeout(value=48000L, unit=TimeUnit.MILLISECONDS)
    public void testCompositeBufSizeEstimationGuaranteesSynchronousWrite(SslProvider clientProvider, SslProvider serverProvider) throws CertificateException, SSLException, ExecutionException, InterruptedException {
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(serverProvider, clientProvider, true, true, true);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(serverProvider, clientProvider, true, true, false);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(serverProvider, clientProvider, true, false, true);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(serverProvider, clientProvider, true, false, false);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(serverProvider, clientProvider, false, true, true);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(serverProvider, clientProvider, false, true, false);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(serverProvider, clientProvider, false, false, true);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(serverProvider, clientProvider, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compositeBufSizeEstimationGuaranteesSynchronousWrite(SslProvider serverProvider, SslProvider clientProvider, final boolean serverDisableWrapSize, final boolean letHandlerCreateServerEngine, final boolean letHandlerCreateClientEngine) throws CertificateException, SSLException, ExecutionException, InterruptedException {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(serverProvider).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(clientProvider).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        try {
            final Promise donePromise = group.next().newPromise();
            int numComponents = 150;
            int desiredBytes = 16384;
            int singleComponentSize = 109;
            int expectedBytes = 16350;
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SslHandler handler;
                    SslHandler sslHandler = handler = letHandlerCreateServerEngine ? sslServerCtx.newHandler(ch.alloc()) : new SslHandler(sslServerCtx.newEngine(ch.alloc()));
                    if (serverDisableWrapSize) {
                        handler.setWrapDataSize(-1);
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private boolean sentData;
                        private Throwable writeCause;

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                SslHandshakeCompletionEvent sslEvt = (SslHandshakeCompletionEvent)evt;
                                if (sslEvt.isSuccess()) {
                                    CompositeByteBuf content = ctx.alloc().compositeDirectBuffer(150);
                                    for (int i = 0; i < 150; ++i) {
                                        ByteBuf buf = ctx.alloc().directBuffer(109);
                                        buf.writerIndex(buf.writerIndex() + 109);
                                        content.addComponent(true, buf);
                                    }
                                    ctx.writeAndFlush((Object)content).addListener((GenericFutureListener)new ChannelFutureListener(){

                                        public void operationComplete(ChannelFuture future) throws Exception {
                                            writeCause = future.cause();
                                            if (writeCause == null) {
                                                sentData = true;
                                            }
                                        }
                                    });
                                } else {
                                    donePromise.tryFailure(sslEvt.cause());
                                }
                            }
                            ctx.fireUserEventTriggered(evt);
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            donePromise.tryFailure((Throwable)new IllegalStateException("server exception sentData: " + this.sentData + " writeCause: " + this.writeCause, cause));
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            donePromise.tryFailure((Throwable)new IllegalStateException("server closed sentData: " + this.sentData + " writeCause: " + this.writeCause));
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    if (letHandlerCreateClientEngine) {
                        ch.pipeline().addLast(new ChannelHandler[]{sslClientCtx.newHandler(ch.alloc())});
                    } else {
                        ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(sslClientCtx.newEngine(ch.alloc()))});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private int bytesSeen;

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            if (msg instanceof ByteBuf) {
                                this.bytesSeen += ((ByteBuf)msg).readableBytes();
                                if (this.bytesSeen == 16350) {
                                    donePromise.trySuccess(null);
                                }
                            }
                            ReferenceCountUtil.release((Object)msg);
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            SslHandshakeCompletionEvent sslEvt;
                            if (evt instanceof SslHandshakeCompletionEvent && !(sslEvt = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                                donePromise.tryFailure(sslEvt.cause());
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            donePromise.tryFailure((Throwable)new IllegalStateException("client exception. bytesSeen: " + this.bytesSeen, cause));
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            donePromise.tryFailure((Throwable)new IllegalStateException("client closed. bytesSeen: " + this.bytesSeen));
                        }
                    }});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            donePromise.get();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
            ssc.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: clientProvider={0}, {index}: serverProvider={1}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testAlertProducedAndSend(SslProvider clientProvider, SslProvider serverProvider) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(serverProvider).trustManager((TrustManagerFactory)new SimpleTrustManagerFactory(){

            protected void engineInit(KeyStore keyStore) {
            }

            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            }

            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        throw new CertificateException();
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return EmptyArrays.EMPTY_X509_CERTIFICATES;
                    }
                }};
            }
        }).clientAuth(ClientAuth.REQUIRE).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager(ResourcesUtil.getFile(this.getClass(), (String)"test.crt"), ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem")).sslProvider(clientProvider).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        try {
            final Promise promise = group.next().newPromise();
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslClientCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            if (cause.getCause() instanceof SSLException) {
                                promise.trySuccess(null);
                            }
                        }
                    }});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            promise.syncUninterruptibly();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @ParameterizedTest(name="{index}: clientProvider={0}, {index}: serverProvider={1}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testCloseNotify(SslProvider clientProvider, SslProvider serverProvider) throws Exception {
        this.testCloseNotify(clientProvider, serverProvider, 5000L, false);
    }

    @ParameterizedTest(name="{index}: clientProvider={0}, {index}: serverProvider={1}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testCloseNotifyReceivedTimeout(SslProvider clientProvider, SslProvider serverProvider) throws Exception {
        this.testCloseNotify(clientProvider, serverProvider, 100L, true);
    }

    @ParameterizedTest(name="{index}: clientProvider={0}, {index}: serverProvider={1}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testCloseNotifyNotWaitForResponse(SslProvider clientProvider, SslProvider serverProvider) throws Exception {
        this.testCloseNotify(clientProvider, serverProvider, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseNotify(SslProvider clientProvider, SslProvider serverProvider, final long closeNotifyReadTimeout, final boolean timeout) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(serverProvider).protocols(new String[]{"TLSv1.2"}).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(clientProvider).protocols(new String[]{"TLSv1.2"}).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        try {
            final Promise clientPromise = group.next().newPromise();
            final Promise serverPromise = group.next().newPromise();
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SslHandler handler = sslServerCtx.newHandler(ch.alloc());
                    handler.setCloseNotifyReadTimeoutMillis(closeNotifyReadTimeout);
                    PromiseNotifier.cascade((Future)handler.sslCloseFuture(), (Promise)serverPromise);
                    handler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                        public void operationComplete(Future<Channel> future) {
                            if (!future.isSuccess()) {
                                serverPromise.tryFailure(future.cause());
                            }
                        }
                    });
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    final AtomicBoolean closeSent = new AtomicBoolean();
                    if (timeout) {
                        ch.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                if (closeSent.get()) {
                                    ReferenceCountUtil.release((Object)msg);
                                } else {
                                    super.channelRead(ctx, msg);
                                }
                            }
                        }});
                    }
                    SslHandler handler = sslClientCtx.newHandler(ch.alloc());
                    handler.setCloseNotifyReadTimeoutMillis(closeNotifyReadTimeout);
                    PromiseNotifier.cascade((Future)handler.sslCloseFuture(), (Promise)clientPromise);
                    handler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                        public void operationComplete(Future<Channel> future) {
                            if (future.isSuccess()) {
                                closeSent.compareAndSet(false, true);
                                ((Channel)future.getNow()).close();
                            } else {
                                clientPromise.tryFailure(future.cause());
                            }
                        }
                    });
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            serverPromise.awaitUninterruptibly();
            clientPromise.awaitUninterruptibly();
            Assertions.assertTrue((boolean)serverPromise.isSuccess());
            if (closeNotifyReadTimeout > 0L && !timeout) {
                Assertions.assertTrue((boolean)clientPromise.isSuccess());
            } else {
                Assertions.assertFalse((boolean)clientPromise.isSuccess());
            }
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: clientProvider={0}, {index}: serverProvider={1}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void reentryOnHandshakeCompleteNioChannel(SslProvider clientProvider, SslProvider serverProvider) throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Class<NioServerSocketChannel> serverClass = NioServerSocketChannel.class;
            Class<NioSocketChannel> clientClass = NioSocketChannel.class;
            InetSocketAddress bindAddress = new InetSocketAddress(0);
            this.reentryOnHandshakeComplete(clientProvider, serverProvider, (EventLoopGroup)group, bindAddress, serverClass, clientClass, false, false);
            this.reentryOnHandshakeComplete(clientProvider, serverProvider, (EventLoopGroup)group, bindAddress, serverClass, clientClass, false, true);
            this.reentryOnHandshakeComplete(clientProvider, serverProvider, (EventLoopGroup)group, bindAddress, serverClass, clientClass, true, false);
            this.reentryOnHandshakeComplete(clientProvider, serverProvider, (EventLoopGroup)group, bindAddress, serverClass, clientClass, true, true);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: clientProvider={0}, {index}: serverProvider={1}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void reentryOnHandshakeCompleteLocalChannel(SslProvider clientProvider, SslProvider serverProvider) throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        try {
            Class<LocalServerChannel> serverClass = LocalServerChannel.class;
            Class<LocalChannel> clientClass = LocalChannel.class;
            LocalAddress bindAddress = new LocalAddress(String.valueOf(ThreadLocalRandom.current().nextLong()));
            this.reentryOnHandshakeComplete(clientProvider, serverProvider, (EventLoopGroup)group, (SocketAddress)bindAddress, serverClass, clientClass, false, false);
            this.reentryOnHandshakeComplete(clientProvider, serverProvider, (EventLoopGroup)group, (SocketAddress)bindAddress, serverClass, clientClass, false, true);
            this.reentryOnHandshakeComplete(clientProvider, serverProvider, (EventLoopGroup)group, (SocketAddress)bindAddress, serverClass, clientClass, true, false);
            this.reentryOnHandshakeComplete(clientProvider, serverProvider, (EventLoopGroup)group, (SocketAddress)bindAddress, serverClass, clientClass, true, true);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reentryOnHandshakeComplete(SslProvider clientProvider, SslProvider serverProvider, EventLoopGroup group, SocketAddress bindAddress, Class<? extends ServerChannel> serverClass, Class<? extends Channel> clientClass, boolean serverAutoRead, boolean clientAutoRead) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(serverProvider).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(clientProvider).build();
        Channel sc = null;
        Channel cc = null;
        try {
            String expectedContent = "HelloWorld";
            final CountDownLatch serverLatch = new CountDownLatch(1);
            final CountDownLatch clientLatch = new CountDownLatch(1);
            final StringBuilder serverQueue = new StringBuilder("HelloWorld".length());
            final StringBuilder clientQueue = new StringBuilder("HelloWorld".length());
            sc = ((ServerBootstrap)new ServerBootstrap().group(group).channel(serverClass)).childOption(ChannelOption.AUTO_READ, (Object)serverAutoRead).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{ParameterizedSslHandlerTest.disableHandshakeTimeout(sslServerCtx.newHandler(ch.alloc()))});
                    ch.pipeline().addLast(new ChannelHandler[]{new ReentryWriteSslHandshakeHandler("HelloWorld", serverQueue, serverLatch)});
                }
            }).bind(bindAddress).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(clientClass)).option(ChannelOption.AUTO_READ, (Object)clientAutoRead)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{ParameterizedSslHandlerTest.disableHandshakeTimeout(sslClientCtx.newHandler(ch.alloc()))});
                    ch.pipeline().addLast(new ChannelHandler[]{new ReentryWriteSslHandshakeHandler("HelloWorld", clientQueue, clientLatch)});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            serverLatch.await();
            Assertions.assertEquals((Object)"HelloWorld", (Object)serverQueue.toString());
            clientLatch.await();
            Assertions.assertEquals((Object)"HelloWorld", (Object)clientQueue.toString());
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    private static SslHandler disableHandshakeTimeout(SslHandler handler) {
        handler.setHandshakeTimeoutMillis(0L);
        return handler;
    }

    private static final class ReentryWriteSslHandshakeHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReentryWriteSslHandshakeHandler.class);
        private final String toWrite;
        private final StringBuilder readQueue;
        private final CountDownLatch doneLatch;

        ReentryWriteSslHandshakeHandler(String toWrite, StringBuilder readQueue, CountDownLatch doneLatch) {
            this.toWrite = toWrite;
            this.readQueue = readQueue;
            this.doneLatch = doneLatch;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.writeAndFlush((Object)ByteBufUtil.writeAscii((ByteBufAllocator)ctx.alloc(), (CharSequence)this.toWrite.substring(0, this.toWrite.length() / 2)));
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
            this.readQueue.append(msg.toString(CharsetUtil.US_ASCII));
            if (this.readQueue.length() >= this.toWrite.length()) {
                this.doneLatch.countDown();
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent sslEvt = (SslHandshakeCompletionEvent)evt;
                if (sslEvt.isSuccess()) {
                    ctx.writeAndFlush((Object)ByteBufUtil.writeAscii((ByteBufAllocator)ctx.alloc(), (CharSequence)this.toWrite.substring(this.toWrite.length() / 2)));
                } else {
                    this.appendError(sslEvt.cause());
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.appendError(cause);
            ctx.fireExceptionCaught(cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendError(Throwable cause) {
            LOGGER.error((Throwable)new Exception("Caught possible write failure in ParameterizedSslHandlerTest.", cause));
            this.readQueue.append("failed to write '").append(this.toWrite).append("': ");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                cause.printStackTrace(new PrintStream(out));
                this.readQueue.append(out.toString(CharsetUtil.US_ASCII.name()));
            }
            catch (UnsupportedEncodingException ignore) {
                this.readQueue.append(cause);
            }
            finally {
                this.doneLatch.countDown();
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

