/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.PemEncoded;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.PemPrivateKey;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.PemX509Certificate;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;

public class PemEncodedTest {
    @Test
    public void testPemEncodedOpenSsl() throws Exception {
        PemEncodedTest.testPemEncoded(SslProvider.OPENSSL);
    }

    @Test
    public void testPemEncodedOpenSslRef() throws Exception {
        PemEncodedTest.testPemEncoded(SslProvider.OPENSSL_REFCNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testPemEncoded(SslProvider provider) throws Exception {
        PemX509Certificate pemCert;
        PemPrivateKey pemKey;
        OpenSsl.ensureAvailability();
        Assumptions.assumeFalse((boolean)OpenSsl.useKeyManagerFactory());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        try {
            pemKey = PemPrivateKey.valueOf((byte[])PemEncodedTest.toByteArray(ssc.privateKey()));
            pemCert = PemX509Certificate.valueOf((byte[])PemEncodedTest.toByteArray(ssc.certificate()));
        }
        finally {
            ssc.delete();
        }
        SslContext context = SslContextBuilder.forServer((PrivateKey)pemKey, (X509Certificate[])new X509Certificate[]{pemCert}).sslProvider(provider).build();
        Assertions.assertEquals((int)1, (int)pemKey.refCnt());
        Assertions.assertEquals((int)1, (int)pemCert.refCnt());
        try {
            Assertions.assertTrue((boolean)(context instanceof ReferenceCountedOpenSslContext));
        }
        finally {
            ReferenceCountUtil.release((Object)context);
            PemEncodedTest.assertRelease((PemEncoded)pemKey);
            PemEncodedTest.assertRelease((PemEncoded)pemCert);
        }
    }

    @Test
    public void testEncodedReturnsNull() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                PemPrivateKey.toPEM((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)true, (PrivateKey)new PrivateKey(){

                    @Override
                    public String getAlgorithm() {
                        return null;
                    }

                    @Override
                    public String getFormat() {
                        return null;
                    }

                    @Override
                    public byte[] getEncoded() {
                        return null;
                    }
                });
            }
        });
    }

    private static void assertRelease(PemEncoded encoded) {
        Assertions.assertTrue((boolean)encoded.release());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(File file) throws Exception {
        FileInputStream in = new FileInputStream(file);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) != -1) {
                    baos.write(buf, 0, len);
                }
            }
            finally {
                baos.close();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }
}

