/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.FutureListener;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public abstract class RenegotiateTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testRenegotiateServer() throws Throwable {
        final AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        final CountDownLatch latch = new CountDownLatch(2);
        SelfSignedCertificate cert = new SelfSignedCertificate();
        LocalEventLoopGroup group = new LocalEventLoopGroup();
        try {
            final SslContext context = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(this.serverSslProvider()).protocols(new String[]{"TLSv1.2"}).build();
            ServerBootstrap sb = new ServerBootstrap();
            ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SslHandler handler = context.newHandler(ch.alloc());
                    handler.setHandshakeTimeoutMillis(0L);
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private boolean renegotiate;

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            ReferenceCountUtil.release((Object)msg);
                        }

                        public void userEventTriggered(final ChannelHandlerContext ctx, Object evt) throws Exception {
                            if (!this.renegotiate && evt instanceof SslHandshakeCompletionEvent) {
                                SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                                if (event.isSuccess()) {
                                    SslHandler handler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                                    this.renegotiate = true;
                                    handler.renegotiate().addListener((GenericFutureListener)new FutureListener<Channel>(){

                                        public void operationComplete(Future<Channel> future) throws Exception {
                                            if (!future.isSuccess()) {
                                                error.compareAndSet(null, future.cause());
                                                ctx.close();
                                            }
                                            latch.countDown();
                                        }
                                    });
                                } else {
                                    error.compareAndSet(null, event.cause());
                                    latch.countDown();
                                    ctx.close();
                                }
                            }
                        }
                    }});
                }
            });
            Channel channel = sb.bind((SocketAddress)new LocalAddress("RenegotiateTest")).syncUninterruptibly().channel();
            final SslContext clientContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).protocols(new String[]{"TLSv1.2"}).build();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SslHandler handler = clientContext.newHandler(ch.alloc());
                    handler.setHandshakeTimeoutMillis(0L);
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                                if (!event.isSuccess()) {
                                    error.compareAndSet(null, event.cause());
                                    ctx.close();
                                }
                                latch.countDown();
                            }
                        }
                    }});
                }
            });
            Channel clientChannel = bootstrap.connect(channel.localAddress()).syncUninterruptibly().channel();
            latch.await();
            clientChannel.close().syncUninterruptibly();
            channel.close().syncUninterruptibly();
            this.verifyResult(error);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    protected abstract SslProvider serverSslProvider();

    protected void verifyResult(AtomicReference<Throwable> error) throws Throwable {
        Throwable cause = error.get();
        if (cause != null) {
            throw cause;
        }
    }
}

