/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ThrowableUtil;

final class SniClientJava8TestUtil {
    private SniClientJava8TestUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testSniClient(SslProvider sslClientProvider, SslProvider sslServerProvider, final boolean match) throws Exception {
        Channel sc;
        SslContext sslClientContext;
        SslContext sslServerContext;
        DefaultEventLoopGroup group;
        SelfSignedCertificate cert;
        block5: {
            String sniHost = "sni.netty.io";
            cert = new SelfSignedCertificate();
            LocalAddress address = new LocalAddress("test");
            group = new DefaultEventLoopGroup(1);
            sslServerContext = null;
            sslClientContext = null;
            sc = null;
            Channel cc = null;
            try {
                sslServerContext = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(sslServerProvider).build();
                final Promise promise = group.next().newPromise();
                ServerBootstrap sb = new ServerBootstrap();
                final SslContext finalContext = sslServerContext;
                sc = ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        SslHandler handler = finalContext.newHandler(ch.alloc());
                        SSLParameters parameters = handler.engine().getSSLParameters();
                        SNIMatcher matcher = new SNIMatcher(0){

                            @Override
                            public boolean matches(SNIServerName sniServerName) {
                                return match;
                            }
                        };
                        parameters.setSNIMatchers(Collections.singleton(matcher));
                        handler.engine().setSSLParameters(parameters);
                        ch.pipeline().addFirst(new ChannelHandler[]{handler});
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                                if (evt instanceof SslHandshakeCompletionEvent) {
                                    SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                                    if (match) {
                                        if (event.isSuccess()) {
                                            promise.setSuccess(null);
                                        } else {
                                            promise.setFailure(event.cause());
                                        }
                                    } else if (event.isSuccess()) {
                                        promise.setFailure((Throwable)((Object)new AssertionError((Object)"expected SSLException")));
                                    } else {
                                        Throwable cause = event.cause();
                                        if (cause instanceof SSLException) {
                                            promise.setSuccess(null);
                                        } else {
                                            promise.setFailure((Throwable)((Object)new AssertionError((Object)("cause not of type SSLException: " + ThrowableUtil.stackTraceToString((Throwable)cause)))));
                                        }
                                    }
                                }
                            }
                        }});
                    }
                }).bind((SocketAddress)address).syncUninterruptibly().channel();
                sslClientContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(sslClientProvider).build();
                SslHandler sslHandler = new SslHandler(sslClientContext.newEngine(ByteBufAllocator.DEFAULT, "sni.netty.io", -1));
                Bootstrap cb = new Bootstrap();
                cc = ((Bootstrap)((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)sslHandler)).connect((SocketAddress)address).syncUninterruptibly().channel();
                promise.syncUninterruptibly();
                sslHandler.handshakeFuture().syncUninterruptibly();
                if (cc == null) break block5;
            }
            catch (Throwable throwable) {
                if (cc != null) {
                    cc.close().syncUninterruptibly();
                }
                if (sc != null) {
                    sc.close().syncUninterruptibly();
                }
                ReferenceCountUtil.release(sslServerContext);
                ReferenceCountUtil.release(sslClientContext);
                cert.delete();
                group.shutdownGracefully();
                throw throwable;
            }
            cc.close().syncUninterruptibly();
        }
        if (sc != null) {
            sc.close().syncUninterruptibly();
        }
        ReferenceCountUtil.release((Object)sslServerContext);
        ReferenceCountUtil.release((Object)sslClientContext);
        cert.delete();
        group.shutdownGracefully();
    }

    static void assertSSLSession(boolean clientSide, SSLSession session, String name) {
        SniClientJava8TestUtil.assertSSLSession(clientSide, session, new SNIHostName(name));
    }

    private static void assertSSLSession(boolean clientSide, SSLSession session, SNIServerName name) {
        Assertions.assertNotNull((Object)session);
        if (session instanceof ExtendedSSLSession) {
            ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)session;
            List<SNIServerName> names = extendedSSLSession.getRequestedServerNames();
            Assertions.assertEquals((int)1, (int)names.size());
            Assertions.assertEquals((Object)name, (Object)names.get(0));
            Assertions.assertTrue((extendedSSLSession.getLocalSupportedSignatureAlgorithms().length > 0 ? 1 : 0) != 0);
            if (clientSide) {
                Assertions.assertEquals((int)0, (int)extendedSSLSession.getPeerSupportedSignatureAlgorithms().length);
            } else {
                Assertions.assertTrue((extendedSSLSession.getPeerSupportedSignatureAlgorithms().length >= 0 ? 1 : 0) != 0);
            }
        }
    }

    static TrustManagerFactory newSniX509TrustmanagerFactory(String name) {
        return new SniX509TrustmanagerFactory(new SNIHostName(name));
    }

    static KeyManagerFactory newSniX509KeyManagerFactory(SelfSignedCertificate cert, String hostname) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException, CertificateException {
        return new SniX509KeyManagerFactory(new SNIHostName(hostname), SslContext.buildKeyManagerFactory((X509Certificate[])new X509Certificate[]{cert.cert()}, null, (PrivateKey)cert.key(), null, null, null));
    }

    private static final class SniX509KeyManagerFactory
    extends KeyManagerFactory {
        SniX509KeyManagerFactory(final SNIServerName name, final KeyManagerFactory factory) {
            super(new KeyManagerFactorySpi(){

                @Override
                protected void engineInit(KeyStore keyStore, char[] chars) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
                    factory.init(keyStore, chars);
                }

                @Override
                protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
                    factory.init(managerFactoryParameters);
                }

                @Override
                protected KeyManager[] engineGetKeyManagers() {
                    ArrayList<KeyManager> managers = new ArrayList<KeyManager>();
                    for (final KeyManager km : factory.getKeyManagers()) {
                        if (km instanceof X509ExtendedKeyManager) {
                            managers.add(new X509ExtendedKeyManager(){

                                @Override
                                public String[] getClientAliases(String s, Principal[] principals) {
                                    return ((X509ExtendedKeyManager)km).getClientAliases(s, principals);
                                }

                                @Override
                                public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                                    return ((X509ExtendedKeyManager)km).chooseClientAlias(strings, principals, socket);
                                }

                                @Override
                                public String[] getServerAliases(String s, Principal[] principals) {
                                    return ((X509ExtendedKeyManager)km).getServerAliases(s, principals);
                                }

                                @Override
                                public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                                    return ((X509ExtendedKeyManager)km).chooseServerAlias(s, principals, socket);
                                }

                                @Override
                                public X509Certificate[] getCertificateChain(String s) {
                                    return ((X509ExtendedKeyManager)km).getCertificateChain(s);
                                }

                                @Override
                                public PrivateKey getPrivateKey(String s) {
                                    return ((X509ExtendedKeyManager)km).getPrivateKey(s);
                                }

                                @Override
                                public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
                                    return ((X509ExtendedKeyManager)km).chooseEngineClientAlias(strings, principals, sslEngine);
                                }

                                @Override
                                public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
                                    SSLSession session = sslEngine.getHandshakeSession();
                                    SniClientJava8TestUtil.assertSSLSession(sslEngine.getUseClientMode(), session, name);
                                    return ((X509ExtendedKeyManager)km).chooseEngineServerAlias(s, principals, sslEngine);
                                }
                            });
                            continue;
                        }
                        managers.add(km);
                    }
                    return managers.toArray(new KeyManager[0]);
                }
            }, factory.getProvider(), factory.getAlgorithm());
        }
    }

    private static final class SniX509TrustmanagerFactory
    extends SimpleTrustManagerFactory {
        private final SNIServerName name;

        SniX509TrustmanagerFactory(SNIServerName name) {
            this.name = name;
        }

        protected void engineInit(KeyStore keyStore) throws Exception {
        }

        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
        }

        protected TrustManager[] engineGetTrustManagers() {
            return new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                    Assertions.fail();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                    Assertions.fail();
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                    Assertions.fail();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                    SniClientJava8TestUtil.assertSSLSession(sslEngine.getUseClientMode(), sslEngine.getHandshakeSession(), SniX509TrustmanagerFactory.this.name);
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    Assertions.fail();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    Assertions.fail();
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return EmptyArrays.EMPTY_X509_CERTIFICATES;
                }
            }};
        }
    }
}

