/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.File;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SniClientJava8TestUtil;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SniHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.util.Mapping;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class SniClientTest {
    private static final String PARAMETERIZED_NAME = "{index}: serverSslProvider = {0}, clientSslProvider = {1}";

    static Collection<Object[]> parameters() {
        ArrayList<SslProvider> providers = new ArrayList<SslProvider>(Arrays.asList(SslProvider.values()));
        if (!OpenSsl.isAvailable()) {
            providers.remove(SslProvider.OPENSSL);
            providers.remove(SslProvider.OPENSSL_REFCNT);
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslProvider sp : providers) {
            for (SslProvider cp : providers) {
                params.add(new Object[]{sp, cp});
            }
        }
        return params;
    }

    @ParameterizedTest(name="{index}: serverSslProvider = {0}, clientSslProvider = {1}")
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    @MethodSource(value={"parameters"})
    public void testSniSNIMatcherMatchesClient(SslProvider serverProvider, SslProvider clientProvider) throws Exception {
        Assumptions.assumeTrue((PlatformDependent.javaVersion() >= 8 ? 1 : 0) != 0);
        SniClientJava8TestUtil.testSniClient(serverProvider, clientProvider, true);
    }

    @ParameterizedTest(name="{index}: serverSslProvider = {0}, clientSslProvider = {1}")
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    @MethodSource(value={"parameters"})
    public void testSniSNIMatcherDoesNotMatchClient(final SslProvider serverProvider, final SslProvider clientProvider) {
        Assumptions.assumeTrue((PlatformDependent.javaVersion() >= 8 ? 1 : 0) != 0);
        Assertions.assertThrows(SSLException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SniClientJava8TestUtil.testSniClient(serverProvider, clientProvider, false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: serverSslProvider = {0}, clientSslProvider = {1}")
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    @MethodSource(value={"parameters"})
    public void testSniClient(SslProvider sslServerProvider, SslProvider sslClientProvider) throws Exception {
        Channel sc;
        SslContext sslClientContext;
        SslContext sslServerContext;
        SelfSignedCertificate cert;
        DefaultEventLoopGroup group;
        block8: {
            String sniHostName = "sni.netty.io";
            LocalAddress address = new LocalAddress("SniClientTest");
            group = new DefaultEventLoopGroup(1);
            cert = new SelfSignedCertificate();
            sslServerContext = null;
            sslClientContext = null;
            sc = null;
            Channel cc = null;
            try {
                if (!(sslServerProvider != SslProvider.OPENSSL && sslServerProvider != SslProvider.OPENSSL_REFCNT || OpenSsl.useKeyManagerFactory())) {
                    sslServerContext = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(sslServerProvider).build();
                } else {
                    KeyManagerFactory kmf = PlatformDependent.javaVersion() >= 8 ? SniClientJava8TestUtil.newSniX509KeyManagerFactory(cert, sniHostName) : SslContext.buildKeyManagerFactory((X509Certificate[])new X509Certificate[]{cert.cert()}, null, (PrivateKey)cert.key(), null, null, null);
                    sslServerContext = SslContextBuilder.forServer((KeyManagerFactory)kmf).sslProvider(sslServerProvider).build();
                }
                final SslContext finalContext = sslServerContext;
                final Promise promise = group.next().newPromise();
                ServerBootstrap sb = new ServerBootstrap();
                sc = ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addFirst(new ChannelHandler[]{new SniHandler((Mapping)new Mapping<String, SslContext>(){

                            public SslContext map(String input) {
                                promise.setSuccess((Object)input);
                                return finalContext;
                            }
                        })});
                    }
                }).bind((SocketAddress)address).syncUninterruptibly().channel();
                TrustManagerFactory tmf = PlatformDependent.javaVersion() >= 8 ? SniClientJava8TestUtil.newSniX509TrustmanagerFactory(sniHostName) : InsecureTrustManagerFactory.INSTANCE;
                sslClientContext = SslContextBuilder.forClient().trustManager(tmf).sslProvider(sslClientProvider).build();
                Bootstrap cb = new Bootstrap();
                SslHandler handler = new SslHandler(sslClientContext.newEngine(ByteBufAllocator.DEFAULT, sniHostName, -1));
                cc = ((Bootstrap)((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)handler)).connect((SocketAddress)address).syncUninterruptibly().channel();
                Assertions.assertEquals((Object)sniHostName, (Object)promise.syncUninterruptibly().getNow());
                handler.handshakeFuture().syncUninterruptibly();
                Assertions.assertNull((Object)handler.engine().getHandshakeSession());
                if (PlatformDependent.javaVersion() >= 8) {
                    SniClientJava8TestUtil.assertSSLSession(handler.engine().getUseClientMode(), handler.engine().getSession(), sniHostName);
                }
                if (cc == null) break block8;
            }
            catch (Throwable throwable) {
                if (cc != null) {
                    cc.close().syncUninterruptibly();
                }
                if (sc != null) {
                    sc.close().syncUninterruptibly();
                }
                ReferenceCountUtil.release(sslServerContext);
                ReferenceCountUtil.release(sslClientContext);
                cert.delete();
                group.shutdownGracefully();
                throw throwable;
            }
            cc.close().syncUninterruptibly();
        }
        if (sc != null) {
            sc.close().syncUninterruptibly();
        }
        ReferenceCountUtil.release((Object)sslServerContext);
        ReferenceCountUtil.release((Object)sslClientContext);
        cert.delete();
        group.shutdownGracefully();
    }
}

