/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DecoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.TooLongFrameException;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.JettyAlpnSslEngine;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.NotSslRecordException;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SniCompletionEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SniHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslCompletionEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandshakeTimeoutException;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.util.DomainNameMapping;
import org.neo4j.driver.internal.shaded.io.netty.util.DomainNameMappingBuilder;
import org.neo4j.driver.internal.shaded.io.netty.util.Mapping;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCounted;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ObjectUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ResourcesUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.StringUtil;

public class SniHandlerTest {
    private static ApplicationProtocolConfig newApnConfig() {
        return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"myprotocol"});
    }

    private static void assumeApnSupported(SslProvider provider) {
        switch (provider) {
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                Assumptions.assumeTrue((boolean)OpenSsl.isAlpnSupported());
                break;
            }
            case JDK: {
                Assumptions.assumeTrue((boolean)JettyAlpnSslEngine.isAvailable());
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private static SslContext makeSslContext(SslProvider provider, boolean apn) throws Exception {
        if (apn) {
            SniHandlerTest.assumeApnSupported(provider);
        }
        File keyFile = ResourcesUtil.getFile(SniHandlerTest.class, (String)"test_encrypted.pem");
        File crtFile = ResourcesUtil.getFile(SniHandlerTest.class, (String)"test.crt");
        SslContextBuilder sslCtxBuilder = SslContextBuilder.forServer((File)crtFile, (File)keyFile, (String)"12345").sslProvider(provider);
        if (apn) {
            sslCtxBuilder.applicationProtocolConfig(SniHandlerTest.newApnConfig());
        }
        return sslCtxBuilder.build();
    }

    private static SslContext makeSslClientContext(SslProvider provider, boolean apn) throws Exception {
        if (apn) {
            SniHandlerTest.assumeApnSupported(provider);
        }
        File crtFile = ResourcesUtil.getFile(SniHandlerTest.class, (String)"test.crt");
        SslContextBuilder sslCtxBuilder = SslContextBuilder.forClient().trustManager(crtFile).sslProvider(provider);
        if (apn) {
            sslCtxBuilder.applicationProtocolConfig(SniHandlerTest.newApnConfig());
        }
        return sslCtxBuilder.build();
    }

    static Iterable<?> data() {
        ArrayList<SslProvider> params = new ArrayList<SslProvider>(3);
        if (OpenSsl.isAvailable()) {
            params.add(SslProvider.OPENSSL);
            params.add(SslProvider.OPENSSL_REFCNT);
        }
        params.add(SslProvider.JDK);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    public void testNonSslRecord(SslProvider provider) throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(provider, false);
        try {
            final AtomicReference evtRef = new AtomicReference();
            SniHandler handler = new SniHandler(new DomainNameMappingBuilder((Object)nettyContext).build());
            final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof SslHandshakeCompletionEvent) {
                        Assertions.assertTrue((boolean)evtRef.compareAndSet(null, (SslHandshakeCompletionEvent)evt));
                    }
                }
            }});
            try {
                final byte[] bytes = new byte[1024];
                bytes[0] = 21;
                DecoderException e = (DecoderException)Assertions.assertThrows(DecoderException.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])bytes)});
                    }
                });
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(NotSslRecordException.class));
                Assertions.assertFalse((boolean)ch.finish());
            }
            finally {
                ch.finishAndReleaseAll();
            }
            MatcherAssert.assertThat((Object)((SslHandshakeCompletionEvent)evtRef.get()).cause(), (Matcher)CoreMatchers.instanceOf(NotSslRecordException.class));
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    public void testServerNameParsing(SslProvider provider) throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(provider, false);
        SslContext leanContext = SniHandlerTest.makeSslContext(provider, false);
        SslContext leanContext2 = SniHandlerTest.makeSslContext(provider, false);
        try {
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).add("*.netty.io", (Object)nettyContext).add("*.LEANCLOUD.CN", (Object)leanContext).add("chat4.leancloud.cn", (Object)leanContext2).build();
            final AtomicReference evtRef = new AtomicReference();
            SniHandler handler = new SniHandler(mapping);
            EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof SniCompletionEvent) {
                        Assertions.assertTrue((boolean)evtRef.compareAndSet(null, (SniCompletionEvent)evt));
                    } else {
                        ctx.fireUserEventTriggered(evt);
                    }
                }
            }});
            try {
                String tlsHandshakeMessageHex1 = "16030100";
                String tlsHandshakeMessageHex = "c6010000c20303bb0855d66532c05a0ef784f7c384feeafa68b3b655ac7288650d5eed4aa3fb52000038c02cc030009fcca9cca8ccaac02bc02f009ec024c028006bc023c0270067c00ac0140039c009c0130033009d009c003d003c0035002f00ff0100006100000017001500001243484154342e4c45414e434c4f55442e434e000b000403000102000a000a0008001d00170019001800230000000d0020001e0601060206030501050205030401040204030301030203030201020202030016000000170000";
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)tlsHandshakeMessageHex1))});
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)tlsHandshakeMessageHex))});
                Assertions.assertTrue((boolean)ch.finish());
                MatcherAssert.assertThat((Object)handler.hostname(), (Matcher)CoreMatchers.is((Object)"chat4.leancloud.cn"));
                MatcherAssert.assertThat((Object)handler.sslContext(), (Matcher)CoreMatchers.is((Object)leanContext));
                SniCompletionEvent evt = (SniCompletionEvent)evtRef.get();
                Assertions.assertNotNull((Object)evt);
                Assertions.assertEquals((Object)"chat4.leancloud.cn", (Object)evt.hostname());
                Assertions.assertTrue((boolean)evt.isSuccess());
                Assertions.assertNull((Object)evt.cause());
            }
            finally {
                ch.finishAndReleaseAll();
            }
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    public void testNonAsciiServerNameParsing(SslProvider provider) throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(provider, false);
        SslContext leanContext = SniHandlerTest.makeSslContext(provider, false);
        SslContext leanContext2 = SniHandlerTest.makeSslContext(provider, false);
        try {
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).add("*.netty.io", (Object)nettyContext).add("*.LEANCLOUD.CN", (Object)leanContext).add("chat4.leancloud.cn", (Object)leanContext2).build();
            SniHandler handler = new SniHandler(mapping);
            final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
            try {
                String tlsHandshakeMessageHex1 = "16030100";
                String tlsHandshakeMessageHex = "bd010000b90303a74225676d1814ba57faff3b3663656ed05ee9dbb2a4dbb1bb1c32d2ea5fc39e0000000100008c0000001700150000164348415434E380824C45414E434C4F5544E38082434E000b000403000102000a00340032000e000d0019000b000c00180009000a00160017000800060007001400150004000500120013000100020003000f0010001100230000000d0020001e060106020603050105020503040104020403030103020303020102020203000f00010133740000";
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)tlsHandshakeMessageHex1))});
                Assertions.assertThrows(DecoderException.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)"bd010000b90303a74225676d1814ba57faff3b3663656ed05ee9dbb2a4dbb1bb1c32d2ea5fc39e0000000100008c0000001700150000164348415434E380824C45414E434C4F5544E38082434E000b000403000102000a00340032000e000d0019000b000c00180009000a00160017000800060007001400150004000500120013000100020003000f0010001100230000000d0020001e060106020603050105020503040104020403030103020303020102020203000f00010133740000"))});
                    }
                });
            }
            finally {
                ch.finishAndReleaseAll();
            }
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    public void testFallbackToDefaultContext(SslProvider provider) throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(provider, false);
        SslContext leanContext = SniHandlerTest.makeSslContext(provider, false);
        SslContext leanContext2 = SniHandlerTest.makeSslContext(provider, false);
        try {
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).add("*.netty.io", (Object)nettyContext).add("*.LEANCLOUD.CN", (Object)leanContext).add("chat4.leancloud.cn", (Object)leanContext2).build();
            SniHandler handler = new SniHandler(mapping);
            EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
            byte[] message = new byte[]{22, 3, 1, 0, 0};
            try {
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])message)});
            }
            catch (Exception exception) {
                // empty catch block
            }
            ch.close();
            ByteBuf buf = (ByteBuf)ch.readOutbound();
            if (buf != null) {
                Assertions.assertFalse((boolean)buf.isReadable());
                buf.release();
            }
            MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)handler.hostname(), (Matcher)CoreMatchers.nullValue());
            MatcherAssert.assertThat((Object)handler.sslContext(), (Matcher)CoreMatchers.is((Object)nettyContext));
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testMajorVersionNot3(SslProvider provider) throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(provider, false);
        try {
            ByteBuf buf;
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).build();
            SniHandler handler = new SniHandler(mapping);
            EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
            byte[] message = new byte[]{22, 2, 0, 0, 0};
            try {
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])message)});
            }
            catch (Exception exception) {
                // empty catch block
            }
            ch.close();
            while ((buf = (ByteBuf)ch.readOutbound()) != null) {
                buf.release();
            }
            MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)handler.hostname(), (Matcher)CoreMatchers.nullValue());
            MatcherAssert.assertThat((Object)handler.sslContext(), (Matcher)CoreMatchers.is((Object)nettyContext));
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    public void testSniWithApnHandler(SslProvider provider) throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(provider, true);
        SslContext sniContext = SniHandlerTest.makeSslContext(provider, true);
        final SslContext clientContext = SniHandlerTest.makeSslClientContext(provider, true);
        try {
            final AtomicBoolean serverApnCtx = new AtomicBoolean(false);
            final AtomicBoolean clientApnCtx = new AtomicBoolean(false);
            final CountDownLatch serverApnDoneLatch = new CountDownLatch(1);
            final CountDownLatch clientApnDoneLatch = new CountDownLatch(1);
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).add("*.netty.io", (Object)nettyContext).add("sni.fake.site", (Object)sniContext).build();
            final SniHandler handler = new SniHandler(mapping);
            NioEventLoopGroup group = new NioEventLoopGroup(2);
            Channel serverChannel = null;
            Channel clientChannel = null;
            try {
                ServerBootstrap sb = new ServerBootstrap();
                sb.group((EventLoopGroup)group);
                sb.channel(NioServerSocketChannel.class);
                sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ChannelPipeline p = ch.pipeline();
                        p.addLast(new ChannelHandler[]{handler});
                        p.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("foo"){

                            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                                serverApnCtx.set(ctx.pipeline().context((ChannelHandler)this) != null);
                                serverApnDoneLatch.countDown();
                            }
                        }});
                    }
                });
                Bootstrap cb = new Bootstrap();
                cb.group((EventLoopGroup)group);
                cb.channel(NioSocketChannel.class);
                cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(clientContext.newEngine(ch.alloc(), "sni.fake.site", -1))});
                        ch.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("foo"){

                            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                                clientApnCtx.set(ctx.pipeline().context((ChannelHandler)this) != null);
                                clientApnDoneLatch.countDown();
                            }
                        }});
                    }
                });
                serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
                ChannelFuture ccf = cb.connect(serverChannel.localAddress());
                Assertions.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
                clientChannel = ccf.channel();
                Assertions.assertTrue((boolean)serverApnDoneLatch.await(5L, TimeUnit.SECONDS));
                Assertions.assertTrue((boolean)clientApnDoneLatch.await(5L, TimeUnit.SECONDS));
                Assertions.assertTrue((boolean)serverApnCtx.get());
                Assertions.assertTrue((boolean)clientApnCtx.get());
                MatcherAssert.assertThat((Object)handler.hostname(), (Matcher)CoreMatchers.is((Object)"sni.fake.site"));
                MatcherAssert.assertThat((Object)handler.sslContext(), (Matcher)CoreMatchers.is((Object)sniContext));
            }
            finally {
                if (serverChannel != null) {
                    serverChannel.close().sync();
                }
                if (clientChannel != null) {
                    clientChannel.close().sync();
                }
                group.shutdownGracefully(0L, 0L, TimeUnit.MICROSECONDS);
            }
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(clientContext, nettyContext, sniContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(clientContext, nettyContext, sniContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testReplaceHandler(SslProvider provider) throws Exception {
        switch (18.$SwitchMap$io$netty$handler$ssl$SslProvider[provider.ordinal()]) {
            case 1: 
            case 2: {
                sniHost = "sni.netty.io";
                address = new LocalAddress("testReplaceHandler-" + Math.random());
                group = new DefaultEventLoopGroup(1);
                sc = null;
                cc = null;
                sslContext = null;
                cert = new SelfSignedCertificate();
                try {
                    sslServerContext = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(provider).build();
                    mapping = new Mapping<String, SslContext>(){

                        public SslContext map(String input) {
                            return sslServerContext;
                        }
                    };
                    releasePromise = group.next().newPromise();
                    handler = new SniHandler((Mapping)mapping){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void replaceHandler(ChannelHandlerContext ctx, String hostname, SslContext sslContext) throws Exception {
                            boolean success = false;
                            try {
                                Assertions.assertEquals((int)1, (int)((ReferenceCountedOpenSslContext)sslContext).refCnt());
                                SSLEngine sslEngine = sslContext.newEngine(ctx.alloc());
                                try {
                                    Assertions.assertEquals((int)2, (int)((ReferenceCountedOpenSslContext)sslContext).refCnt());
                                    CustomSslHandler customSslHandler = new CustomSslHandler(sslContext, sslEngine){

                                        @Override
                                        public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
                                            try {
                                                super.handlerRemoved0(ctx);
                                            }
                                            finally {
                                                releasePromise.trySuccess(null);
                                            }
                                        }
                                    };
                                    ctx.pipeline().replace((ChannelHandler)this, CustomSslHandler.class.getName(), (ChannelHandler)customSslHandler);
                                    success = true;
                                }
                                finally {
                                    if (!success) {
                                        ReferenceCountUtil.safeRelease((Object)sslEngine);
                                    }
                                }
                            }
                            finally {
                                if (!success) {
                                    ReferenceCountUtil.safeRelease((Object)sslContext);
                                    releasePromise.cancel(true);
                                }
                            }
                        }
                    };
                    sb = new ServerBootstrap();
                    sc = ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                        protected void initChannel(Channel ch) throws Exception {
                            ch.pipeline().addFirst(new ChannelHandler[]{handler});
                        }
                    }).bind((SocketAddress)address).syncUninterruptibly().channel();
                    sslContext = SslContextBuilder.forClient().sslProvider(provider).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                    cb = new Bootstrap();
                    cc = ((Bootstrap)((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new SslHandler(sslContext.newEngine(ByteBufAllocator.DEFAULT, "sni.netty.io", -1)))).connect((SocketAddress)address).syncUninterruptibly().channel();
                    cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Hello, World!".getBytes())).syncUninterruptibly();
                    Assertions.assertEquals((int)2, (int)((ReferenceCounted)sslServerContext).refCnt());
                    cc.close().syncUninterruptibly();
                    if (!releasePromise.awaitUninterruptibly(10L, TimeUnit.SECONDS)) {
                        throw new IllegalStateException("It doesn't seem #replaceHandler() got called.");
                    }
                    Assertions.assertEquals((int)0, (int)((ReferenceCounted)sslServerContext).refCnt());
                    if (cc == null) ** GOTO lbl45
                }
                catch (Throwable var15_15) {
                    if (cc != null) {
                        cc.close().syncUninterruptibly();
                    }
                    if (sc != null) {
                        sc.close().syncUninterruptibly();
                    }
                    if (sslContext != null) {
                        ReferenceCountUtil.release(sslContext);
                    }
                    group.shutdownGracefully();
                    cert.delete();
                    throw var15_15;
                }
                cc.close().syncUninterruptibly();
lbl45:
                // 2 sources

                if (sc != null) {
                    sc.close().syncUninterruptibly();
                }
                if (sslContext != null) {
                    ReferenceCountUtil.release((Object)sslContext);
                }
                group.shutdownGracefully();
                cert.delete();
            }
            case 3: {
                return;
            }
        }
        throw new Error();
    }

    private static void releaseAll(SslContext ... contexts) {
        for (SslContext ctx : contexts) {
            ReferenceCountUtil.release((Object)ctx);
        }
    }

    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    public void testNonFragmented(SslProvider provider) throws Exception {
        this.testWithFragmentSize(provider, Integer.MAX_VALUE);
    }

    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    public void testFragmented(SslProvider provider) throws Exception {
        this.testWithFragmentSize(provider, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWithFragmentSize(SslProvider provider, int maxFragmentSize) throws Exception {
        String sni = "netty.io";
        SelfSignedCertificate cert = new SelfSignedCertificate();
        final SslContext context = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(provider).build();
        try {
            EmbeddedChannel server = new EmbeddedChannel(new ChannelHandler[]{new SniHandler((DomainNameMapping)Mockito.mock(DomainNameMapping.class)){

                protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) {
                    Assertions.assertEquals((Object)"netty.io", (Object)hostname);
                    return ctx.executor().newSucceededFuture((Object)context);
                }
            }});
            List<ByteBuf> buffers = SniHandlerTest.clientHelloInMultipleFragments(provider, "netty.io", maxFragmentSize);
            for (ByteBuf buffer : buffers) {
                server.writeInbound(new Object[]{buffer});
            }
            Assertions.assertTrue((boolean)server.finishAndReleaseAll());
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(context);
            cert.delete();
            throw throwable;
        }
        SniHandlerTest.releaseAll(context);
        cert.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ByteBuf> clientHelloInMultipleFragments(SslProvider provider, String hostname, int maxTlsPlaintextSize) throws SSLException {
        List<ByteBuf> list;
        EmbeddedChannel client = new EmbeddedChannel();
        SslContext ctx = SslContextBuilder.forClient().sslProvider(provider).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        try {
            SslHandler sslHandler = ctx.newHandler(client.alloc(), hostname, -1);
            client.pipeline().addLast(new ChannelHandler[]{sslHandler});
            ByteBuf clientHello = (ByteBuf)client.readOutbound();
            List<ByteBuf> buffers = SniHandlerTest.split(clientHello, maxTlsPlaintextSize);
            Assertions.assertTrue((boolean)client.finishAndReleaseAll());
            list = buffers;
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(ctx);
            throw throwable;
        }
        SniHandlerTest.releaseAll(ctx);
        return list;
    }

    private static List<ByteBuf> split(ByteBuf clientHello, int maxSize) {
        short type = clientHello.readUnsignedByte();
        int version = clientHello.readUnsignedShort();
        int length = clientHello.readUnsignedShort();
        Assertions.assertEquals((int)length, (int)clientHello.readableBytes());
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>();
        while (clientHello.readableBytes() > 0) {
            int toRead = Math.min(maxSize, clientHello.readableBytes());
            ByteBuf bb = clientHello.alloc().buffer(5 + toRead);
            bb.writeByte((int)type);
            bb.writeShort(version);
            bb.writeShort(toRead);
            bb.writeBytes(clientHello, toRead);
            result.add(bb);
        }
        clientHello.release();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSniHandlerFailsOnTooBigClientHello() throws Exception {
        SniHandler handler = new SniHandler((Mapping)new Mapping<String, SslContext>(){

            public SslContext map(String input) {
                throw new UnsupportedOperationException("Should not be called");
            }
        }, 10, 0L);
        final AtomicReference completionEventRef = new AtomicReference();
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt instanceof SniCompletionEvent) {
                    completionEventRef.set((SniCompletionEvent)evt);
                }
            }
        }});
        final ByteBuf buffer = ch.alloc().buffer();
        buffer.writeByte(22);
        buffer.writeShort(771);
        buffer.writeShort(6);
        buffer.writeByte(1);
        buffer.writeMedium(0xFFFFFF);
        buffer.writeShort(771);
        Assertions.assertThrows(TooLongFrameException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ch.writeInbound(new Object[]{buffer});
            }
        });
        try {
            while (completionEventRef.get() == null) {
                Thread.sleep(100L);
                ch.runPendingTasks();
            }
            SniCompletionEvent completionEvent = (SniCompletionEvent)completionEventRef.get();
            Assertions.assertNotNull((Object)completionEvent);
            Assertions.assertNotNull((Object)completionEvent.cause());
            Assertions.assertEquals(TooLongFrameException.class, completionEvent.cause().getClass());
        }
        finally {
            ch.finishAndReleaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSniHandlerFiresHandshakeTimeout() throws Exception {
        SniHandler handler = new SniHandler((Mapping)new Mapping<String, SslContext>(){

            public SslContext map(String input) {
                throw new UnsupportedOperationException("Should not be called");
            }
        }, 0, 10L);
        final AtomicReference completionEventRef = new AtomicReference();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt instanceof SniCompletionEvent) {
                    completionEventRef.set((SniCompletionEvent)evt);
                }
            }
        }});
        try {
            while (completionEventRef.get() == null) {
                Thread.sleep(100L);
                ch.runPendingTasks();
            }
            SniCompletionEvent completionEvent = (SniCompletionEvent)completionEventRef.get();
            Assertions.assertNotNull((Object)completionEvent);
            Assertions.assertNotNull((Object)completionEvent.cause());
            Assertions.assertEquals(SslHandshakeTimeoutException.class, completionEvent.cause().getClass());
        }
        finally {
            ch.finishAndReleaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: sslProvider={0}")
    @MethodSource(value={"data"})
    public void testSslHandlerFiresHandshakeTimeout(SslProvider provider) throws Exception {
        final SslContext context = SniHandlerTest.makeSslContext(provider, false);
        SniHandler handler = new SniHandler((Mapping)new Mapping<String, SslContext>(){

            public SslContext map(String input) {
                return context;
            }
        }, 0, 100L);
        final AtomicReference sniCompletionEventRef = new AtomicReference();
        final AtomicReference handshakeCompletionEventRef = new AtomicReference();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt instanceof SniCompletionEvent) {
                    sniCompletionEventRef.set((SniCompletionEvent)evt);
                } else if (evt instanceof SslHandshakeCompletionEvent) {
                    handshakeCompletionEventRef.set((SslHandshakeCompletionEvent)evt);
                }
            }
        }});
        try {
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)"16030301800100017c0303478ae7e536aa7a9debad1f873121862d2d3d3173e0ef42975c31007faeb252522047f55f81fc84fe58951e2af14026147d6178498fde551fcbafc636462c016ec9005a13011302c02cc02bc030009dc02ec032009f00a3c02f009cc02dc031009e00a2c024c028003dc026c02a006b006ac00ac0140035c005c00f00390038c023c027003cc025c02900670040c009c013002fc004c00e0033003200ff010000d90000000a0008000005686f737431000500050100000000000a00160014001d001700180019001e01000101010201030104000b00020100000d002800260403050306030804080508060809080a080b04010501060104020303030103020203020102020032002800260403050306030804080508060809080a080b04010501060104020303030103020203020102020011000900070200040000000000170000002b00050403040303002d00020101003300260024001d00200bbc37375e214c1e4e7cb90f869e131dc983a21f8205ba24456177f340904935"))});
            while (handshakeCompletionEventRef.get() == null) {
                Thread.sleep(10L);
                ch.runPendingTasks();
            }
            SniCompletionEvent sniCompletionEvent = (SniCompletionEvent)sniCompletionEventRef.get();
            Assertions.assertNotNull((Object)sniCompletionEvent);
            Assertions.assertEquals((Object)"host1", (Object)sniCompletionEvent.hostname());
            SslCompletionEvent handshakeCompletionEvent = (SslCompletionEvent)handshakeCompletionEventRef.get();
            Assertions.assertNotNull((Object)handshakeCompletionEvent);
            Assertions.assertNotNull((Object)handshakeCompletionEvent.cause());
            Assertions.assertEquals(SslHandshakeTimeoutException.class, handshakeCompletionEvent.cause().getClass());
        }
        catch (Throwable throwable) {
            ch.finishAndReleaseAll();
            SniHandlerTest.releaseAll(context);
            throw throwable;
        }
        ch.finishAndReleaseAll();
        SniHandlerTest.releaseAll(context);
    }

    private static class CustomSslHandler
    extends SslHandler {
        private final SslContext sslContext;

        CustomSslHandler(SslContext sslContext, SSLEngine sslEngine) {
            super(sslEngine);
            this.sslContext = (SslContext)ObjectUtil.checkNotNull((Object)sslContext, (String)"sslContext");
        }

        public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
            super.handlerRemoved0(ctx);
            ReferenceCountUtil.release((Object)this.sslContext);
        }
    }
}

