/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.Java8SslTestUtils;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;

public class SslContextTrustManagerTest {
    @Test
    public void testUsingAllCAs() throws Exception {
        SslContextTrustManagerTest.runTests(new String[]{"tm_test_ca_1a.pem", "tm_test_ca_1b.pem", "tm_test_ca_2.pem"}, new String[]{"tm_test_eec_1.pem", "tm_test_eec_2.pem", "tm_test_eec_3.pem"}, new boolean[]{true, true, true});
    }

    @Test
    public void testUsingAllCAsWithDuplicates() throws Exception {
        SslContextTrustManagerTest.runTests(new String[]{"tm_test_ca_1a.pem", "tm_test_ca_1b.pem", "tm_test_ca_2.pem", "tm_test_ca_2.pem"}, new String[]{"tm_test_eec_1.pem", "tm_test_eec_2.pem", "tm_test_eec_3.pem"}, new boolean[]{true, true, true});
    }

    @Test
    public void testUsingCAsOneAandB() throws Exception {
        SslContextTrustManagerTest.runTests(new String[]{"tm_test_ca_1a.pem", "tm_test_ca_1b.pem"}, new String[]{"tm_test_eec_1.pem", "tm_test_eec_2.pem", "tm_test_eec_3.pem"}, new boolean[]{true, true, false});
    }

    @Test
    public void testUsingCAsOneAandTwo() throws Exception {
        SslContextTrustManagerTest.runTests(new String[]{"tm_test_ca_1a.pem", "tm_test_ca_2.pem"}, new String[]{"tm_test_eec_1.pem", "tm_test_eec_2.pem", "tm_test_eec_3.pem"}, new boolean[]{true, false, true});
    }

    private static void runTests(String[] caResources, String[] eecResources, boolean[] expectations) throws Exception {
        X509TrustManager tm = SslContextTrustManagerTest.getTrustManager(caResources);
        X509Certificate[] eecCerts = Java8SslTestUtils.loadCertCollection(eecResources);
        for (int i = 0; i < eecResources.length; ++i) {
            X509Certificate eecCert = eecCerts[i];
            Assertions.assertNotNull((Object)eecCert, (String)("Cannot use cert " + eecResources[i]));
            try {
                tm.checkServerTrusted(new X509Certificate[]{eecCert}, "RSA");
                if (expectations[i]) continue;
                Assertions.fail((String)String.format("Certificate %s was expected not to be valid when using CAs %s, but its verification passed.", eecResources[i], Arrays.asList(caResources)));
                continue;
            }
            catch (CertificateException e) {
                if (!expectations[i]) continue;
                Assertions.fail((String)String.format("Certificate %s was expected to be valid when using CAs %s, but its verification failed.", eecResources[i], Arrays.asList(caResources)));
            }
        }
    }

    private static X509TrustManager getTrustManager(String[] resourceNames) throws Exception {
        X509Certificate[] certCollection = Java8SslTestUtils.loadCertCollection(resourceNames);
        TrustManagerFactory tmf = SslContext.buildTrustManagerFactory((X509Certificate[])certCollection, null, null);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new Exception("Unable to find any X509TrustManager from this factory.");
    }
}

