/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ocsp;

import java.io.File;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLHandshakeException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ocsp.OcspClientHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;

public class OcspTest {
    @BeforeAll
    public static void checkOcspSupported() {
        Assumptions.assumeTrue((boolean)OpenSsl.isOcspSupported());
    }

    @Test
    public void testJdkClientEnableOcsp() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContextBuilder.forClient().sslProvider(SslProvider.JDK).enableOcsp(true).build();
            }
        });
    }

    @Test
    public void testJdkServerEnableOcsp() throws Exception {
        final SelfSignedCertificate ssc = new SelfSignedCertificate();
        try {
            Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(SslProvider.JDK).enableOcsp(true).build();
                }
            });
        }
        finally {
            ssc.delete();
        }
    }

    @Test
    public void testClientOcspNotEnabledOpenSsl() throws Exception {
        OcspTest.testClientOcspNotEnabled(SslProvider.OPENSSL);
    }

    @Test
    public void testClientOcspNotEnabledOpenSslRefCnt() throws Exception {
        OcspTest.testClientOcspNotEnabled(SslProvider.OPENSSL_REFCNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testClientOcspNotEnabled(SslProvider sslProvider) throws Exception {
        SslContext context = SslContextBuilder.forClient().sslProvider(sslProvider).build();
        try {
            SslHandler sslHandler = context.newHandler(ByteBufAllocator.DEFAULT);
            final ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
            try {
                Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

                    public void execute() {
                        engine.getOcspResponse();
                    }
                });
            }
            finally {
                engine.release();
            }
        }
        finally {
            ReferenceCountUtil.release((Object)context);
        }
    }

    @Test
    public void testServerOcspNotEnabledOpenSsl() throws Exception {
        OcspTest.testServerOcspNotEnabled(SslProvider.OPENSSL);
    }

    @Test
    public void testServerOcspNotEnabledOpenSslRefCnt() throws Exception {
        OcspTest.testServerOcspNotEnabled(SslProvider.OPENSSL_REFCNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testServerOcspNotEnabled(SslProvider sslProvider) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        try {
            SslContext context = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(sslProvider).build();
            try {
                SslHandler sslHandler = context.newHandler(ByteBufAllocator.DEFAULT);
                final ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                try {
                    Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

                        public void execute() {
                            engine.setOcspResponse(new byte[]{1, 2, 3});
                        }
                    });
                }
                finally {
                    engine.release();
                }
            }
            finally {
                ReferenceCountUtil.release((Object)context);
            }
        }
        finally {
            ssc.delete();
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testClientAcceptingOcspStapleOpenSsl() throws Exception {
        OcspTest.testClientAcceptingOcspStaple(SslProvider.OPENSSL);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testClientAcceptingOcspStapleOpenSslRefCnt() throws Exception {
        OcspTest.testClientAcceptingOcspStaple(SslProvider.OPENSSL_REFCNT);
    }

    private static void testClientAcceptingOcspStaple(SslProvider sslProvider) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelInboundHandlerAdapter serverHandler = new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Hello, World!".getBytes()));
                ctx.fireChannelActive();
            }
        };
        ChannelInboundHandlerAdapter clientHandler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                try {
                    ReferenceCountUtil.release((Object)msg);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        byte[] response = OcspTest.newOcspResponse();
        TestClientOcspContext callback = new TestClientOcspContext(true);
        OcspTest.handshake(sslProvider, latch, (ChannelHandler)serverHandler, response, (ChannelHandler)clientHandler, callback);
        byte[] actual = callback.response();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertNotSame((Object)response, (Object)actual);
        Assertions.assertArrayEquals((byte[])response, (byte[])actual);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testClientRejectingOcspStapleOpenSsl() throws Exception {
        OcspTest.testClientRejectingOcspStaple(SslProvider.OPENSSL);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testClientRejectingOcspStapleOpenSslRefCnt() throws Exception {
        OcspTest.testClientRejectingOcspStaple(SslProvider.OPENSSL_REFCNT);
    }

    private static void testClientRejectingOcspStaple(SslProvider sslProvider) throws Exception {
        final AtomicReference causeRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelInboundHandlerAdapter clientHandler = new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                try {
                    causeRef.set(cause);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        byte[] response = OcspTest.newOcspResponse();
        TestClientOcspContext callback = new TestClientOcspContext(false);
        OcspTest.handshake(sslProvider, latch, null, response, (ChannelHandler)clientHandler, callback);
        byte[] actual = callback.response();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertNotSame((Object)response, (Object)actual);
        Assertions.assertArrayEquals((byte[])response, (byte[])actual);
        Throwable cause = (Throwable)causeRef.get();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(SSLHandshakeException.class));
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testServerHasNoStapleOpenSsl() throws Exception {
        OcspTest.testServerHasNoStaple(SslProvider.OPENSSL);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testServerHasNoStapleOpenSslRefCnt() throws Exception {
        OcspTest.testServerHasNoStaple(SslProvider.OPENSSL_REFCNT);
    }

    private static void testServerHasNoStaple(SslProvider sslProvider) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelInboundHandlerAdapter serverHandler = new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Hello, World!".getBytes()));
                ctx.fireChannelActive();
            }
        };
        ChannelInboundHandlerAdapter clientHandler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                try {
                    ReferenceCountUtil.release((Object)msg);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        byte[] response = null;
        TestClientOcspContext callback = new TestClientOcspContext(true);
        OcspTest.handshake(sslProvider, latch, (ChannelHandler)serverHandler, response, (ChannelHandler)clientHandler, callback);
        byte[] actual = callback.response();
        Assertions.assertNull(response);
        Assertions.assertNull((Object)actual);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testClientExceptionOpenSsl() throws Exception {
        OcspTest.testClientException(SslProvider.OPENSSL);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testClientExceptionOpenSslRefCnt() throws Exception {
        OcspTest.testClientException(SslProvider.OPENSSL_REFCNT);
    }

    private static void testClientException(SslProvider sslProvider) throws Exception {
        final AtomicReference causeRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelInboundHandlerAdapter clientHandler = new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                try {
                    causeRef.set(cause);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        final OcspTestException clientException = new OcspTestException("testClientException");
        byte[] response = OcspTest.newOcspResponse();
        OcspClientCallback callback = new OcspClientCallback(){

            @Override
            public boolean verify(byte[] response) throws Exception {
                throw clientException;
            }
        };
        OcspTest.handshake(sslProvider, latch, null, response, (ChannelHandler)clientHandler, callback);
        Assertions.assertSame((Object)clientException, causeRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handshake(SslProvider sslProvider, CountDownLatch latch, ChannelHandler serverHandler, byte[] response, ChannelHandler clientHandler, OcspClientCallback callback) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        try {
            SslContext serverSslContext = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(sslProvider).enableOcsp(true).build();
            try {
                SslContext clientSslContext = SslContextBuilder.forClient().sslProvider(sslProvider).enableOcsp(true).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                try {
                    DefaultEventLoopGroup group = new DefaultEventLoopGroup();
                    try {
                        LocalAddress address = new LocalAddress("handshake-" + Math.random());
                        Channel server = OcspTest.newServer((EventLoopGroup)group, (SocketAddress)address, serverSslContext, response, serverHandler);
                        Channel client = OcspTest.newClient((EventLoopGroup)group, (SocketAddress)address, clientSslContext, callback, clientHandler);
                        try {
                            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
                        }
                        finally {
                            client.close().syncUninterruptibly();
                            server.close().syncUninterruptibly();
                        }
                    }
                    finally {
                        group.shutdownGracefully(1L, 1L, TimeUnit.SECONDS);
                    }
                }
                finally {
                    ReferenceCountUtil.release((Object)clientSslContext);
                }
            }
            finally {
                ReferenceCountUtil.release((Object)serverSslContext);
            }
        }
        finally {
            ssc.delete();
        }
    }

    private static Channel newServer(EventLoopGroup group, SocketAddress address, SslContext context, byte[] response, ChannelHandler handler) {
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group(group).childHandler(OcspTest.newServerHandler(context, response, handler));
        return bootstrap.bind(address).syncUninterruptibly().channel();
    }

    private static Channel newClient(EventLoopGroup group, SocketAddress address, SslContext context, OcspClientCallback callback, ChannelHandler handler) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group(group)).handler(OcspTest.newClientHandler(context, callback, handler));
        return bootstrap.connect(address).syncUninterruptibly().channel();
    }

    private static ChannelHandler newServerHandler(final SslContext context, final byte[] response, final ChannelHandler handler) {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                SslHandler sslHandler = context.newHandler(ch.alloc());
                if (response != null) {
                    ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                    engine.setOcspResponse(response);
                }
                pipeline.addLast(new ChannelHandler[]{sslHandler});
                if (handler != null) {
                    pipeline.addLast(new ChannelHandler[]{handler});
                }
            }
        };
    }

    private static ChannelHandler newClientHandler(final SslContext context, final OcspClientCallback callback, final ChannelHandler handler) {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                SslHandler sslHandler = context.newHandler(ch.alloc());
                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                pipeline.addLast(new ChannelHandler[]{sslHandler});
                pipeline.addLast(new ChannelHandler[]{new OcspClientCallbackHandler(engine, callback)});
                if (handler != null) {
                    pipeline.addLast(new ChannelHandler[]{handler});
                }
            }
        };
    }

    private static byte[] newOcspResponse() {
        return "I am a bogus OCSP staple. OpenSSL does not care about the format of the byte[]!".getBytes(CharsetUtil.US_ASCII);
    }

    private static final class OcspTestException
    extends IllegalStateException {
        private static final long serialVersionUID = 4516426833250228159L;

        OcspTestException(String message) {
            super(message);
        }
    }

    private static final class OcspClientCallbackHandler
    extends OcspClientHandler {
        private final OcspClientCallback callback;

        OcspClientCallbackHandler(ReferenceCountedOpenSslEngine engine, OcspClientCallback callback) {
            super(engine);
            this.callback = callback;
        }

        protected boolean verify(ChannelHandlerContext ctx, ReferenceCountedOpenSslEngine engine) throws Exception {
            byte[] response = engine.getOcspResponse();
            return this.callback.verify(response);
        }
    }

    private static final class TestClientOcspContext
    implements OcspClientCallback {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final boolean valid;
        private volatile byte[] response;

        TestClientOcspContext(boolean valid) {
            this.valid = valid;
        }

        public byte[] response() throws InterruptedException, TimeoutException {
            Assertions.assertTrue((boolean)this.latch.await(10L, TimeUnit.SECONDS));
            return this.response;
        }

        @Override
        public boolean verify(byte[] response) throws Exception {
            this.response = response;
            this.latch.countDown();
            return this.valid;
        }
    }

    private static interface OcspClientCallback {
        public boolean verify(byte[] var1) throws Exception;
    }
}

