/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util;

import java.util.ArrayDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.util.AbstractReferenceCounted;
import org.neo4j.driver.internal.shaded.io.netty.util.IllegalReferenceCountException;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCounted;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ThreadLocalRandom;

public class AbstractReferenceCountedTest {
    @Test
    public void testRetainOverflow() {
        final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        referenceCounted.setRefCnt(Integer.MAX_VALUE);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.retain();
            }
        });
    }

    @Test
    public void testRetainOverflow2() {
        final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        Assertions.assertEquals((int)1, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.retain(Integer.MAX_VALUE);
            }
        });
    }

    @Test
    public void testReleaseOverflow() {
        final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        referenceCounted.setRefCnt(0);
        Assertions.assertEquals((int)0, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.release(Integer.MAX_VALUE);
            }
        });
    }

    @Test
    public void testReleaseErrorMessage() {
        AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        Assertions.assertTrue((boolean)referenceCounted.release());
        try {
            referenceCounted.release(1);
            Assertions.fail((String)"IllegalReferenceCountException didn't occur");
        }
        catch (IllegalReferenceCountException e) {
            Assertions.assertEquals((Object)"refCnt: 0, decrement: 1", (Object)e.getMessage());
        }
    }

    @Test
    public void testRetainResurrect() {
        final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        Assertions.assertTrue((boolean)referenceCounted.release());
        Assertions.assertEquals((int)0, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.retain();
            }
        });
    }

    @Test
    public void testRetainResurrect2() {
        final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        Assertions.assertTrue((boolean)referenceCounted.release());
        Assertions.assertEquals((int)0, (int)referenceCounted.refCnt());
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                referenceCounted.retain(2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testRetainFromMultipleThreadsThrowsReferenceCountException() throws Exception {
        int threads = 4;
        ArrayDeque futures = new ArrayDeque(threads);
        ExecutorService service = Executors.newFixedThreadPool(threads);
        final AtomicInteger refCountExceptions = new AtomicInteger();
        try {
            for (int i = 0; i < 10000; ++i) {
                Future f;
                final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
                final CountDownLatch retainLatch = new CountDownLatch(1);
                Assertions.assertTrue((boolean)referenceCounted.release());
                for (int a = 0; a < threads; ++a) {
                    final int retainCnt = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
                    futures.add(service.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                retainLatch.await();
                                try {
                                    referenceCounted.retain(retainCnt);
                                }
                                catch (IllegalReferenceCountException e) {
                                    refCountExceptions.incrementAndGet();
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }));
                }
                retainLatch.countDown();
                while ((f = (Future)futures.poll()) != null) {
                    f.get();
                }
                Assertions.assertEquals((int)4, (int)refCountExceptions.get());
                refCountExceptions.set(0);
            }
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testReleaseFromMultipleThreadsThrowsReferenceCountException() throws Exception {
        int threads = 4;
        ArrayDeque futures = new ArrayDeque(threads);
        ExecutorService service = Executors.newFixedThreadPool(threads);
        final AtomicInteger refCountExceptions = new AtomicInteger();
        try {
            for (int i = 0; i < 10000; ++i) {
                Future f;
                final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
                final CountDownLatch releaseLatch = new CountDownLatch(1);
                final AtomicInteger releasedCount = new AtomicInteger();
                for (int a = 0; a < threads; ++a) {
                    final AtomicInteger releaseCnt = new AtomicInteger(0);
                    futures.add(service.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                releaseLatch.await();
                                try {
                                    if (referenceCounted.release(releaseCnt.incrementAndGet())) {
                                        releasedCount.incrementAndGet();
                                    }
                                }
                                catch (IllegalReferenceCountException e) {
                                    refCountExceptions.incrementAndGet();
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }));
                }
                releaseLatch.countDown();
                while ((f = (Future)futures.poll()) != null) {
                    f.get();
                }
                Assertions.assertEquals((int)3, (int)refCountExceptions.get());
                Assertions.assertEquals((int)1, (int)releasedCount.get());
                refCountExceptions.set(0);
            }
        }
        finally {
            service.shutdown();
        }
    }

    private static AbstractReferenceCounted newReferenceCounted() {
        return new AbstractReferenceCounted(){

            protected void deallocate() {
            }

            public ReferenceCounted touch(Object hint) {
                return this;
            }
        };
    }
}

