/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.driver.internal.shaded.io.netty.util.Recycler;
import org.neo4j.driver.internal.shaded.io.netty.util.RecyclerTest;
import org.neo4j.driver.internal.shaded.io.netty.util.RunInFastThreadLocalThreadExtension;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.FastThreadLocalThread;

@ExtendWith(value={RunInFastThreadLocalThreadExtension.class})
public class RecyclerFastThreadLocalTest
extends RecyclerTest {
    @Override
    @NotNull
    protected Thread newThread(Runnable runnable) {
        return new FastThreadLocalThread(runnable);
    }

    @Override
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testThreadCanBeCollectedEvenIfHandledObjectIsReferenced() throws Exception {
        final Recycler<RecyclerTest.HandledObject> recycler = RecyclerFastThreadLocalTest.newRecycler(1024);
        final AtomicBoolean collected = new AtomicBoolean();
        final AtomicReference<Object> reference = new AtomicReference<Object>();
        FastThreadLocalThread thread = new FastThreadLocalThread(new Runnable(){

            @Override
            public void run() {
                RecyclerTest.HandledObject object = (RecyclerTest.HandledObject)recycler.get();
                reference.set(object);
            }
        }){

            protected void finalize() throws Throwable {
                super.finalize();
                collected.set(true);
            }
        };
        Assertions.assertFalse((boolean)collected.get());
        thread.start();
        thread.join();
        thread = null;
        while (!collected.get()) {
            System.gc();
            System.runFinalization();
            Thread.sleep(50L);
        }
        ((RecyclerTest.HandledObject)reference.getAndSet(null)).recycle();
    }
}

