/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.collection;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.util.collection.CharObjectHashMap;
import org.neo4j.driver.internal.shaded.io.netty.util.collection.CharObjectMap;

public class CharObjectHashMapTest {
    private CharObjectHashMap<Value> map;

    @BeforeEach
    public void setup() {
        this.map = new CharObjectHashMap();
    }

    @Test
    public void iteratorRemoveShouldNotNPE() {
        this.map = new CharObjectHashMap(4, 1.0f);
        this.map.put(Character.valueOf('\u0000'), (Object)new Value("A"));
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("B"));
        this.map.put(Character.valueOf('\u0004'), (Object)new Value("C"));
        this.map.remove((Object)Character.valueOf('\u0001'));
        Iterator itr = this.map.entries().iterator();
        while (itr.hasNext()) {
            CharObjectMap.PrimitiveEntry entry = (CharObjectMap.PrimitiveEntry)itr.next();
            Assertions.assertNotNull((Object)Character.valueOf(entry.key()));
            Assertions.assertNotNull((Object)entry.value());
            itr.remove();
        }
        Assertions.assertTrue((boolean)this.map.isEmpty());
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void putNewMappingShouldSucceed() {
        Value v = new Value("v");
        char key = '\u0001';
        Assertions.assertNull((Object)this.map.put(key, (Object)v));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey(key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
        Assertions.assertEquals((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void putNewMappingShouldSucceed_mapApi() {
        Value v = new Value("v");
        Character key = Character.valueOf('\u0001');
        Assertions.assertNull((Object)this.map.put(key, (Object)v));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
        Assertions.assertEquals((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldReplaceValue() {
        Value v1 = new Value("v1");
        char key = '\u0001';
        Assertions.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assertions.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey(key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assertions.assertEquals((Object)v2, (Object)this.map.get(key));
    }

    @Test
    public void putShouldReplaceValue_mapApi() {
        Value v1 = new Value("v1");
        Character key = Character.valueOf('\u0001');
        Assertions.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assertions.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.containsKey((Object)key));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assertions.assertEquals((Object)v2, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldGrowMap() {
        for (char key = '\u0000'; key < '\u00ff'; key = (char)(key + '\u0001')) {
            Value v = new Value(Character.toString(key));
            Assertions.assertNull((Object)this.map.put(key, (Object)v));
            Assertions.assertEquals((int)(key + '\u0001'), (int)this.map.size());
            Assertions.assertTrue((boolean)this.map.containsKey(key));
            Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
            Assertions.assertEquals((Object)v, (Object)this.map.get(key));
        }
    }

    @Test
    public void putShouldGrowMap_mapApi() {
        for (char key = '\u0000'; key < '\u00ff'; key = (char)(key + '\u0001')) {
            Character okey = Character.valueOf(key);
            Value v = new Value(Character.toString(key));
            Assertions.assertNull((Object)this.map.put(okey, (Object)v));
            Assertions.assertEquals((int)(key + '\u0001'), (int)this.map.size());
            Assertions.assertTrue((boolean)this.map.containsKey((Object)okey));
            Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
            Assertions.assertEquals((Object)v, (Object)this.map.get((Object)okey));
        }
    }

    @Test
    public void negativeKeyShouldSucceed() {
        Value v = new Value("v");
        this.map.put('\ufffd', (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)v, (Object)this.map.get('\ufffd'));
    }

    @Test
    public void negativeKeyShouldSucceed_mapApi() {
        Value v = new Value("v");
        this.map.put(Character.valueOf('\ufffd'), (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertEquals((Object)v, (Object)this.map.get((Object)Character.valueOf('\ufffd')));
    }

    @Test
    public void removeMissingValueShouldReturnNull() {
        Assertions.assertNull((Object)this.map.remove('\u0001'));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void removeMissingValueShouldReturnNull_mapApi() {
        Assertions.assertNull((Object)this.map.remove((Object)Character.valueOf('\u0001')));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void removeShouldReturnPreviousValue() {
        Value v = new Value("v");
        char key = '\u0001';
        this.map.put(key, (Object)v);
        Assertions.assertSame((Object)v, (Object)this.map.remove(key));
    }

    @Test
    public void removeShouldReturnPreviousValue_mapApi() {
        Value v = new Value("v");
        Character key = Character.valueOf('\u0001');
        this.map.put(key, (Object)v);
        Assertions.assertSame((Object)v, (Object)this.map.remove((Object)key));
    }

    @Test
    public void noFreeSlotsShouldRehash() {
        for (char i = '\u0000'; i < '\n'; i = (char)(i + '\u0001')) {
            this.map.put(i, (Object)new Value(Character.toString(i)));
            this.map.remove(i);
            Assertions.assertEquals((int)0, (int)this.map.size());
        }
        Value v = new Value("v");
        char key = '\u0001';
        this.map.put(key, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertSame((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void noFreeSlotsShouldRehash_mapApi() {
        for (char i = '\u0000'; i < '\n'; i = (char)(i + '\u0001')) {
            this.map.put(i, (Object)new Value(Character.toString(i)));
            this.map.remove((Object)Character.valueOf(i));
            Assertions.assertEquals((int)0, (int)this.map.size());
        }
        Value v = new Value("v");
        Character key = Character.valueOf('\u0001');
        this.map.put(key, (Object)v);
        Assertions.assertEquals((int)1, (int)this.map.size());
        Assertions.assertSame((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putAllShouldSucceed() {
        CharObjectHashMap other = new CharObjectHashMap();
        char k1 = '\u0001';
        char k2 = '\u0002';
        char k3 = '\u0003';
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get(k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get(k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get(k3));
    }

    @Test
    public void putAllShouldSucceed_mapApi() {
        CharObjectHashMap other = new CharObjectHashMap();
        Character k1 = Character.valueOf('\u0001');
        Character k2 = Character.valueOf('\u0002');
        Character k3 = Character.valueOf('\u0003');
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void putAllWithJavaMapShouldSucceed_mapApi() {
        HashMap<Character, Value> other = new HashMap<Character, Value>();
        Character k1 = Character.valueOf('\u0001');
        Character k2 = Character.valueOf('\u0002');
        Character k3 = Character.valueOf('\u0003');
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, v1);
        other.put(k2, v2);
        other.put(k3, v3);
        this.map.putAll(other);
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assertions.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assertions.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void clearShouldSucceed() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put('\u0001', (Object)v1);
        this.map.put('\u0002', (Object)v2);
        this.map.put('\u0003', (Object)v3);
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void containsValueShouldFindNull() {
        this.map.put('\u0001', (Object)new Value("v1"));
        this.map.put('\u0002', null);
        this.map.put('\u0003', (Object)new Value("v2"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindNull_mapApi() {
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("v1"));
        this.map.put(Character.valueOf('\u0002'), null);
        this.map.put(Character.valueOf('\u0003'), (Object)new Value("v2"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindInstance() {
        Value v = new Value("v1");
        this.map.put('\u0001', (Object)new Value("v2"));
        this.map.put('\u0002', (Object)new Value("v3"));
        this.map.put('\u0003', (Object)v);
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindInstance_mapApi() {
        Value v = new Value("v1");
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("v2"));
        this.map.put(Character.valueOf('\u0002'), (Object)new Value("v3"));
        this.map.put(Character.valueOf('\u0003'), (Object)v);
        Assertions.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindEquivalentValue() {
        this.map.put('\u0001', (Object)new Value("v1"));
        this.map.put('\u0002', (Object)new Value("v2"));
        this.map.put('\u0003', (Object)new Value("v3"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueShouldFindEquivalentValue_mapApi() {
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("v1"));
        this.map.put(Character.valueOf('\u0002'), (Object)new Value("v2"));
        this.map.put(Character.valueOf('\u0003'), (Object)new Value("v3"));
        Assertions.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueNotFindMissingValue() {
        this.map.put('\u0001', (Object)new Value("v1"));
        this.map.put('\u0002', (Object)new Value("v2"));
        this.map.put('\u0003', (Object)new Value("v3"));
        Assertions.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void containsValueNotFindMissingValue_mapApi() {
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("v1"));
        this.map.put(Character.valueOf('\u0002'), (Object)new Value("v2"));
        this.map.put(Character.valueOf('\u0003'), (Object)new Value("v3"));
        Assertions.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void iteratorShouldTraverseEntries() {
        char k1 = '\u0001';
        char k2 = '\u0002';
        char k3 = '\u0003';
        char k4 = '\u0004';
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet found = new HashSet();
        for (Map.Entry entry : this.map.entrySet()) {
            Assertions.assertTrue((boolean)found.add(entry.getKey()));
        }
        Assertions.assertEquals((int)3, (int)found.size());
        Assertions.assertTrue((boolean)found.contains(Character.valueOf(k1)));
        Assertions.assertTrue((boolean)found.contains(Character.valueOf(k2)));
        Assertions.assertTrue((boolean)found.contains(Character.valueOf(k3)));
    }

    @Test
    public void keysShouldBeReturned() {
        char k1 = '\u0001';
        char k2 = '\u0002';
        char k3 = '\u0003';
        char k4 = '\u0004';
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        Set keys = this.map.keySet();
        Assertions.assertEquals((int)3, (int)keys.size());
        HashSet<Character> expected = new HashSet<Character>();
        expected.add(Character.valueOf(k1));
        expected.add(Character.valueOf(k2));
        expected.add(Character.valueOf(k3));
        HashSet<Character> found = new HashSet<Character>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            char key = ((Character)iterator.next()).charValue();
            Assertions.assertTrue((boolean)found.add(Character.valueOf(key)));
        }
        Assertions.assertEquals(expected, found);
    }

    @Test
    public void valuesShouldBeReturned() {
        char k1 = '\u0001';
        char k2 = '\u0002';
        char k3 = '\u0003';
        char k4 = '\u0004';
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(k1, (Object)v1);
        this.map.put(k2, (Object)v2);
        this.map.put(k3, (Object)v3);
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet<Value> expected = new HashSet<Value>();
        expected.add(v1);
        expected.add(v2);
        expected.add(v3);
        HashSet actual = new HashSet(this.map.values());
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void mapShouldSupportHashingConflicts() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                CharObjectHashMap map = new CharObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put((char)(i * mod), (Object)"");
                }
            }
        }
    }

    @Test
    public void mapShouldSupportHashingConflicts_mapApi() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                CharObjectHashMap map = new CharObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put(Character.valueOf((char)(i * mod)), (Object)"");
                }
            }
        }
    }

    @Test
    public void hashcodeEqualsTest() {
        CharObjectHashMap map1 = new CharObjectHashMap();
        CharObjectHashMap map2 = new CharObjectHashMap();
        Random rnd = new Random(0L);
        while (map1.size() < 100) {
            char key = (char)rnd.nextInt(100);
            map1.put(key, (Object)Character.valueOf(key));
            map2.put(key, (Object)Character.valueOf(key));
        }
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
        Set keys = map1.keySet();
        Character removed = null;
        Iterator iter = keys.iterator();
        for (int ix = 0; iter.hasNext() && ix < 50; ++ix) {
            removed = (Character)iter.next();
        }
        map2.remove(removed);
        Assertions.assertFalse((boolean)map1.equals((Object)map2));
        map2.put(removed, (Object)removed);
        Assertions.assertEquals((Object)map1, (Object)map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put('d', (Object)Character.valueOf('d'));
        Assertions.assertFalse((boolean)map1.equals((Object)map2));
        map2.clear();
        for (Character key : map1.keySet()) {
            map2.put(key, (Object)key);
        }
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
    }

    @Test
    public void fuzzTest() {
        char key;
        int i;
        Random rnd = new Random(0L);
        int baseSize = 1000;
        int startTableSize = 1105;
        CharObjectHashMap map = new CharObjectHashMap(startTableSize);
        HashMap<Character, Character> goodMap = new HashMap<Character, Character>();
        for (i = 0; i < baseSize / 4; ++i) {
            key = (char)rnd.nextInt(baseSize);
            Assertions.assertEquals((Character)goodMap.put(Character.valueOf(key), Character.valueOf(key)), (Character)((Character)map.put(key, (Object)Character.valueOf(key))));
            key = (char)(rnd.nextInt(baseSize) * 17);
            Assertions.assertEquals((Character)goodMap.put(Character.valueOf(key), Character.valueOf(key)), (Character)((Character)map.put(key, (Object)Character.valueOf(key))));
        }
        for (i = 0; i < baseSize * 1000; ++i) {
            key = (char)rnd.nextInt(baseSize);
            if (rnd.nextDouble() >= 0.2) {
                Assertions.assertEquals((Character)goodMap.put(Character.valueOf(key), Character.valueOf(key)), (Character)((Character)map.put(key, (Object)Character.valueOf(key))));
                continue;
            }
            Assertions.assertEquals((Character)((Character)goodMap.remove(Character.valueOf(key))), (Character)((Character)map.remove(key)));
        }
        int removeSize = map.size() / 2;
        while (removeSize > 0) {
            key = (char)rnd.nextInt(baseSize);
            boolean found = goodMap.containsKey(Character.valueOf(key));
            Assertions.assertEquals((Object)found, (Object)map.containsKey(key));
            Assertions.assertEquals((Character)((Character)goodMap.remove(Character.valueOf(key))), (Character)((Character)map.remove(key)));
            if (!found) continue;
            --removeSize;
        }
        Assertions.assertEquals((int)goodMap.size(), (int)map.size());
        Object[] goodKeys = goodMap.keySet().toArray(new Character[goodMap.size()]);
        Arrays.sort(goodKeys);
        Object[] keys = map.keySet().toArray(new Character[map.size()]);
        Arrays.sort(keys);
        for (int i2 = 0; i2 < goodKeys.length; ++i2) {
            Assertions.assertEquals((Character)goodKeys[i2], (Character)keys[i2]);
        }
        Object[] objectArray = keys;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            char key2 = ((Character)objectArray[j]).charValue();
            Assertions.assertEquals((Character)((Character)goodMap.remove(Character.valueOf(key2))), (Character)((Character)map.remove(key2)));
        }
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void valuesIteratorRemove() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put('\u0001', (Object)v1);
        this.map.put('\u0002', (Object)v2);
        this.map.put('\u0003', (Object)v3);
        Iterator it = this.map.values().iterator();
        Assertions.assertSame((Object)v1, it.next());
        Assertions.assertSame((Object)v2, it.next());
        it.remove();
        Assertions.assertSame((Object)v3, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertSame((Object)v1, (Object)this.map.get('\u0001'));
        Assertions.assertNull((Object)this.map.get('\u0002'));
        Assertions.assertSame((Object)v3, (Object)this.map.get('\u0003'));
        it = this.map.values().iterator();
        Assertions.assertSame((Object)v1, it.next());
        Assertions.assertSame((Object)v3, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    private static class Value {
        private final String name;

        Value(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

