/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.internal;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.StringUtil;

public class StringUtilTest {
    @Test
    public void ensureNewlineExists() {
        Assertions.assertNotNull((Object)StringUtil.NEWLINE);
    }

    @Test
    public void testToHexString() {
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])new byte[]{0}), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])new byte[]{1}), (Matcher)CoreMatchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])new byte[]{0, 0}), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])new byte[]{1, 0}), (Matcher)CoreMatchers.is((Object)"100"));
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])EmptyArrays.EMPTY_BYTES), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testToHexStringPadded() {
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])new byte[]{0}), (Matcher)CoreMatchers.is((Object)"00"));
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])new byte[]{1}), (Matcher)CoreMatchers.is((Object)"01"));
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])new byte[]{0, 0}), (Matcher)CoreMatchers.is((Object)"0000"));
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])new byte[]{1, 0}), (Matcher)CoreMatchers.is((Object)"0100"));
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])EmptyArrays.EMPTY_BYTES), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void splitSimple() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo:bar".split(":"));
    }

    @Test
    public void splitWithTrailingDelimiter() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo,bar,".split(","));
    }

    @Test
    public void splitWithTrailingDelimiters() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo!bar!!".split("!"));
    }

    @Test
    public void splitWithTrailingDelimitersDot() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo.bar..".split("\\."));
    }

    @Test
    public void splitWithTrailingDelimitersEq() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo=bar==".split("="));
    }

    @Test
    public void splitWithTrailingDelimitersSpace() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo bar  ".split(" "));
    }

    @Test
    public void splitWithConsecutiveDelimiters() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "", "bar"}, (Object[])"foo$$bar".split("\\$"));
    }

    @Test
    public void splitWithDelimiterAtBeginning() {
        Assertions.assertArrayEquals((Object[])new String[]{"", "foo", "bar"}, (Object[])"#foo#bar".split("#"));
    }

    @Test
    public void splitMaxPart() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "bar:bar2"}, (Object[])"foo:bar:bar2".split(":", 2));
        Assertions.assertArrayEquals((Object[])new String[]{"foo", "bar", "bar2"}, (Object[])"foo:bar:bar2".split(":", 3));
    }

    @Test
    public void substringAfterTest() {
        Assertions.assertEquals((Object)"bar:bar2", (Object)StringUtil.substringAfter((String)"foo:bar:bar2", (char)':'));
    }

    @Test
    public void commonSuffixOfLengthTest() {
        StringUtilTest.checkNotCommonSuffix("abc", "abc", -1);
        StringUtilTest.checkNotCommonSuffix("abc", null, 0);
        StringUtilTest.checkNotCommonSuffix(null, null, 0);
        StringUtilTest.checkCommonSuffix("abc", "xx", 0);
        StringUtilTest.checkCommonSuffix("abc", "abc", 0);
        StringUtilTest.checkCommonSuffix("abc", "abc", 1);
        StringUtilTest.checkCommonSuffix("abc", "abc", 2);
        StringUtilTest.checkCommonSuffix("abc", "abc", 3);
        StringUtilTest.checkNotCommonSuffix("abc", "abc", 4);
        StringUtilTest.checkCommonSuffix("abcd", "cd", 1);
        StringUtilTest.checkCommonSuffix("abcd", "cd", 2);
        StringUtilTest.checkNotCommonSuffix("abcd", "cd", 3);
        StringUtilTest.checkCommonSuffix("abcd", "axcd", 1);
        StringUtilTest.checkCommonSuffix("abcd", "axcd", 2);
        StringUtilTest.checkNotCommonSuffix("abcd", "axcd", 3);
        StringUtilTest.checkNotCommonSuffix("abcx", "abcy", 1);
    }

    private static void checkNotCommonSuffix(String s, String p, int len) {
        Assertions.assertFalse((boolean)StringUtilTest.checkCommonSuffixSymmetric(s, p, len));
    }

    private static void checkCommonSuffix(String s, String p, int len) {
        Assertions.assertTrue((boolean)StringUtilTest.checkCommonSuffixSymmetric(s, p, len));
    }

    private static boolean checkCommonSuffixSymmetric(String s, String p, int len) {
        boolean sp = StringUtil.commonSuffixOfLength((String)s, (String)p, (int)len);
        boolean ps = StringUtil.commonSuffixOfLength((String)p, (String)s, (int)len);
        Assertions.assertEquals((Object)sp, (Object)ps);
        return sp;
    }

    @Test
    public void escapeCsvNull() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.escapeCsv(null);
            }
        });
    }

    @Test
    public void escapeCsvEmpty() {
        String value = "";
        StringUtilTest.escapeCsv(value, value);
    }

    @Test
    public void escapeCsvUnquoted() {
        String value = "something";
        StringUtilTest.escapeCsv(value, value);
    }

    @Test
    public void escapeCsvAlreadyQuoted() {
        String value = "\"something\"";
        String expected = "\"something\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuote() {
        String value = "s\"";
        String expected = "\"s\"\"\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuoteInMiddle() {
        String value = "some text\"and more text";
        String expected = "\"some text\"\"and more text\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuoteInMiddleAlreadyQuoted() {
        String value = "\"some text\"and more text\"";
        String expected = "\"some text\"\"and more text\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuotedWords() {
        String value = "\"foo\"\"goo\"";
        String expected = "\"foo\"\"goo\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithAlreadyEscapedQuote() {
        String value = "foo\"\"goo";
        String expected = "foo\"\"goo";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvEndingWithQuote() {
        String value = "some\"";
        String expected = "\"some\"\"\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleQuote() {
        String value = "\"";
        String expected = "\"\"\"\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleQuoteAndCharacter() {
        String value = "\"f";
        String expected = "\"\"\"f\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvAlreadyEscapedQuote() {
        String value = "\"some\"\"";
        String expected = "\"some\"\"\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvQuoted() {
        String value = "\"foo,goo\"";
        StringUtilTest.escapeCsv(value, value);
    }

    @Test
    public void escapeCsvWithLineFeed() {
        String value = "some text\n more text";
        String expected = "\"some text\n more text\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleLineFeedCharacter() {
        String value = "\n";
        String expected = "\"\n\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithMultipleLineFeedCharacter() {
        String value = "\n\n";
        String expected = "\"\n\n\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuotedAndLineFeedCharacter() {
        String value = " \" \n ";
        String expected = "\" \"\" \n \"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithLineFeedAtEnd() {
        String value = "testing\n";
        String expected = "\"testing\n\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithComma() {
        String value = "test,ing";
        String expected = "\"test,ing\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleComma() {
        String value = ",";
        String expected = "\",\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleCarriageReturn() {
        String value = "\r";
        String expected = "\"\r\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithMultipleCarriageReturn() {
        String value = "\r\r";
        String expected = "\"\r\r\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithCarriageReturn() {
        String value = "some text\r more text";
        String expected = "\"some text\r more text\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuotedAndCarriageReturnCharacter() {
        String value = "\"\r";
        String expected = "\"\"\"\r\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithCarriageReturnAtEnd() {
        String value = "testing\r";
        String expected = "\"testing\r\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithCRLFCharacter() {
        String value = "\r\n";
        String expected = "\"\r\n\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    private static void escapeCsv(CharSequence value, CharSequence expected) {
        StringUtilTest.escapeCsv(value, expected, false);
    }

    private static void escapeCsvWithTrimming(CharSequence value, CharSequence expected) {
        StringUtilTest.escapeCsv(value, expected, true);
    }

    private static void escapeCsv(CharSequence value, CharSequence expected, boolean trimOws) {
        CharSequence escapedValue = value;
        for (int i = 0; i < 10; ++i) {
            escapedValue = StringUtil.escapeCsv((CharSequence)escapedValue, (boolean)trimOws);
            Assertions.assertEquals((Object)expected, (Object)escapedValue.toString());
        }
    }

    @Test
    public void escapeCsvWithTrimming() {
        Assertions.assertSame((Object)"", (Object)StringUtil.escapeCsv((CharSequence)"", (boolean)true));
        Assertions.assertSame((Object)"ab", (Object)StringUtil.escapeCsv((CharSequence)"ab", (boolean)true));
        StringUtilTest.escapeCsvWithTrimming("", "");
        StringUtilTest.escapeCsvWithTrimming(" \t ", "");
        StringUtilTest.escapeCsvWithTrimming("ab", "ab");
        StringUtilTest.escapeCsvWithTrimming("a b", "a b");
        StringUtilTest.escapeCsvWithTrimming(" \ta \tb", "a \tb");
        StringUtilTest.escapeCsvWithTrimming("a \tb \t", "a \tb");
        StringUtilTest.escapeCsvWithTrimming("\t a \tb \t", "a \tb");
        StringUtilTest.escapeCsvWithTrimming("\"\t a b \"", "\"\t a b \"");
        StringUtilTest.escapeCsvWithTrimming(" \"\t a b \"\t", "\"\t a b \"");
        StringUtilTest.escapeCsvWithTrimming(" testing\t\n ", "\"testing\t\n\"");
        StringUtilTest.escapeCsvWithTrimming("\ttest,ing ", "\"test,ing\"");
    }

    @Test
    public void escapeCsvGarbageFree() {
        Assertions.assertSame((Object)"1", (Object)StringUtil.escapeCsv((CharSequence)"1", (boolean)true));
        Assertions.assertSame((Object)" 123 ", (Object)StringUtil.escapeCsv((CharSequence)" 123 ", (boolean)false));
        Assertions.assertSame((Object)"\" 123 \"", (Object)StringUtil.escapeCsv((CharSequence)"\" 123 \"", (boolean)true));
        Assertions.assertSame((Object)"\"\"", (Object)StringUtil.escapeCsv((CharSequence)"\"\"", (boolean)true));
        Assertions.assertSame((Object)"123 \"\"", (Object)StringUtil.escapeCsv((CharSequence)"123 \"\"", (boolean)true));
        Assertions.assertSame((Object)"123\"\"321", (Object)StringUtil.escapeCsv((CharSequence)"123\"\"321", (boolean)true));
        Assertions.assertSame((Object)"\"123\"\"321\"", (Object)StringUtil.escapeCsv((CharSequence)"\"123\"\"321\"", (boolean)true));
    }

    @Test
    public void testUnescapeCsv() {
        Assertions.assertEquals((Object)"", (Object)StringUtil.unescapeCsv((CharSequence)""));
        Assertions.assertEquals((Object)"\"", (Object)StringUtil.unescapeCsv((CharSequence)"\"\"\"\""));
        Assertions.assertEquals((Object)"\"\"", (Object)StringUtil.unescapeCsv((CharSequence)"\"\"\"\"\"\""));
        Assertions.assertEquals((Object)"\"\"\"", (Object)StringUtil.unescapeCsv((CharSequence)"\"\"\"\"\"\"\"\""));
        Assertions.assertEquals((Object)"\"netty\"", (Object)StringUtil.unescapeCsv((CharSequence)"\"\"\"netty\"\"\""));
        Assertions.assertEquals((Object)"netty", (Object)StringUtil.unescapeCsv((CharSequence)"netty"));
        Assertions.assertEquals((Object)"netty", (Object)StringUtil.unescapeCsv((CharSequence)"\"netty\""));
        Assertions.assertEquals((Object)"\r", (Object)StringUtil.unescapeCsv((CharSequence)"\"\r\""));
        Assertions.assertEquals((Object)"\n", (Object)StringUtil.unescapeCsv((CharSequence)"\"\n\""));
        Assertions.assertEquals((Object)"hello,netty", (Object)StringUtil.unescapeCsv((CharSequence)"\"hello,netty\""));
    }

    @Test
    public void unescapeCsvWithSingleQuote() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsv((CharSequence)"\"");
            }
        });
    }

    @Test
    public void unescapeCsvWithOddQuote() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsv((CharSequence)"\"\"\"");
            }
        });
    }

    @Test
    public void unescapeCsvWithCRAndWithoutQuote() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsv((CharSequence)"\r");
            }
        });
    }

    @Test
    public void unescapeCsvWithLFAndWithoutQuote() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsv((CharSequence)"\n");
            }
        });
    }

    @Test
    public void unescapeCsvWithCommaAndWithoutQuote() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsv((CharSequence)",");
            }
        });
    }

    @Test
    public void escapeCsvAndUnEscapeCsv() {
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("netty");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("hello,netty");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("hello,\"netty\"");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("\"");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv(",");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("\r");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("\n");
    }

    private static void assertEscapeCsvAndUnEscapeCsv(String value) {
        Assertions.assertEquals((Object)value, (Object)StringUtil.unescapeCsv((CharSequence)StringUtil.escapeCsv((CharSequence)value)));
    }

    @Test
    public void testUnescapeCsvFields() {
        Assertions.assertEquals(Collections.singletonList(""), (Object)StringUtil.unescapeCsvFields((CharSequence)""));
        Assertions.assertEquals(Arrays.asList("", ""), (Object)StringUtil.unescapeCsvFields((CharSequence)","));
        Assertions.assertEquals(Arrays.asList("a", ""), (Object)StringUtil.unescapeCsvFields((CharSequence)"a,"));
        Assertions.assertEquals(Arrays.asList("", "a"), (Object)StringUtil.unescapeCsvFields((CharSequence)",a"));
        Assertions.assertEquals(Collections.singletonList("\""), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"\"\"\""));
        Assertions.assertEquals(Arrays.asList("\"", "\""), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"\"\"\",\"\"\"\""));
        Assertions.assertEquals(Collections.singletonList("netty"), (Object)StringUtil.unescapeCsvFields((CharSequence)"netty"));
        Assertions.assertEquals(Arrays.asList("hello", "netty"), (Object)StringUtil.unescapeCsvFields((CharSequence)"hello,netty"));
        Assertions.assertEquals(Collections.singletonList("hello,netty"), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"hello,netty\""));
        Assertions.assertEquals(Arrays.asList("hello", "netty"), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"hello\",\"netty\""));
        Assertions.assertEquals(Arrays.asList("a\"b", "c\"d"), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"a\"\"b\",\"c\"\"d\""));
        Assertions.assertEquals(Arrays.asList("a\rb", "c\nd"), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"a\rb\",\"c\nd\""));
    }

    @Test
    public void unescapeCsvFieldsWithCRWithoutQuote() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsvFields((CharSequence)"a,\r");
            }
        });
    }

    @Test
    public void unescapeCsvFieldsWithLFWithoutQuote() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsvFields((CharSequence)"a,\r");
            }
        });
    }

    @Test
    public void unescapeCsvFieldsWithQuote() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsvFields((CharSequence)"a,\"");
            }
        });
    }

    @Test
    public void unescapeCsvFieldsWithQuote2() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsvFields((CharSequence)"\",a");
            }
        });
    }

    @Test
    public void unescapeCsvFieldsWithQuote3() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                StringUtil.unescapeCsvFields((CharSequence)"a\"b,a");
            }
        });
    }

    @Test
    public void testSimpleClassName() throws Exception {
        StringUtilTest.testSimpleClassName(String.class);
    }

    @Test
    public void testSimpleInnerClassName() throws Exception {
        StringUtilTest.testSimpleClassName(TestClass.class);
    }

    private static void testSimpleClassName(Class<?> clazz) throws Exception {
        Package pkg = clazz.getPackage();
        String name = pkg != null ? clazz.getName().substring(pkg.getName().length() + 1) : clazz.getName();
        Assertions.assertEquals((Object)name, (Object)StringUtil.simpleClassName(clazz));
    }

    @Test
    public void testEndsWith() {
        Assertions.assertFalse((boolean)StringUtil.endsWith((CharSequence)"", (char)'u'));
        Assertions.assertTrue((boolean)StringUtil.endsWith((CharSequence)"u", (char)'u'));
        Assertions.assertTrue((boolean)StringUtil.endsWith((CharSequence)"-u", (char)'u'));
        Assertions.assertFalse((boolean)StringUtil.endsWith((CharSequence)"-", (char)'u'));
        Assertions.assertFalse((boolean)StringUtil.endsWith((CharSequence)"u-", (char)'u'));
    }

    @Test
    public void trimOws() {
        Assertions.assertSame((Object)"", (Object)StringUtil.trimOws((CharSequence)""));
        Assertions.assertEquals((Object)"", (Object)StringUtil.trimOws((CharSequence)" \t "));
        Assertions.assertSame((Object)"a", (Object)StringUtil.trimOws((CharSequence)"a"));
        Assertions.assertEquals((Object)"a", (Object)StringUtil.trimOws((CharSequence)" a"));
        Assertions.assertEquals((Object)"a", (Object)StringUtil.trimOws((CharSequence)"a "));
        Assertions.assertEquals((Object)"a", (Object)StringUtil.trimOws((CharSequence)" a "));
        Assertions.assertSame((Object)"abc", (Object)StringUtil.trimOws((CharSequence)"abc"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtil.trimOws((CharSequence)"\tabc"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtil.trimOws((CharSequence)"abc\t"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtil.trimOws((CharSequence)"\tabc\t"));
        Assertions.assertSame((Object)"a\t b", (Object)StringUtil.trimOws((CharSequence)"a\t b"));
        Assertions.assertEquals((Object)"", (Object)StringUtil.trimOws((CharSequence)"\t ").toString());
        Assertions.assertEquals((Object)"a b", (Object)StringUtil.trimOws((CharSequence)"\ta b \t").toString());
    }

    @Test
    public void testJoin() {
        Assertions.assertEquals((Object)"", (Object)StringUtil.join((CharSequence)",", Collections.emptyList()).toString());
        Assertions.assertEquals((Object)"a", (Object)StringUtil.join((CharSequence)",", Collections.singletonList("a")).toString());
        Assertions.assertEquals((Object)"a,b", (Object)StringUtil.join((CharSequence)",", Arrays.asList("a", "b")).toString());
        Assertions.assertEquals((Object)"a,b,c", (Object)StringUtil.join((CharSequence)",", Arrays.asList("a", "b", "c")).toString());
        Assertions.assertEquals((Object)"a,b,c,null,d", (Object)StringUtil.join((CharSequence)",", Arrays.asList("a", "b", "c", null, "d")).toString());
    }

    @Test
    public void testIsNullOrEmpty() {
        Assertions.assertTrue((boolean)StringUtil.isNullOrEmpty(null));
        Assertions.assertTrue((boolean)StringUtil.isNullOrEmpty((String)""));
        Assertions.assertTrue((boolean)StringUtil.isNullOrEmpty((String)""));
        Assertions.assertFalse((boolean)StringUtil.isNullOrEmpty((String)" "));
        Assertions.assertFalse((boolean)StringUtil.isNullOrEmpty((String)"\t"));
        Assertions.assertFalse((boolean)StringUtil.isNullOrEmpty((String)"\n"));
        Assertions.assertFalse((boolean)StringUtil.isNullOrEmpty((String)"foo"));
        Assertions.assertFalse((boolean)StringUtil.isNullOrEmpty((String)StringUtil.NEWLINE));
    }

    @Test
    public void testIndexOfWhiteSpace() {
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfWhiteSpace((CharSequence)"", (int)0));
        Assertions.assertEquals((int)0, (int)StringUtil.indexOfWhiteSpace((CharSequence)" ", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfWhiteSpace((CharSequence)" ", (int)1));
        Assertions.assertEquals((int)0, (int)StringUtil.indexOfWhiteSpace((CharSequence)"\n", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfWhiteSpace((CharSequence)"\n", (int)1));
        Assertions.assertEquals((int)0, (int)StringUtil.indexOfWhiteSpace((CharSequence)"\t", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfWhiteSpace((CharSequence)"\t", (int)1));
        Assertions.assertEquals((int)3, (int)StringUtil.indexOfWhiteSpace((CharSequence)"foo\r\nbar", (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfWhiteSpace((CharSequence)"foo\r\nbar", (int)10));
        Assertions.assertEquals((int)7, (int)StringUtil.indexOfWhiteSpace((CharSequence)"foo\tbar\r\n", (int)6));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfWhiteSpace((CharSequence)"foo\tbar\r\n", (int)Integer.MAX_VALUE));
    }

    @Test
    public void testIndexOfNonWhiteSpace() {
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)" ", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)" \t", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)" \t\r\n", (int)0));
        Assertions.assertEquals((int)2, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)0));
        Assertions.assertEquals((int)2, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)1));
        Assertions.assertEquals((int)4, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)4));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)10));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)Integer.MAX_VALUE));
    }

    private static final class TestClass {
        private TestClass() {
        }
    }
}

