/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PooledByteBuf;

public abstract class AbstractPooledByteBufTest
extends AbstractByteBufTest {
    protected abstract ByteBuf alloc(int var1, int var2);

    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        ByteBuf buffer = this.alloc(length, maxCapacity);
        Assertions.assertEquals((int)0, (int)buffer.writerIndex());
        Assertions.assertEquals((int)0, (int)buffer.readerIndex());
        buffer.resetReaderIndex();
        buffer.resetWriterIndex();
        Assertions.assertEquals((int)0, (int)buffer.writerIndex());
        Assertions.assertEquals((int)0, (int)buffer.readerIndex());
        return buffer;
    }

    @Test
    public void ensureWritableWithEnoughSpaceShouldNotThrow() {
        ByteBuf buf = this.newBuffer(1, 10);
        buf.ensureWritable(3);
        MatcherAssert.assertThat((Object)buf.writableBytes(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3))));
        buf.release();
    }

    @Test
    public void ensureWritableWithNotEnoughSpaceShouldThrow() {
        final ByteBuf buf = this.newBuffer(1, 10);
        try {
            Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() {
                    buf.ensureWritable(11);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Override
    @Test
    public void testMaxFastWritableBytes() {
        ByteBuf buffer = this.newBuffer(150, 500).writerIndex(100);
        Assertions.assertEquals((int)50, (int)buffer.writableBytes());
        Assertions.assertEquals((int)150, (int)buffer.capacity());
        Assertions.assertEquals((int)500, (int)buffer.maxCapacity());
        Assertions.assertEquals((int)400, (int)buffer.maxWritableBytes());
        int chunkSize = AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).maxLength;
        Assertions.assertTrue((chunkSize >= 150 ? 1 : 0) != 0);
        int remainingInAlloc = Math.min(chunkSize - 100, 400);
        Assertions.assertEquals((int)remainingInAlloc, (int)buffer.maxFastWritableBytes());
        long handleBefore = AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle;
        buffer.writeBytes(new byte[remainingInAlloc]);
        Assertions.assertEquals((long)handleBefore, (long)AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle);
        Assertions.assertEquals((int)0, (int)buffer.maxFastWritableBytes());
        buffer.writeByte(7);
        Assertions.assertNotEquals((long)handleBefore, (long)AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle);
        buffer.capacity(500);
        Assertions.assertEquals((int)(500 - buffer.writerIndex()), (int)buffer.maxFastWritableBytes());
        buffer.release();
    }

    private static PooledByteBuf<?> pooledByteBuf(ByteBuf buffer) {
        while (!(buffer instanceof PooledByteBuf)) {
            buffer = buffer.unwrap();
        }
        return (PooledByteBuf)buffer;
    }

    @Test
    public void testEnsureWritableDoesntGrowTooMuch() {
        ByteBuf buffer = this.newBuffer(150, 500).writerIndex(100);
        Assertions.assertEquals((int)50, (int)buffer.writableBytes());
        int fastWritable = buffer.maxFastWritableBytes();
        Assertions.assertTrue((fastWritable > 50 ? 1 : 0) != 0);
        long handleBefore = AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle;
        buffer.ensureWritable(fastWritable);
        Assertions.assertEquals((long)handleBefore, (long)AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle);
        Assertions.assertEquals((int)(100 + fastWritable), (int)buffer.capacity());
        Assertions.assertEquals((int)buffer.writableBytes(), (int)buffer.maxFastWritableBytes());
        buffer.release();
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assertions.assertTrue((boolean)buf.isContiguous());
        buf.release();
    }

    @Test
    public void distinctBuffersMustNotOverlap() {
        ByteBuf a = this.newBuffer(16384);
        ByteBuf b = this.newBuffer(65536);
        a.setByte(a.capacity() - 1, 1);
        b.setByte(0, 2);
        try {
            Assertions.assertEquals((int)1, (int)a.getByte(a.capacity() - 1));
        }
        finally {
            a.release();
            b.release();
        }
    }
}

