/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AdaptivePoolingAllocator;

class AdaptivePoolingAllocatorTest
implements Supplier<String> {
    private int i;

    AdaptivePoolingAllocatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.i = 0;
    }

    @Override
    public String get() {
        return "i = " + this.i;
    }

    @Test
    void sizeBucketComputations() throws Exception {
        this.assertSizeBucket(0, 8192);
        this.assertSizeBucket(1, 16384);
        this.assertSizeBucket(2, 32768);
        this.assertSizeBucket(3, 65536);
        this.assertSizeBucket(4, 131072);
        this.assertSizeBucket(5, 262144);
        this.assertSizeBucket(6, 524288);
        this.assertSizeBucket(7, 0x100000);
        this.assertSizeBucket(7, 0x200000);
        this.assertSizeBucket(7, 0x300000);
        this.assertSizeBucket(7, 0x400000);
        this.assertSizeBucket(7, 0x500000);
        this.assertSizeBucket(7, 0x600000);
        this.assertSizeBucket(7, 0x700000);
        this.assertSizeBucket(7, 0x800000);
        this.assertSizeBucket(7, 0x900000);
        this.assertSizeBucket(7, 0xA00000);
    }

    private void assertSizeBucket(int expectedSizeBucket, int maxSizeIncluded) {
        while (this.i <= maxSizeIncluded) {
            Assertions.assertEquals((int)expectedSizeBucket, (int)AdaptivePoolingAllocator.sizeBucket((int)this.i), (Supplier)this);
            ++this.i;
        }
    }
}

