/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ReadOnlyByteBufferBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ReadOnlyDirectByteBufferBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class ReadOnlyByteBufferBufTest
extends ReadOnlyDirectByteBufferBufTest {
    @Override
    protected ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    @Test
    public void testCopyDirect() {
        ReadOnlyByteBufferBufTest.testCopy(true);
    }

    @Test
    public void testCopyHeap() {
        ReadOnlyByteBufferBufTest.testCopy(false);
    }

    private static void testCopy(boolean direct) {
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuffer nioBuffer = direct ? ByteBuffer.allocateDirect(bytes.length) : ByteBuffer.allocate(bytes.length);
        nioBuffer.put(bytes).flip();
        ReadOnlyByteBufferBuf buf = new ReadOnlyByteBufferBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, nioBuffer.asReadOnlyBuffer());
        ByteBuf copy = buf.copy();
        Assertions.assertEquals((Object)buf, (Object)copy);
        Assertions.assertEquals((Object)buf.alloc(), (Object)copy.alloc());
        Assertions.assertEquals((Object)buf.isDirect(), (Object)copy.isDirect());
        copy.release();
        buf.release();
    }
}

