/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ReadOnlyByteBufferBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class ReadOnlyDirectByteBufferBufTest {
    protected ByteBuf buffer(ByteBuffer buffer) {
        return new ReadOnlyByteBufferBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, buffer);
    }

    protected ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.buffer(this.allocate(4).asReadOnlyBuffer());
        Assertions.assertTrue((boolean)buf.isContiguous());
        buf.release();
    }

    @Test
    public void testConstructWithWritable() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyDirectByteBufferBufTest.this.buffer(ReadOnlyDirectByteBufferBufTest.this.allocate(1));
            }
        });
    }

    @Test
    public void shouldIndicateNotWritable() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            Assertions.assertFalse((boolean)buf.isWritable());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void shouldIndicateNotWritableAnyNumber() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            Assertions.assertFalse((boolean)buf.isWritable(1));
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void ensureWritableIntStatusShouldFailButNotThrow() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            int result = buf.ensureWritable(1, false);
            Assertions.assertEquals((int)1, (int)result);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void ensureWritableForceIntStatusShouldFailButNotThrow() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            int result = buf.ensureWritable(1, true);
            Assertions.assertEquals((int)1, (int)result);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void ensureWritableShouldThrow() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer()).clear();
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.ensureWritable(1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetByte() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setByte(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetInt() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setInt(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetShort() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setShort(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetMedium() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setMedium(0, 1);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetLong() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setLong(0, 1L);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetBytesViaArray() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setBytes(0, "test".getBytes());
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetBytesViaBuffer() {
        final ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        final ByteBuf copy = Unpooled.copyInt((int)1);
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() {
                    buf.setBytes(0, copy);
                }
            });
        }
        finally {
            buf.release();
            copy.release();
        }
    }

    @Test
    public void testSetBytesViaStream() throws IOException {
        final ByteBuf buf = this.buffer(ByteBuffer.allocateDirect(8).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(ReadOnlyBufferException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    buf.setBytes(0, (InputStream)new ByteArrayInputStream("test".getBytes()), 2);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testGetReadByte() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(2).put(new byte[]{1, 2}).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buf.getByte(0));
        Assertions.assertEquals((int)2, (int)buf.getByte(1));
        Assertions.assertEquals((int)1, (int)buf.readByte());
        Assertions.assertEquals((int)2, (int)buf.readByte());
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadInt() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(8).putInt(1).putInt(2).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buf.getInt(0));
        Assertions.assertEquals((int)2, (int)buf.getInt(4));
        Assertions.assertEquals((int)1, (int)buf.readInt());
        Assertions.assertEquals((int)2, (int)buf.readInt());
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadShort() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(8).putShort((short)1).putShort((short)2).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buf.getShort(0));
        Assertions.assertEquals((int)2, (int)buf.getShort(2));
        Assertions.assertEquals((int)1, (int)buf.readShort());
        Assertions.assertEquals((int)2, (int)buf.readShort());
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    @Test
    public void testGetReadLong() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((long)1L, (long)buf.getLong(0));
        Assertions.assertEquals((long)2L, (long)buf.getLong(8));
        Assertions.assertEquals((long)1L, (long)buf.readLong());
        Assertions.assertEquals((long)2L, (long)buf.readLong());
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        final ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        final ByteBuf buffer = this.buffer(((ByteBuffer)this.allocate(bytes.length).put(bytes).flip()).asReadOnlyBuffer());
        try {
            Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() {
                    buffer.getBytes(buffer.readerIndex(), nioBuffer);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCopy() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        ByteBuf copy = buf.copy();
        Assertions.assertEquals((Object)buf, (Object)copy);
        buf.release();
        copy.release();
    }

    @Test
    public void testCopyWithOffset() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).putLong(2L).flip()).asReadOnlyBuffer());
        ByteBuf copy = buf.copy(1, 9);
        Assertions.assertEquals((Object)buf.slice(1, 9), (Object)copy);
        buf.release();
        copy.release();
    }

    @Test
    public void testWrapBufferWithNonZeroPosition() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putLong(1L).flip().position(1)).asReadOnlyBuffer());
        ByteBuf slice = buf.slice();
        Assertions.assertEquals((Object)buf, (Object)slice);
        buf.release();
    }

    @Test
    public void testWrapBufferRoundTrip() {
        ByteBuf buf = this.buffer(((ByteBuffer)this.allocate(16).putInt(1).putInt(2).flip()).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buf.readInt());
        ByteBuffer nioBuffer = buf.nioBuffer();
        Assertions.assertEquals((int)2, (int)nioBuffer.getInt());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrapMemoryMapped() throws Exception {
        File file = PlatformDependent.createTempFile((String)"netty-test", (String)"tmp", null);
        FileChannel output = null;
        AbstractInterruptibleChannel input = null;
        ByteBuf b1 = null;
        ByteBuf b2 = null;
        try {
            output = new RandomAccessFile(file, "rw").getChannel();
            byte[] bytes = new byte[1024];
            PlatformDependent.threadLocalRandom().nextBytes(bytes);
            output.write(ByteBuffer.wrap(bytes));
            input = new RandomAccessFile(file, "r").getChannel();
            MappedByteBuffer m = ((FileChannel)input).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)input).size());
            b1 = this.buffer(m);
            ByteBuffer dup = ((ByteBuffer)m).duplicate();
            dup.position(2);
            dup.limit(4);
            b2 = this.buffer(dup);
            Assertions.assertEquals((Object)b2, (Object)b1.slice(2, 2));
        }
        finally {
            if (b1 != null) {
                b1.release();
            }
            if (b2 != null) {
                b2.release();
            }
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            file.delete();
        }
    }

    @Test
    public void testMemoryAddress() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertFalse((boolean)buf.hasMemoryAddress());
            try {
                buf.memoryAddress();
                Assertions.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testDuplicate() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertTrue((boolean)buf.duplicate().isReadOnly());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSlice() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertTrue((boolean)buf.slice().isReadOnly());
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DerivedParam.class)
    void testIsWritable(DerivedParam param) {
        ByteBuffer buffer = this.allocate(24);
        ByteBuf buf = this.buffer(buffer.asReadOnlyBuffer());
        buf.writerIndex(8);
        switch (param) {
            case None: {
                break;
            }
            case Duplicate: {
                buf = buf.duplicate();
                break;
            }
            case Slice: {
                buf = buf.slice(0, buf.capacity()).writerIndex(8);
            }
        }
        try {
            Assertions.assertFalse((boolean)buf.isWritable());
            Assertions.assertFalse((boolean)buf.isWritable(1));
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateReadGatheringByteChannelMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuffer nioBuffer = this.allocate(bytes.length);
        nioBuffer.put(bytes);
        nioBuffer.flip();
        ByteBuf buffer = this.buffer(nioBuffer.asReadOnlyBuffer());
        try {
            AbstractByteBufTest.testReadGatheringByteChannelMultipleThreads(buffer, bytes, false);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSliceReadGatheringByteChannelMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuffer nioBuffer = this.allocate(bytes.length);
        nioBuffer.put(bytes);
        nioBuffer.flip();
        ByteBuf buffer = this.buffer(nioBuffer.asReadOnlyBuffer());
        try {
            AbstractByteBufTest.testReadGatheringByteChannelMultipleThreads(buffer, bytes, true);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateReadOutputStreamMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuffer nioBuffer = this.allocate(bytes.length);
        nioBuffer.put(bytes);
        nioBuffer.flip();
        ByteBuf buffer = this.buffer(nioBuffer.asReadOnlyBuffer());
        try {
            AbstractByteBufTest.testReadOutputStreamMultipleThreads(buffer, bytes, false);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSliceReadOutputStreamMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuffer nioBuffer = this.allocate(bytes.length);
        nioBuffer.put(bytes);
        nioBuffer.flip();
        ByteBuf buffer = this.buffer(nioBuffer.asReadOnlyBuffer());
        try {
            AbstractByteBufTest.testReadOutputStreamMultipleThreads(buffer, bytes, true);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateBytesInArrayMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuffer nioBuffer = this.allocate(bytes.length);
        nioBuffer.put(bytes);
        nioBuffer.flip();
        ByteBuf buffer = this.buffer(nioBuffer.asReadOnlyBuffer());
        try {
            AbstractByteBufTest.testBytesInArrayMultipleThreads(buffer, bytes, false);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSliceBytesInArrayMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuffer nioBuffer = this.allocate(bytes.length);
        nioBuffer.put(bytes);
        nioBuffer.flip();
        ByteBuf buffer = this.buffer(nioBuffer.asReadOnlyBuffer());
        try {
            AbstractByteBufTest.testBytesInArrayMultipleThreads(buffer, bytes, true);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testToStringMultipleThreads1() throws Throwable {
        String expected = "Hello, World!";
        byte[] bytes = expected.getBytes(CharsetUtil.ISO_8859_1);
        ByteBuffer nioBuffer = this.allocate(bytes.length);
        nioBuffer.put(bytes);
        nioBuffer.flip();
        ByteBuf buffer = this.buffer(nioBuffer.asReadOnlyBuffer());
        try {
            AbstractByteBufTest.testToStringMultipleThreads0(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testCopyMultipleThreads() throws Throwable {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.testCopyMultipleThreads0(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadOnlyRelease() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        buf.writerIndex(4);
        ReadOnlyDirectByteBufferBufTest.testRelease(buf, buf.asReadOnly());
    }

    @Test
    public void testDuplicateRelease() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        buf.writerIndex(4);
        ReadOnlyDirectByteBufferBufTest.testRelease(buf, buf.duplicate());
    }

    @Test
    public void testSliceRelease() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        buf.writerIndex(4);
        ReadOnlyDirectByteBufferBufTest.testRelease(buf, buf.slice());
    }

    @Test
    public void testDuplicateDuplicateRelease() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        buf.writerIndex(4);
        ReadOnlyDirectByteBufferBufTest.testRelease(buf, buf.duplicate().duplicate());
    }

    @Test
    public void testDuplicateSliceRelease() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        buf.writerIndex(4);
        ReadOnlyDirectByteBufferBufTest.testRelease(buf, buf.duplicate().duplicate());
    }

    @Test
    public void testSliceDuplicateRelease() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        buf.writerIndex(4);
        ReadOnlyDirectByteBufferBufTest.testRelease(buf, buf.slice().duplicate());
    }

    @Test
    public void testSliceSliceRelease() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        buf.writerIndex(4);
        ReadOnlyDirectByteBufferBufTest.testRelease(buf, buf.slice().slice());
    }

    private static void testRelease(ByteBuf parent, ByteBuf derived) {
        Assertions.assertEquals((int)1, (int)parent.refCnt());
        Assertions.assertTrue((boolean)derived.release());
        Assertions.assertEquals((int)0, (int)parent.refCnt());
    }

    @Test
    public void ensureWritableWithForceAsReadyOnly() {
        this.ensureWritableReadOnly(true);
    }

    @Test
    public void ensureWritableWithOutForceAsReadOnly() {
        this.ensureWritableReadOnly(false);
    }

    private void ensureWritableReadOnly(boolean force) {
        ByteBuf buffer = this.buffer(this.allocate(8).asReadOnlyBuffer());
        Assertions.assertEquals((int)1, (int)buffer.ensureWritable(8, force));
        buffer.release();
    }

    @Test
    public void testReadyOnlyNioBuffer() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffer(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlySliceNioBuffer() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffer(buffer.slice());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlyDuplicateNioBuffer() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffer(buffer.duplicate());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlyNioBufferWithPositionLength() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBufferWithPositionLength(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlySliceNioBufferWithPositionLength() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBufferWithPositionLength(buffer.slice());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlyDuplicateNioBufferWithPositionLength() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBufferWithPositionLength(buffer.duplicate());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlyNioBuffers() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffers(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlySliceNioBuffers() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffers(buffer.slice());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlyDuplicateNioBuffers() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffers(buffer.duplicate());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlyNioBuffersWithPositionLength() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffersWithPositionLength(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlySliceNioBuffersWithPositionLength() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffersWithPositionLength(buffer.slice());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadyOnlyDuplicateNioBuffersWithPositionLength() {
        ByteBuf buffer = this.newRandomReadOnlyBuffer();
        try {
            AbstractByteBufTest.assertReadyOnlyNioBuffersWithPositionLength(buffer.duplicate());
        }
        finally {
            buffer.release();
        }
    }

    private ByteBuf newRandomReadOnlyBuffer() {
        byte[] bytes = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuffer nioBuffer = this.allocate(bytes.length);
        nioBuffer.put(bytes);
        nioBuffer.flip();
        return this.buffer(nioBuffer.asReadOnlyBuffer());
    }

    static enum DerivedParam {
        None,
        Duplicate,
        Slice;

    }
}

