/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.util.ArrayDeque;
import java.util.Queue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.NoopResourceLeakTracker;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SimpleLeakAwareByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SimpleLeakAwareCompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.WrappedCompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.WrappedCompositeByteBufTest;
import org.neo4j.driver.internal.shaded.io.netty.util.ByteProcessor;
import org.neo4j.driver.internal.shaded.io.netty.util.ResourceLeakTracker;

public class SimpleLeakAwareCompositeByteBufTest
extends WrappedCompositeByteBufTest {
    private final Class<? extends ByteBuf> clazz = this.leakClass();
    private final Queue<NoopResourceLeakTracker<ByteBuf>> trackers = new ArrayDeque<NoopResourceLeakTracker<ByteBuf>>();

    @Override
    protected final WrappedCompositeByteBuf wrap(CompositeByteBuf buffer) {
        NoopResourceLeakTracker<ByteBuf> tracker = new NoopResourceLeakTracker<ByteBuf>();
        SimpleLeakAwareCompositeByteBuf leakAwareBuf = this.wrap(buffer, tracker);
        this.trackers.add(tracker);
        return leakAwareBuf;
    }

    protected SimpleLeakAwareCompositeByteBuf wrap(CompositeByteBuf buffer, ResourceLeakTracker<ByteBuf> tracker) {
        return new SimpleLeakAwareCompositeByteBuf(buffer, tracker);
    }

    @Override
    @BeforeEach
    public void init() {
        super.init();
        this.trackers.clear();
    }

    @Override
    @AfterEach
    public void dispose() {
        NoopResourceLeakTracker<ByteBuf> tracker;
        super.dispose();
        while ((tracker = this.trackers.poll()) != null) {
            Assertions.assertTrue((boolean)tracker.get());
        }
    }

    protected Class<? extends ByteBuf> leakClass() {
        return SimpleLeakAwareByteBuf.class;
    }

    @Test
    public void testWrapSlice() {
        this.assertWrapped(this.newBuffer(8).slice());
    }

    @Test
    public void testWrapSlice2() {
        this.assertWrapped(this.newBuffer(8).slice(0, 1));
    }

    @Test
    public void testWrapReadSlice() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.readSlice(1));
        } else {
            Assertions.assertTrue((boolean)buffer.release());
        }
    }

    @Test
    public void testWrapRetainedSlice() {
        ByteBuf buffer = this.newBuffer(8);
        this.assertWrapped(buffer.retainedSlice());
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapRetainedSlice2() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.retainedSlice(0, 1));
        }
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapReadRetainedSlice() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.readRetainedSlice(1));
        }
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapDuplicate() {
        this.assertWrapped(this.newBuffer(8).duplicate());
    }

    @Test
    public void testWrapRetainedDuplicate() {
        ByteBuf buffer = this.newBuffer(8);
        this.assertWrapped(buffer.retainedDuplicate());
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapReadOnly() {
        this.assertWrapped(this.newBuffer(8).asReadOnly());
    }

    @Test
    public void forEachByteUnderLeakDetectionShouldNotThrowException() {
        CompositeByteBuf buf = (CompositeByteBuf)this.newBuffer(8);
        MatcherAssert.assertThat((Object)buf, (Matcher)CoreMatchers.instanceOf(SimpleLeakAwareCompositeByteBuf.class));
        CompositeByteBuf comp = (CompositeByteBuf)this.newBuffer(8);
        MatcherAssert.assertThat((Object)comp, (Matcher)CoreMatchers.instanceOf(SimpleLeakAwareCompositeByteBuf.class));
        ByteBuf inner = comp.alloc().directBuffer(1).writeByte(0);
        comp.addComponent(true, inner);
        buf.addComponent(true, (ByteBuf)comp);
        Assertions.assertEquals((int)-1, (int)buf.forEachByte(new ByteProcessor(){

            public boolean process(byte value) {
                return true;
            }
        }));
        Assertions.assertTrue((boolean)buf.release());
    }

    protected final void assertWrapped(ByteBuf buf) {
        try {
            Assertions.assertSame(this.clazz, buf.getClass());
        }
        finally {
            buf.release();
        }
    }
}

