/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;

public class UnreleaseableByteBufTest {
    @Test
    public void testCantRelease() {
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copyInt((int)1));
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        Assertions.assertFalse((boolean)buf.release());
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        Assertions.assertFalse((boolean)buf.release());
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        buf.retain(5);
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        buf.retain();
        Assertions.assertEquals((int)1, (int)buf.refCnt());
        Assertions.assertTrue((boolean)buf.unwrap().release());
        Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    @Test
    public void testWrappedReadOnly() {
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)1).asReadOnly());
        Assertions.assertSame((Object)buf, (Object)buf.asReadOnly());
        Assertions.assertTrue((boolean)buf.unwrap().release());
    }
}

