/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelDuplexHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.ServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.ServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.SocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.DefaultEventExecutorGroup;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutorGroup;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;

public abstract class AbstractEventLoopTest {
    @Test
    public void testReregister() {
        EventLoopGroup group = this.newEventLoopGroup();
        EventLoopGroup group2 = this.newEventLoopGroup();
        DefaultEventExecutorGroup eventExecutorGroup = new DefaultEventExecutorGroup(2);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ChannelFuture future = ((ServerBootstrap)((ServerBootstrap)bootstrap.channel(this.newChannel())).group(group).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
            }
        }).handler((ChannelHandler)new ChannelInitializer<ServerSocketChannel>((EventExecutorGroup)eventExecutorGroup){
            final /* synthetic */ EventExecutorGroup val$eventExecutorGroup;
            {
                this.val$eventExecutorGroup = eventExecutorGroup;
            }

            public void initChannel(ServerSocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new TestChannelHandler()});
                ch.pipeline().addLast(this.val$eventExecutorGroup, new ChannelHandler[]{new TestChannelHandler2()});
            }
        })).bind(0).awaitUninterruptibly();
        EventExecutor executor = future.channel().pipeline().context(TestChannelHandler2.class).executor();
        EventExecutor executor1 = future.channel().pipeline().context(TestChannelHandler.class).executor();
        future.channel().deregister().awaitUninterruptibly();
        Channel channel = group2.register(future.channel()).awaitUninterruptibly().channel();
        EventExecutor executorNew = channel.pipeline().context(TestChannelHandler.class).executor();
        Assertions.assertNotSame((Object)executor1, (Object)executorNew);
        Assertions.assertSame((Object)executor, (Object)future.channel().pipeline().context(TestChannelHandler2.class).executor());
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownGracefullyNoQuietPeriod() throws Exception {
        EventLoopGroup loop = this.newEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(loop).channel(this.newChannel())).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        b.bind(0).sync().channel();
        Future f = loop.shutdownGracefully(0L, 1L, TimeUnit.MINUTES);
        Assertions.assertTrue((boolean)loop.awaitTermination(600L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)f.syncUninterruptibly().isSuccess());
        Assertions.assertTrue((boolean)loop.isShutdown());
        Assertions.assertTrue((boolean)loop.isTerminated());
    }

    protected abstract EventLoopGroup newEventLoopGroup();

    protected abstract Class<? extends ServerChannel> newChannel();

    private static final class TestChannelHandler2
    extends ChannelDuplexHandler {
        private TestChannelHandler2() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        }
    }

    private static final class TestChannelHandler
    extends ChannelDuplexHandler {
        private TestChannelHandler() {
        }
    }
}

