/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.CompleteChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class CompleteChannelFutureTest {
    @Test
    public void shouldDisallowNullChannel() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new CompleteChannelFutureImpl(null);
            }
        });
    }

    @Test
    public void shouldNotDoAnythingOnRemove() {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        CompleteChannelFutureImpl future = new CompleteChannelFutureImpl(channel);
        ChannelFutureListener l = (ChannelFutureListener)Mockito.mock(ChannelFutureListener.class);
        future.removeListener((GenericFutureListener)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{l});
        Mockito.verifyZeroInteractions((Object[])new Object[]{channel});
    }

    @Test
    public void testConstantProperties() throws InterruptedException {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        CompleteChannelFutureImpl future = new CompleteChannelFutureImpl(channel);
        Assertions.assertSame((Object)channel, (Object)future.channel());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertSame((Object)((Object)future), (Object)future.await());
        Assertions.assertTrue((boolean)future.await(1L));
        Assertions.assertTrue((boolean)future.await(1L, TimeUnit.NANOSECONDS));
        Assertions.assertSame((Object)((Object)future), (Object)future.awaitUninterruptibly());
        Assertions.assertTrue((boolean)future.awaitUninterruptibly(1L));
        Assertions.assertTrue((boolean)future.awaitUninterruptibly(1L, TimeUnit.NANOSECONDS));
        Mockito.verifyZeroInteractions((Object[])new Object[]{channel});
    }

    private static class CompleteChannelFutureImpl
    extends CompleteChannelFuture {
        CompleteChannelFutureImpl(Channel channel) {
            super(channel, null);
        }

        public Throwable cause() {
            throw new Error();
        }

        public boolean isSuccess() {
            throw new Error();
        }

        public ChannelFuture sync() throws InterruptedException {
            throw new Error();
        }

        public ChannelFuture syncUninterruptibly() {
            throw new Error();
        }
    }
}

